/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.enums.SslRequired;
import org.keycloak.exportimport.util.ImportUtils;
import org.keycloak.models.AccountRoles;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.models.ClientModel;
import org.keycloak.models.Constants;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.UsersSyncManager;
import org.keycloak.timer.TimerProvider;

public class RealmManager {
    protected static final Logger logger = Logger.getLogger(RealmManager.class);
    protected KeycloakSession session;
    protected RealmProvider model;
    protected String contextPath = "";

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public RealmManager(KeycloakSession session) {
        this.session = session;
        this.model = session.realms();
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public RealmModel getKeycloakAdminstrationRealm() {
        return this.getRealm(Config.getAdminRealm());
    }

    public RealmModel getRealm(String id) {
        return this.model.getRealm(id);
    }

    public RealmModel getRealmByName(String name) {
        return this.model.getRealmByName(name);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(name, name);
    }

    public RealmModel createRealm(String id, String name) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        RealmModel realm = this.model.createRealm(id, name);
        realm.setName(name);
        this.setupRealmDefaults(realm);
        this.setupMasterAdminManagement(realm);
        this.setupRealmAdminManagement(realm);
        this.setupAccountManagement(realm);
        this.setupBrokerService(realm);
        this.setupAdminConsole(realm);
        return realm;
    }

    protected void setupAdminConsole(RealmModel realm) {
        RoleModel adminRole;
        ClientModel adminConsole = realm.getClientByClientId("security-admin-console");
        if (adminConsole == null) {
            adminConsole = new ClientManager(this).createClient(realm, "security-admin-console");
        }
        adminConsole.setName("${client_security-admin-console}");
        String baseUrl = this.contextPath + "/admin/" + realm.getName() + "/console";
        adminConsole.setBaseUrl(baseUrl + "/index.html");
        adminConsole.setEnabled(true);
        adminConsole.setPublicClient(true);
        adminConsole.addRedirectUri(baseUrl + "/*");
        adminConsole.setFullScopeAllowed(false);
        if (realm.getName().equals(Config.getAdminRealm())) {
            adminRole = realm.getRole(AdminRoles.ADMIN);
        } else {
            String realmAdminApplicationClientId = this.getRealmAdminClientId(realm);
            ClientModel realmAdminApp = realm.getClientByClientId(realmAdminApplicationClientId);
            adminRole = realmAdminApp.getRole(AdminRoles.REALM_ADMIN);
        }
        adminConsole.addScopeMapping(adminRole);
    }

    public String getRealmAdminClientId(RealmModel realm) {
        return "realm-management";
    }

    public String getRealmAdminClientId(RealmRepresentation realm) {
        return "realm-management";
    }

    protected void setupRealmDefaults(RealmModel realm) {
        realm.setBrowserSecurityHeaders(BrowserSecurityHeaders.defaultHeaders);
        realm.setBruteForceProtected(false);
        realm.setMaxFailureWaitSeconds(900);
        realm.setMinimumQuickLoginWaitSeconds(60);
        realm.setWaitIncrementSeconds(60);
        realm.setQuickLoginCheckMilliSeconds(1000L);
        realm.setMaxDeltaTimeSeconds(43200);
        realm.setFailureFactor(30);
        realm.setSslRequired(SslRequired.EXTERNAL);
        realm.setEventsListeners(Collections.singleton("jboss-logging"));
    }

    public boolean removeRealm(RealmModel realm) {
        List federationProviders = realm.getUserFederationProviders();
        boolean removed = this.model.removeRealm(realm.getId());
        if (removed) {
            new ClientManager(this).removeClient(this.getKeycloakAdminstrationRealm(), realm.getMasterAdminClient());
            UserSessionProvider sessions = this.session.sessions();
            if (sessions != null) {
                sessions.onRealmRemoved(realm);
            }
            UsersSyncManager usersSyncManager = new UsersSyncManager();
            for (UserFederationProviderModel fedProvider : federationProviders) {
                usersSyncManager.removePeriodicSyncForProvider((TimerProvider)this.session.getProvider(TimerProvider.class), fedProvider);
            }
        }
        return removed;
    }

    public void updateRealmEventsConfig(RealmEventsConfigRepresentation rep, RealmModel realm) {
        realm.setEventsEnabled(rep.isEventsEnabled());
        realm.setEventsExpiration(rep.getEventsExpiration() != null ? rep.getEventsExpiration() : 0L);
        if (rep.getEventsListeners() != null) {
            realm.setEventsListeners(new HashSet(rep.getEventsListeners()));
        }
        if (rep.getEnabledEventTypes() != null) {
            realm.setEnabledEventTypes(new HashSet(rep.getEnabledEventTypes()));
        }
    }

    private void setupMasterAdminManagement(RealmModel realm) {
        ImportUtils.setupMasterAdminManagement((RealmProvider)this.model, (RealmModel)realm);
    }

    private void setupRealmAdminManagement(RealmModel realm) {
        if (realm.getName().equals(Config.getAdminRealm())) {
            return;
        }
        ClientManager clientManager = new ClientManager(new RealmManager(this.session));
        String realmAdminClientId = this.getRealmAdminClientId(realm);
        ClientModel realmAdminClient = realm.getClientByClientId(realmAdminClientId);
        if (realmAdminClient == null) {
            realmAdminClient = clientManager.createClient(realm, realmAdminClientId);
            realmAdminClient.setName("${client_" + realmAdminClientId + "}");
        }
        RoleModel adminRole = realmAdminClient.addRole(AdminRoles.REALM_ADMIN);
        adminRole.setDescription("${role_" + AdminRoles.REALM_ADMIN + "}");
        realmAdminClient.setBearerOnly(true);
        realmAdminClient.setFullScopeAllowed(false);
        for (String r : AdminRoles.ALL_REALM_ROLES) {
            RoleModel role = realmAdminClient.addRole(r);
            role.setDescription("${role_" + r + "}");
            adminRole.addCompositeRole(role);
        }
    }

    private void setupAccountManagement(RealmModel realm) {
        ClientModel client = (ClientModel)realm.getClientNameMap().get("account");
        if (client == null) {
            client = new ClientManager(this).createClient(realm, "account");
            client.setName("${client_account}");
            client.setEnabled(true);
            client.setFullScopeAllowed(false);
            String base = this.contextPath + "/realms/" + realm.getName() + "/account";
            String redirectUri = base + "/*";
            client.addRedirectUri(redirectUri);
            client.setBaseUrl(base);
            for (String role : AccountRoles.ALL) {
                client.addDefaultRole(role);
                client.getRole(role).setDescription("${role_" + role + "}");
            }
        }
    }

    public void setupBrokerService(RealmModel realm) {
        ClientModel client = (ClientModel)realm.getClientNameMap().get("broker");
        if (client == null) {
            client = new ClientManager(this).createClient(realm, "broker");
            client.setEnabled(true);
            client.setName("${client_broker}");
            client.setFullScopeAllowed(false);
            for (String role : Constants.BROKER_SERVICE_ROLES) {
                client.addRole(role).setDescription("${role_" + role.toLowerCase().replaceAll("_", "-") + "}");
            }
        }
    }

    public RealmModel importRealm(RealmRepresentation rep) {
        String id = rep.getId();
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        RealmModel realm = this.model.createRealm(id, rep.getRealm());
        realm.setName(rep.getRealm());
        this.setupRealmDefaults(realm);
        this.setupMasterAdminManagement(realm);
        if (!this.hasRealmAdminManagementClient(rep)) {
            this.setupRealmAdminManagement(realm);
        }
        if (!this.hasAccountManagementClient(rep)) {
            this.setupAccountManagement(realm);
        }
        if (!this.hasBrokerClient(rep)) {
            this.setupBrokerService(realm);
        }
        if (!this.hasAdminConsoleClient(rep)) {
            this.setupAdminConsole(realm);
        }
        RepresentationToModel.importRealm((KeycloakSession)this.session, (RealmRepresentation)rep, (RealmModel)realm);
        List federationProviders = realm.getUserFederationProviders();
        UsersSyncManager usersSyncManager = new UsersSyncManager();
        for (UserFederationProviderModel fedProvider : federationProviders) {
            usersSyncManager.refreshPeriodicSyncForProvider(this.session.getKeycloakSessionFactory(), (TimerProvider)this.session.getProvider(TimerProvider.class), fedProvider, realm.getId());
        }
        return realm;
    }

    private boolean hasRealmAdminManagementClient(RealmRepresentation rep) {
        if (rep.getClients() == null) {
            return false;
        }
        for (ClientRepresentation clientRep : rep.getClients()) {
            if (!clientRep.getClientId().equals(this.getRealmAdminClientId(rep))) continue;
            return true;
        }
        return false;
    }

    private boolean hasAccountManagementClient(RealmRepresentation rep) {
        if (rep.getClients() == null) {
            return false;
        }
        for (ClientRepresentation clientRep : rep.getClients()) {
            if (!clientRep.getClientId().equals("account")) continue;
            return true;
        }
        return false;
    }

    private boolean hasBrokerClient(RealmRepresentation rep) {
        if (rep.getClients() == null) {
            return false;
        }
        for (ClientRepresentation clientRep : rep.getClients()) {
            if (!clientRep.getClientId().equals("broker")) continue;
            return true;
        }
        return false;
    }

    private boolean hasAdminConsoleClient(RealmRepresentation rep) {
        if (rep.getClients() == null) {
            return false;
        }
        for (ClientRepresentation clientRep : rep.getClients()) {
            if (!clientRep.getClientId().equals("security-admin-console")) continue;
            return true;
        }
        return false;
    }

    public List<UserModel> searchUsers(String searchString, RealmModel realmModel) {
        if (searchString == null) {
            return Collections.emptyList();
        }
        return this.session.users().searchForUser(searchString.trim(), realmModel);
    }
}

