/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.services.resources.admin.RealmAuth;

public class ProtocolMappersResource {
    protected static final Logger logger = Logger.getLogger(ProtocolMappersResource.class);
    protected ClientModel client;
    protected RealmAuth auth;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakSession session;

    public ProtocolMappersResource(ClientModel client, RealmAuth auth) {
        this.auth = auth;
        this.client = client;
        auth.init(RealmAuth.Resource.USER);
    }

    @GET
    @NoCache
    @Path(value="protocol/{protocol}")
    @Produces(value={"application/json"})
    public List<ProtocolMapperRepresentation> getMappersPerProtocol(@PathParam(value="protocol") String protocol) {
        this.auth.requireView();
        LinkedList<ProtocolMapperRepresentation> mappers = new LinkedList<ProtocolMapperRepresentation>();
        for (ProtocolMapperModel mapper : this.client.getProtocolMappers()) {
            if (!mapper.getProtocol().equals(protocol)) continue;
            mappers.add(ModelToRepresentation.toRepresentation((ProtocolMapperModel)mapper));
        }
        return mappers;
    }

    @Path(value="models")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response createMapper(ProtocolMapperRepresentation rep) {
        this.auth.requireManage();
        ProtocolMapperModel model = RepresentationToModel.toModel((ProtocolMapperRepresentation)rep);
        model = this.client.addProtocolMapper(model);
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
    }

    @Path(value="add-models")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public void createMapper(List<ProtocolMapperRepresentation> reps) {
        this.auth.requireManage();
        for (ProtocolMapperRepresentation rep : reps) {
            ProtocolMapperModel model = RepresentationToModel.toModel((ProtocolMapperRepresentation)rep);
            model = this.client.addProtocolMapper(model);
        }
    }

    @GET
    @NoCache
    @Path(value="models")
    @Produces(value={"application/json"})
    public List<ProtocolMapperRepresentation> getMappers() {
        this.auth.requireView();
        LinkedList<ProtocolMapperRepresentation> mappers = new LinkedList<ProtocolMapperRepresentation>();
        for (ProtocolMapperModel mapper : this.client.getProtocolMappers()) {
            mappers.add(ModelToRepresentation.toRepresentation((ProtocolMapperModel)mapper));
        }
        return mappers;
    }

    @GET
    @NoCache
    @Path(value="models/{id}")
    @Produces(value={"application/json"})
    public ProtocolMapperRepresentation getMapperById(@PathParam(value="id") String id) {
        this.auth.requireView();
        ProtocolMapperModel model = this.client.getProtocolMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        return ModelToRepresentation.toRepresentation((ProtocolMapperModel)model);
    }

    @PUT
    @NoCache
    @Path(value="models/{id}")
    @Consumes(value={"application/json"})
    public void update(@PathParam(value="id") String id, ProtocolMapperRepresentation rep) {
        this.auth.requireManage();
        ProtocolMapperModel model = this.client.getProtocolMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        model = RepresentationToModel.toModel((ProtocolMapperRepresentation)rep);
        this.client.updateProtocolMapper(model);
    }

    @DELETE
    @NoCache
    @Path(value="models/{id}")
    public void delete(@PathParam(value="id") String id) {
        this.auth.requireManage();
        ProtocolMapperModel model = this.client.getProtocolMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        this.client.removeProtocolMapper(model);
    }
}

