/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.net.URI;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.ClientConnection;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCLoginProtocol;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.services.ErrorPageException;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.HttpAuthenticationManager;

public class AuthorizationEndpoint {
    private static final Logger logger = Logger.getLogger(AuthorizationEndpoint.class);
    @Context
    private KeycloakSession session;
    @Context
    private HttpRequest request;
    @Context
    private HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private ClientConnection clientConnection;
    private final AuthenticationManager authManager;
    private final RealmModel realm;
    private final EventBuilder event;
    private ClientModel client;
    private ClientSessionModel clientSession;
    private Action action;
    private String clientId;
    private String redirectUri;
    private String redirectUriParam;
    private String responseType;
    private String state;
    private String scope;
    private String loginHint;
    private String prompt;
    private String idpHint;
    private String legacyResponseType;

    public AuthorizationEndpoint(AuthenticationManager authManager, RealmModel realm, EventBuilder event) {
        this.authManager = authManager;
        this.realm = realm;
        this.event = event;
        event.event(EventType.LOGIN);
    }

    @GET
    public Response build() {
        MultivaluedMap params = this.uriInfo.getQueryParameters();
        this.clientId = (String)params.getFirst((Object)"client_id");
        this.responseType = (String)params.getFirst((Object)"response_type");
        this.redirectUriParam = (String)params.getFirst((Object)"redirect_uri");
        this.state = (String)params.getFirst((Object)"state");
        this.scope = (String)params.getFirst((Object)"scope");
        this.loginHint = (String)params.getFirst((Object)"login_hint");
        this.prompt = (String)params.getFirst((Object)"prompt");
        this.idpHint = (String)params.getFirst((Object)"kc_idp_hint");
        this.checkSsl();
        this.checkRealm();
        this.checkClient();
        this.checkResponseType();
        this.checkRedirectUri();
        this.createClientSession();
        switch (this.action) {
            case REGISTER: {
                return this.buildRegister();
            }
            case CODE: {
                return this.buildAuthorizationCodeAuthorizationResponse();
            }
        }
        throw new RuntimeException("Unknown action " + (Object)((Object)this.action));
    }

    public AuthorizationEndpoint legacy(String legacyResponseType) {
        logger.warnv("Invoking deprecated endpoint {0}", (Object)this.uriInfo.getRequestUri());
        this.legacyResponseType = legacyResponseType;
        return this;
    }

    public AuthorizationEndpoint register() {
        this.event.event(EventType.REGISTER);
        this.action = Action.REGISTER;
        if (!this.realm.isRegistrationAllowed()) {
            throw new ErrorPageException(this.session, "registrationNotAllowedMessage", new Object[0]);
        }
        return this;
    }

    private void checkSsl() {
        if (!this.uriInfo.getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            this.event.error("ssl_required");
            throw new ErrorPageException(this.session, "httpsRequiredMessage", new Object[0]);
        }
    }

    private void checkRealm() {
        if (!this.realm.isEnabled()) {
            this.event.error("realm_disabled");
            throw new ErrorPageException(this.session, "realmNotEnabledMessage", new Object[0]);
        }
    }

    private void checkClient() {
        if (this.clientId == null) {
            this.event.error("invalid_request");
            throw new ErrorPageException(this.session, "missingParameterMessage", "client_id");
        }
        this.event.client(this.clientId);
        this.client = this.realm.getClientByClientId(this.clientId);
        if (this.client == null) {
            this.event.error("client_not_found");
            throw new ErrorPageException(this.session, "clientNotFoundMessage", new Object[0]);
        }
        if (this.client.isBearerOnly()) {
            this.event.error("not_allowed");
            throw new ErrorPageException(this.session, "bearerOnlyMessage", new Object[0]);
        }
        if (this.client.isDirectGrantsOnly()) {
            this.event.error("not_allowed");
            throw new ErrorPageException(this.session, "directGrantsOnlyMessage", new Object[0]);
        }
        this.session.getContext().setClient(this.client);
    }

    private void checkResponseType() {
        if (this.responseType == null) {
            if (this.legacyResponseType != null) {
                this.responseType = this.legacyResponseType;
            } else {
                this.event.error("invalid_request");
                throw new ErrorPageException(this.session, "missingParameterMessage", "response_type");
            }
        }
        this.event.detail("response_type", this.responseType);
        if (this.responseType.equals("code")) {
            if (this.action == null) {
                this.action = Action.CODE;
            }
        } else {
            this.event.error("invalid_request");
            throw new ErrorPageException(this.session, "invalidParameterMessage", "response_type");
        }
    }

    private void checkRedirectUri() {
        this.event.detail("redirect_uri", this.redirectUriParam);
        this.redirectUri = RedirectUtils.verifyRedirectUri(this.uriInfo, this.redirectUriParam, this.realm, this.client);
        if (this.redirectUri == null) {
            this.event.error("invalid_redirect_uri");
            throw new ErrorPageException(this.session, "invalidParameterMessage", "redirect_uri");
        }
    }

    private void createClientSession() {
        this.clientSession = this.session.sessions().createClientSession(this.realm, this.client);
        this.clientSession.setAuthMethod("openid-connect");
        this.clientSession.setRedirectUri(this.redirectUri);
        this.clientSession.setAction(ClientSessionModel.Action.AUTHENTICATE);
        this.clientSession.setNote("action_key", KeycloakModelUtils.generateCodeSecret());
        this.clientSession.setNote("response_type", this.responseType);
        this.clientSession.setNote("redirect_uri", this.redirectUriParam);
        this.clientSession.setNote("iss", Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
        if (this.state != null) {
            this.clientSession.setNote("state", this.state);
        }
        if (this.scope != null) {
            this.clientSession.setNote("scope", this.scope);
        }
        if (this.loginHint != null) {
            this.clientSession.setNote("login_hint", this.loginHint);
        }
        if (this.prompt != null) {
            this.clientSession.setNote("prompt", this.prompt);
        }
        if (this.idpHint != null) {
            this.clientSession.setNote("kc_idp_hint", this.idpHint);
        }
    }

    private Response buildAuthorizationCodeAuthorizationResponse() {
        String accessCode = new ClientSessionCode(this.realm, this.clientSession).getCode();
        if (this.idpHint != null && !"".equals(this.idpHint)) {
            IdentityProviderModel identityProviderModel = this.realm.getIdentityProviderByAlias(this.idpHint);
            if (identityProviderModel == null) {
                return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setError("identityProviderNotFoundMessage", new Object[]{this.idpHint}).createErrorPage();
            }
            return this.buildRedirectToIdentityProvider(this.idpHint, accessCode);
        }
        return this.oldBrowserAuthentication(accessCode);
    }

    protected Response newBrowserAuthentication(String accessCode) {
        String flowId = null;
        for (AuthenticationFlowModel flow : this.realm.getAuthenticationFlows()) {
            if (!flow.getAlias().equals("browser")) continue;
            flowId = flow.getId();
            break;
        }
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setClientSession(this.clientSession).setFlowId(flowId).setConnection(this.clientConnection).setEventBuilder(this.event).setProtector(this.authManager.getProtector()).setRealm(this.realm).setSession(this.session).setUriInfo(this.uriInfo).setRequest(this.request);
        return processor.authenticate();
    }

    protected Response oldBrowserAuthentication(String accessCode) {
        Response response = this.authManager.checkNonFormAuthentication(this.session, this.clientSession, this.realm, this.uriInfo, this.request, this.clientConnection, this.headers, this.event);
        if (response != null) {
            return response;
        }
        HttpAuthenticationManager httpAuthManager = new HttpAuthenticationManager(this.session, this.clientSession, this.realm, this.uriInfo, this.request, this.clientConnection, this.event);
        HttpAuthenticationManager.HttpAuthOutput httpAuthOutput = httpAuthManager.spnegoAuthenticate(this.headers);
        if (httpAuthOutput.getResponse() != null) {
            return httpAuthOutput.getResponse();
        }
        if (this.prompt != null && this.prompt.equals("none")) {
            OIDCLoginProtocol oauth = new OIDCLoginProtocol(this.session, this.realm, this.uriInfo, this.headers, this.event);
            return oauth.cancelLogin(this.clientSession);
        }
        List identityProviders = this.realm.getIdentityProviders();
        for (IdentityProviderModel identityProvider : identityProviders) {
            if (!identityProvider.isAuthenticateByDefault()) continue;
            return this.buildRedirectToIdentityProvider(identityProvider.getAlias(), accessCode);
        }
        List requiredCredentials = this.realm.getRequiredCredentials();
        if (requiredCredentials.isEmpty()) {
            if (!identityProviders.isEmpty()) {
                if (identityProviders.size() == 1) {
                    return this.buildRedirectToIdentityProvider(((IdentityProviderModel)identityProviders.get(0)).getAlias(), accessCode);
                }
                return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setError("identityProviderNotUniqueMessage", new Object[]{this.realm.getName()}).createErrorPage();
            }
            return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setError("realmSupportsNoCredentialsMessage", new Object[]{this.realm.getName()}).createErrorPage();
        }
        LoginFormsProvider forms = ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setClientSessionCode(accessCode);
        if (httpAuthOutput.getChallenge() != null) {
            httpAuthOutput.getChallenge().sendChallenge(forms);
        }
        String rememberMeUsername = AuthenticationManager.getRememberMeUsername(this.realm, this.headers);
        if (this.loginHint != null || rememberMeUsername != null) {
            MultivaluedMapImpl formData = new MultivaluedMapImpl();
            if (this.loginHint != null) {
                formData.add((Object)"username", (Object)this.loginHint);
            } else {
                formData.add((Object)"username", (Object)rememberMeUsername);
                formData.add((Object)"rememberMe", (Object)"on");
            }
            forms.setFormData((MultivaluedMap)formData);
        }
        return forms.createLogin();
    }

    private Response buildRegister() {
        AuthenticationManager.expireIdentityCookie(this.realm, this.uriInfo, this.clientConnection);
        return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setClientSessionCode(new ClientSessionCode(this.realm, this.clientSession).getCode()).createRegistration();
    }

    private Response buildRedirectToIdentityProvider(String providerId, String accessCode) {
        logger.debug((Object)("Automatically redirect to identity provider: " + providerId));
        return Response.temporaryRedirect((URI)Urls.identityProviderAuthnRequest(this.uriInfo.getBaseUri(), providerId, this.realm.getName(), accessCode)).build();
    }

    private static enum Action {
        REGISTER,
        CODE;

    }
}

