/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ClientAttributeCertificateResource;
import org.keycloak.services.resources.admin.ProtocolMappersResource;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.ScopeMappedResource;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.Time;

public class ClientResource {
    protected static final Logger logger = Logger.getLogger(ClientResource.class);
    protected RealmModel realm;
    private RealmAuth auth;
    private AdminEventBuilder adminEvent;
    protected ClientModel client;
    protected KeycloakSession session;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakApplication keycloak;

    protected KeycloakApplication getKeycloakApplication() {
        return this.keycloak;
    }

    public ClientResource(RealmModel realm, RealmAuth auth, ClientModel clientModel, KeycloakSession session, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.auth = auth;
        this.client = clientModel;
        this.session = session;
        this.adminEvent = adminEvent;
        auth.init(RealmAuth.Resource.CLIENT);
    }

    @Path(value="protocol-mappers")
    public ProtocolMappersResource getProtocolMappers() {
        ProtocolMappersResource mappers = new ProtocolMappersResource(this.client, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)mappers);
        return mappers;
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response update(ClientRepresentation rep) {
        this.auth.requireManage();
        try {
            RepresentationToModel.updateClient((ClientRepresentation)rep, (ClientModel)this.client);
            this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(rep).success();
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Client " + rep.getClientId() + " already exists");
        }
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public ClientRepresentation getClient() {
        this.auth.requireView();
        return ModelToRepresentation.toRepresentation((ClientModel)this.client);
    }

    @Path(value="certificates/{attr}")
    public ClientAttributeCertificateResource getCertficateResource(@PathParam(value="attr") String attributePrefix) {
        return new ClientAttributeCertificateResource(this.realm, this.auth, this.client, this.session, attributePrefix, this.adminEvent);
    }

    @GET
    @NoCache
    @Path(value="installation/json")
    @Produces(value={"application/json"})
    public String getInstallation() throws IOException {
        this.auth.requireView();
        ClientManager clientManager = new ClientManager(new RealmManager(this.session));
        ClientManager.InstallationAdapterConfig rep = clientManager.toInstallationRepresentation(this.realm, this.client, this.getKeycloakApplication().getBaseUri(this.uriInfo));
        return JsonSerialization.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rep);
    }

    @GET
    @NoCache
    @Path(value="installation/jboss")
    @Produces(value={"text/plain"})
    public String getJBossInstallation() throws IOException {
        this.auth.requireView();
        ClientManager clientManager = new ClientManager(new RealmManager(this.session));
        return clientManager.toJBossSubsystemConfig(this.realm, this.client, this.getKeycloakApplication().getBaseUri(this.uriInfo));
    }

    @DELETE
    @NoCache
    public void deleteClient() {
        this.auth.requireManage();
        new ClientManager(new RealmManager(this.session)).removeClient(this.realm, this.client);
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    @Path(value="client-secret")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public CredentialRepresentation regenerateSecret() {
        this.auth.requireManage();
        logger.debug((Object)"regenerateSecret");
        UserCredentialModel cred = KeycloakModelUtils.generateSecret((ClientModel)this.client);
        CredentialRepresentation rep = ModelToRepresentation.toRepresentation((UserCredentialModel)cred);
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).representation(rep).success();
        return rep;
    }

    @Path(value="client-secret")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public CredentialRepresentation getClientSecret() {
        this.auth.requireView();
        logger.debug((Object)"getClientSecret");
        UserCredentialModel model = UserCredentialModel.secret((String)this.client.getSecret());
        if (model == null) {
            throw new NotFoundException("Client does not have a secret");
        }
        return ModelToRepresentation.toRepresentation((UserCredentialModel)model);
    }

    @Path(value="scope-mappings")
    public ScopeMappedResource getScopeMappedResource() {
        return new ScopeMappedResource(this.realm, this.auth, this.client, this.session, this.adminEvent);
    }

    @Path(value="roles")
    public RoleContainerResource getRoleContainerResource() {
        return new RoleContainerResource(this.uriInfo, this.realm, this.auth, (RoleContainerModel)this.client, this.adminEvent);
    }

    @Path(value="allowed-origins")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<String> getAllowedOrigins() {
        this.auth.requireView();
        return this.client.getWebOrigins();
    }

    @Path(value="allowed-origins")
    @PUT
    @Consumes(value={"application/json"})
    public void updateAllowedOrigins(Set<String> allowedOrigins) {
        this.auth.requireManage();
        this.client.setWebOrigins(allowedOrigins);
        this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(this.client).success();
    }

    @Path(value="allowed-origins")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteAllowedOrigins(Set<String> allowedOrigins) {
        this.auth.requireManage();
        for (String origin : allowedOrigins) {
            this.client.removeWebOrigin(origin);
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    @Path(value="push-revocation")
    @POST
    public GlobalRequestResult pushRevocation() {
        this.auth.requireManage();
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
        return new ResourceAdminManager(this.session).pushClientRevocationPolicy(this.uriInfo.getRequestUri(), this.realm, this.client);
    }

    @Path(value="session-count")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, Integer> getApplicationSessionCount() {
        this.auth.requireView();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("count", this.session.sessions().getActiveUserSessions(this.client.getRealm(), this.client));
        return map;
    }

    @Path(value="user-sessions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserSessionRepresentation> getUserSessions(@QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        this.auth.requireView();
        firstResult = firstResult != null ? firstResult : -1;
        maxResults = maxResults != null ? maxResults : -1;
        ArrayList<UserSessionRepresentation> sessions = new ArrayList<UserSessionRepresentation>();
        for (UserSessionModel userSession : this.session.sessions().getUserSessions(this.client.getRealm(), this.client, firstResult.intValue(), maxResults.intValue())) {
            UserSessionRepresentation rep = ModelToRepresentation.toRepresentation((UserSessionModel)userSession);
            sessions.add(rep);
        }
        return sessions;
    }

    @Path(value="logout-all")
    @POST
    public GlobalRequestResult logoutAll() {
        this.auth.requireManage();
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
        return new ResourceAdminManager(this.session).logoutClient(this.uriInfo.getRequestUri(), this.realm, this.client);
    }

    @Path(value="logout-user/{username}")
    @POST
    public void logout(@PathParam(value="username") String username) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
        new ResourceAdminManager(this.session).logoutUserFromClient(this.uriInfo.getRequestUri(), this.realm, this.client, user);
    }

    @Path(value="nodes")
    @POST
    @Consumes(value={"application/json"})
    public void registerNode(Map<String, String> formParams) {
        this.auth.requireManage();
        String node = formParams.get("node");
        if (node == null) {
            throw new BadRequestException("Node not found in params");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Register node: " + node));
        }
        this.client.registerNode(node, Time.currentTime());
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
    }

    @Path(value="nodes/{node}")
    @DELETE
    @NoCache
    public void unregisterNode(@PathParam(value="node") String node) {
        Integer time;
        this.auth.requireManage();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unregister node: " + node));
        }
        if ((time = (Integer)this.client.getRegisteredNodes().get(node)) == null) {
            throw new NotFoundException("Client does not have a node " + node);
        }
        this.client.unregisterNode(node);
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    @Path(value="test-nodes-available")
    @GET
    @NoCache
    public GlobalRequestResult testNodesAvailable() {
        this.auth.requireManage();
        logger.debug((Object)"Test availability of cluster nodes");
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
        return new ResourceAdminManager(this.session).testNodesAvailability(this.uriInfo.getRequestUri(), this.realm, this.client);
    }
}

