/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.account.freemarker.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.logging.Logger;
import org.keycloak.models.UserModel;

public class AccountBean {
    private static final Logger logger = Logger.getLogger(AccountBean.class);
    private final UserModel user;
    private final MultivaluedMap<String, String> profileFormData;
    private final Map<String, String> attributes = new HashMap<String, String>();

    public AccountBean(UserModel user, MultivaluedMap<String, String> profileFormData) {
        this.user = user;
        this.profileFormData = profileFormData;
        for (Map.Entry attr : user.getAttributes().entrySet()) {
            List attrValue = (List)attr.getValue();
            if (attrValue.size() > 0) {
                this.attributes.put((String)attr.getKey(), (String)attrValue.get(0));
            }
            if (attrValue.size() <= 1) continue;
            logger.warnf("There are more values for attribute '%s' of user '%s' . Will display just first value", attr.getKey(), (Object)user.getUsername());
        }
        if (profileFormData != null) {
            for (String key : profileFormData.keySet()) {
                if (!key.startsWith("user.attributes.")) continue;
                String attribute = key.substring("user.attributes.".length());
                this.attributes.put(attribute, (String)profileFormData.getFirst((Object)key));
            }
        }
    }

    public String getFirstName() {
        return this.profileFormData != null ? (String)this.profileFormData.getFirst((Object)"firstName") : this.user.getFirstName();
    }

    public String getLastName() {
        return this.profileFormData != null ? (String)this.profileFormData.getFirst((Object)"lastName") : this.user.getLastName();
    }

    public String getUsername() {
        return this.profileFormData != null ? (String)this.profileFormData.getFirst((Object)"username") : this.user.getUsername();
    }

    public String getEmail() {
        return this.profileFormData != null ? (String)this.profileFormData.getFirst((Object)"email") : this.user.getEmail();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

