/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.docker.installation.compose;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.net.URL;

public class DockerComposeYamlFile {
    private final String registryDataDirName;
    private final String localCertDirName;
    private final String containerCertPath;
    private final String localhostCrtFileName;
    private final String localhostKeyFileName;
    private final String authServerTrustChainFileName;
    private final URL authServerUrl;
    private final String realmName;
    private final String serviceId;

    public DockerComposeYamlFile(String registryDataDirName, String localCertDirName, String containerCertPath, String localhostCrtFileName, String localhostKeyFileName, String authServerTrustChainFileName, URL authServerUrl, String realmName, String serviceId) {
        this.registryDataDirName = registryDataDirName;
        this.localCertDirName = localCertDirName;
        this.containerCertPath = containerCertPath;
        this.localhostCrtFileName = localhostCrtFileName;
        this.localhostKeyFileName = localhostKeyFileName;
        this.authServerTrustChainFileName = authServerTrustChainFileName;
        this.authServerUrl = authServerUrl;
        this.realmName = realmName;
        this.serviceId = serviceId;
    }

    public byte[] generateDockerComposeFileBytes() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(output);
        writer.print("registry:\n");
        writer.print("  image: registry:2\n");
        writer.print("  ports:\n");
        writer.print("    - 127.0.0.1:5000:5000\n");
        writer.print("  environment:\n");
        writer.print("    REGISTRY_STORAGE_FILESYSTEM_ROOTDIRECTORY: /" + this.registryDataDirName + "\n");
        writer.print("    REGISTRY_HTTP_TLS_CERTIFICATE: " + this.containerCertPath + "/" + this.localhostCrtFileName + "\n");
        writer.print("    REGISTRY_HTTP_TLS_KEY: " + this.containerCertPath + "/" + this.localhostKeyFileName + "\n");
        writer.print("    REGISTRY_AUTH_TOKEN_REALM: " + this.authServerUrl + "/realms/" + this.realmName + "/protocol/docker-v2/auth\n");
        writer.print("    REGISTRY_AUTH_TOKEN_SERVICE: " + this.serviceId + "\n");
        writer.print("    REGISTRY_AUTH_TOKEN_ISSUER: " + this.authServerUrl + "/realms/" + this.realmName + "\n");
        writer.print("    REGISTRY_AUTH_TOKEN_ROOTCERTBUNDLE: " + this.containerCertPath + "/" + this.authServerTrustChainFileName + "\n");
        writer.print("  volumes:\n");
        writer.print("    - ./" + this.registryDataDirName + ":/" + this.registryDataDirName + ":z\n");
        writer.print("    - ./" + this.localCertDirName + ":" + this.containerCertPath + ":z");
        writer.flush();
        writer.close();
        return output.toByteArray();
    }
}

