/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc.mappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.broker.oidc.mappers.AbstractClaimMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;

public class UsernameTemplateMapper
extends AbstractClaimMapper {
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"keycloak-oidc", "oidc", "bitbucket", "facebook", "github", "gitlab", "google", "instagram", "linkedin", "microsoft", "openshift-v3", "openshift-v4", "paypal", "stackoverflow", "twitter"};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    private static final Set<IdentityProviderSyncMode> IDENTITY_PROVIDER_SYNC_MODES = new HashSet<IdentityProviderSyncMode>(Arrays.asList(IdentityProviderSyncMode.values()));
    public static final String TEMPLATE = "template";
    public static final String PROVIDER_ID = "oidc-username-idp-mapper";
    static Pattern substitution;

    public boolean supportsSyncMode(IdentityProviderSyncMode syncMode) {
        return IDENTITY_PROVIDER_SYNC_MODES.contains(syncMode);
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Preprocessor";
    }

    public String getDisplayType() {
        return "Username Template Importer";
    }

    public void updateBrokeredUserLegacy(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        if (!realm.isRegistrationEmailAsUsername()) {
            user.setUsername(context.getModelUsername());
        }
    }

    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        this.setUserNameFromTemplate(mapperModel, context);
    }

    private void setUserNameFromTemplate(IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String template = (String)mapperModel.getConfig().get(TEMPLATE);
        Matcher m = substitution.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String variable = m.group(1);
            if (variable.equals("ALIAS")) {
                m.appendReplacement(sb, context.getIdpConfig().getAlias());
                continue;
            }
            if (variable.equals("UUID")) {
                m.appendReplacement(sb, KeycloakModelUtils.generateId());
                continue;
            }
            if (variable.startsWith("CLAIM.")) {
                String name = variable.substring("CLAIM.".length());
                Object value = AbstractClaimMapper.getClaimValue(context, name);
                if (value == null) {
                    value = "";
                }
                m.appendReplacement(sb, value.toString());
                continue;
            }
            m.appendReplacement(sb, m.group(1));
        }
        m.appendTail(sb);
        String username = sb.toString();
        context.setModelUsername(username);
    }

    public String getHelpText() {
        return "Format the username to import.";
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(TEMPLATE);
        property.setLabel("Template");
        property.setHelpText("Template to use to format the username to import.  Substitutions are enclosed in ${}.  For example: '${ALIAS}.${CLAIM.sub}'.  ALIAS is the provider alias.  CLAIM.<NAME> references an ID or Access token claim.");
        property.setType("String");
        property.setDefaultValue((Object)"${ALIAS}.${CLAIM.preferred_username}");
        configProperties.add(property);
        substitution = Pattern.compile("\\$\\{([^}]+)\\}");
    }
}

