/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.forms;

import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.Config;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.resources.AttributeFormDataProcessor;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.profile.DefaultUserProfileContext;
import org.keycloak.userprofile.profile.representations.AttributeUserProfile;
import org.keycloak.userprofile.utils.UserUpdateHelper;
import org.keycloak.userprofile.validation.UserProfileValidationResult;

public class RegistrationUserCreation
implements FormAction,
FormActionFactory {
    public static final String PROVIDER_ID = "registration-user-creation";
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};

    public String getHelpText() {
        return "This action must always be first! Validates the username of the user in validation phase.  In success phase, this will create the user in the database.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public void validate(ValidationContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        context.getEvent().detail("register_method", "form");
        AttributeUserProfile newProfile = AttributeFormDataProcessor.toUserProfile((MultivaluedMap<String, String>)context.getHttpRequest().getDecodedFormParameters());
        String email = newProfile.getAttributes().getFirstAttribute("email");
        String username = newProfile.getAttributes().getFirstAttribute("username");
        context.getEvent().detail("email", email);
        context.getEvent().detail("username", username);
        UserProfileProvider profileProvider = (UserProfileProvider)context.getSession().getProvider(UserProfileProvider.class, "legacy-user-profile");
        context.getEvent().detail("register_method", "form");
        UserProfileValidationResult result = profileProvider.validate((UserProfileContext)DefaultUserProfileContext.forRegistrationUserCreation(), (UserProfile)newProfile);
        List<FormMessage> errors = Validation.getFormErrorsFromValidation(result);
        if (context.getRealm().isRegistrationEmailAsUsername()) {
            context.getEvent().detail("username", email);
        }
        if (errors.size() > 0) {
            if (result.hasFailureOfErrorType(new String[]{"emailExistsMessage"})) {
                context.error("email_in_use");
                formData.remove((Object)"email");
            } else if (result.hasFailureOfErrorType(new String[]{"missingEmailMessage", "missingUsernameMessage", "invalidEmailMessage"})) {
                if (result.hasFailureOfErrorType(new String[]{"invalidEmailMessage"})) {
                    formData.remove((Object)"email");
                }
                context.error("invalid_registration");
            } else if (result.hasFailureOfErrorType(new String[]{"usernameExistsMessage"})) {
                context.error("username_in_use");
                formData.remove((Object)"username");
            }
            context.validationError(formData, errors);
            return;
        }
        context.success();
    }

    public void buildPage(FormContext context, LoginFormsProvider form) {
    }

    public void success(FormContext context) {
        AttributeUserProfile updatedProfile = AttributeFormDataProcessor.toUserProfile((MultivaluedMap<String, String>)context.getHttpRequest().getDecodedFormParameters());
        String email = updatedProfile.getAttributes().getFirstAttribute("email");
        String username = updatedProfile.getAttributes().getFirstAttribute("username");
        if (context.getRealm().isRegistrationEmailAsUsername()) {
            username = email;
        }
        context.getEvent().detail("username", username).detail("register_method", "form").detail("email", email);
        UserModel user = context.getSession().users().addUser(context.getRealm(), username);
        user.setEnabled(true);
        UserUpdateHelper.updateRegistrationUserCreation(context.getRealm(), user, updatedProfile);
        context.getAuthenticationSession().setClientNote("login_hint", username);
        context.setUser(user);
        context.getEvent().user(user);
        context.getEvent().success();
        context.newEvent().event(EventType.LOGIN);
        context.getEvent().client(context.getAuthenticationSession().getClient().getClientId()).detail("redirect_uri", context.getAuthenticationSession().getRedirectUri()).detail("auth_method", context.getAuthenticationSession().getProtocol());
        String authType = context.getAuthenticationSession().getAuthNote("auth_type");
        if (authType != null) {
            context.getEvent().detail("auth_type", authType);
        }
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public void close() {
    }

    public String getDisplayType() {
        return "Registration User Creation";
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public FormAction create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

