/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc;

import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.RealmModel;

public class OAuth2IdentityProviderConfig
extends IdentityProviderModel {
    public OAuth2IdentityProviderConfig(IdentityProviderModel model) {
        super(model);
    }

    public OAuth2IdentityProviderConfig() {
    }

    public String getAuthorizationUrl() {
        return (String)this.getConfig().get("authorizationUrl");
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.getConfig().put("authorizationUrl", authorizationUrl);
    }

    public String getTokenUrl() {
        return (String)this.getConfig().get("tokenUrl");
    }

    public void setTokenUrl(String tokenUrl) {
        this.getConfig().put("tokenUrl", tokenUrl);
    }

    public String getUserInfoUrl() {
        return (String)this.getConfig().get("userInfoUrl");
    }

    public void setUserInfoUrl(String userInfoUrl) {
        this.getConfig().put("userInfoUrl", userInfoUrl);
    }

    public String getClientId() {
        return (String)this.getConfig().get("clientId");
    }

    public void setClientId(String clientId) {
        this.getConfig().put("clientId", clientId);
    }

    public String getClientAuthMethod() {
        return this.getConfig().getOrDefault("clientAuthMethod", "client_secret_post");
    }

    public void setClientAuthMethod(String clientAuth) {
        this.getConfig().put("clientAuthMethod", clientAuth);
    }

    public String getClientSecret() {
        return (String)this.getConfig().get("clientSecret");
    }

    public void setClientSecret(String clientSecret) {
        this.getConfig().put("clientSecret", clientSecret);
    }

    public String getDefaultScope() {
        return (String)this.getConfig().get("defaultScope");
    }

    public void setDefaultScope(String defaultScope) {
        this.getConfig().put("defaultScope", defaultScope);
    }

    public boolean isJWTAuthentication() {
        return this.getClientAuthMethod().equals("client_secret_jwt") || this.getClientAuthMethod().equals("private_key_jwt");
    }

    public boolean isBasicAuthentication() {
        return this.getClientAuthMethod().equals("client_secret_basic");
    }

    public boolean isUiLocales() {
        return Boolean.valueOf((String)this.getConfig().get("uiLocales"));
    }

    public void setUiLocales(boolean uiLocales) {
        this.getConfig().put("uiLocales", String.valueOf(uiLocales));
    }

    public String getPrompt() {
        return (String)this.getConfig().get("prompt");
    }

    public String getForwardParameters() {
        return (String)this.getConfig().get("forwardParameters");
    }

    public void setForwardParameters(String forwardParameters) {
        this.getConfig().put("forwardParameters", forwardParameters);
    }

    public void validate(RealmModel realm) {
        SslRequired sslRequired = realm.getSslRequired();
        UriUtils.checkUrl((SslRequired)sslRequired, (String)this.getAuthorizationUrl(), (String)"authorization_url");
        UriUtils.checkUrl((SslRequired)sslRequired, (String)this.getTokenUrl(), (String)"token_url");
        UriUtils.checkUrl((SslRequired)sslRequired, (String)this.getUserInfoUrl(), (String)"userinfo_url");
    }
}

