/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyLogger;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.ClientUpdateContext;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;

public class ClientUpdateContextCondition
implements ClientPolicyConditionProvider {
    private static final Logger logger = Logger.getLogger(ClientUpdateContextCondition.class);
    private final KeycloakSession session;
    private final ComponentModel componentModel;

    public ClientUpdateContextCondition(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: 
            case UPDATE: {
                if (this.isAuthMethodMatched((ClientUpdateContext)context)) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private boolean isAuthMethodMatched(String authMethod) {
        boolean isMatched;
        if (authMethod == null) {
            return false;
        }
        List expectedAuthMethods = (List)this.componentModel.getConfig().get((Object)"update-client-source");
        if (expectedAuthMethods == null) {
            expectedAuthMethods = Collections.emptyList();
        }
        if (logger.isTraceEnabled()) {
            ClientPolicyLogger.log(logger, "auth method = " + authMethod);
            expectedAuthMethods.stream().forEach(i -> ClientPolicyLogger.log(logger, "auth method expected = " + i));
        }
        if (isMatched = expectedAuthMethods.stream().anyMatch(i -> i.equals(authMethod))) {
            ClientPolicyLogger.log(logger, "auth method matched.");
        } else {
            ClientPolicyLogger.log(logger, "auth method unmatched.");
        }
        return isMatched;
    }

    private boolean isAuthMethodMatched(ClientUpdateContext context) {
        String authMethod = null;
        if (context.getToken() == null) {
            authMethod = "ByAnonymous";
        } else if (this.isInitialAccessToken(context.getToken())) {
            authMethod = "ByInitialAccessToken";
        } else if (this.isRegistrationAccessToken(context.getToken())) {
            authMethod = "ByRegistrationAccessToken";
        } else if (this.isBearerToken(context.getToken())) {
            authMethod = context.getAuthenticatedUser() != null || context.getAuthenticatedClient() != null ? "ByAuthenticatedUser" : "ByAnonymous";
        }
        return this.isAuthMethodMatched(authMethod);
    }

    private boolean isInitialAccessToken(JsonWebToken jwt) {
        return jwt != null && "InitialAccessToken".equals(jwt.getType());
    }

    private boolean isRegistrationAccessToken(JsonWebToken jwt) {
        return jwt != null && "RegistrationAccessToken".equals(jwt.getType());
    }

    private boolean isBearerToken(JsonWebToken jwt) {
        return jwt != null && "Bearer".equals(jwt.getType());
    }

    public String getName() {
        return this.componentModel.getName();
    }

    public String getProviderId() {
        return this.componentModel.getProviderId();
    }
}

