/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.Arrays;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.clientpolicy.AdminClientRegisterContext;
import org.keycloak.services.clientpolicy.AdminClientUpdateContext;
import org.keycloak.services.clientpolicy.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyLogger;
import org.keycloak.services.clientpolicy.ClientUpdateContext;
import org.keycloak.services.clientpolicy.DynamicClientRegisterContext;
import org.keycloak.services.clientpolicy.DynamicClientUpdateContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureRedirectUriEnforceExecutor
implements ClientPolicyExecutorProvider {
    private static final Logger logger = Logger.getLogger(SecureRedirectUriEnforceExecutor.class);
    private final KeycloakSession session;
    private final ComponentModel componentModel;

    public SecureRedirectUriEnforceExecutor(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    public String getName() {
        return this.componentModel.getName();
    }

    public String getProviderId() {
        return this.componentModel.getProviderId();
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: {
                if (!(context instanceof AdminClientRegisterContext) && !(context instanceof DynamicClientRegisterContext)) {
                    throw new ClientPolicyException("invalid_request", "not allowed input format.");
                }
                this.confirmSecureRedirectUris(((ClientUpdateContext)context).getProposedClientRepresentation().getRedirectUris());
                return;
            }
            case UPDATE: {
                if (!(context instanceof AdminClientUpdateContext) && !(context instanceof DynamicClientUpdateContext)) {
                    throw new ClientPolicyException("invalid_request", "not allowed input format.");
                }
                this.confirmSecureRedirectUris(((ClientUpdateContext)context).getProposedClientRepresentation().getRedirectUris());
                return;
            }
            case AUTHORIZATION_REQUEST: {
                this.confirmSecureRedirectUris(Arrays.asList(((AuthorizationRequestContext)context).getRedirectUri()));
                return;
            }
        }
    }

    private void confirmSecureRedirectUris(List<String> redirectUris) throws ClientPolicyException {
        if (redirectUris == null || redirectUris.isEmpty()) {
            throw new ClientPolicyException("invalid_client_metadata", "Invalid client metadata: redirect_uris");
        }
        for (String redirectUri : redirectUris) {
            ClientPolicyLogger.log(logger, "Redirect URI = " + redirectUri);
            if (!redirectUri.startsWith("http://") && !redirectUri.contains("*")) continue;
            throw new ClientPolicyException("invalid_client_metadata", "Invalid client metadata: redirect_uris");
        }
    }
}

