/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.endpoints.request.AuthzEndpointRequestParser;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyLogger;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureRequestObjectExecutor
implements ClientPolicyExecutorProvider {
    private static final Logger logger = Logger.getLogger(SecureRequestObjectExecutor.class);
    private final KeycloakSession session;
    private final ComponentModel componentModel;
    public static final String INVALID_REQUEST_OBJECT = "invalid_request_object";

    public SecureRequestObjectExecutor(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: {
                AuthorizationRequestContext authorizationRequestContext = (AuthorizationRequestContext)context;
                this.executeOnAuthorizationRequest(authorizationRequestContext.getparsedResponseType(), authorizationRequestContext.getAuthorizationEndpointRequest(), authorizationRequestContext.getRedirectUri(), authorizationRequestContext.getRequestParameters());
                break;
            }
            default: {
                return;
            }
        }
    }

    private void executeOnAuthorizationRequest(OIDCResponseType parsedResponseType, AuthorizationEndpointRequest request, String redirectUri, MultivaluedMap<String, String> params) throws ClientPolicyException {
        ClientPolicyLogger.log(logger, "Authz Endpoint - authz request");
        if (params == null) {
            ClientPolicyLogger.log(logger, "request parameter not exist.");
            throw new ClientPolicyException("invalid_request", "Missing parameters");
        }
        String requestParam = (String)params.getFirst((Object)"request");
        String requestUriParam = (String)params.getFirst((Object)"request_uri");
        if (requestParam == null && requestUriParam == null) {
            ClientPolicyLogger.log(logger, "request object not exist.");
            throw new ClientPolicyException("invalid_request", "Invalid parameter");
        }
        JsonNode requestObject = (JsonNode)this.session.getAttribute("ParsedRequestObject");
        if (requestObject == null || requestObject.isEmpty()) {
            ClientPolicyLogger.log(logger, "request object not exist.");
            throw new ClientPolicyException("invalid_request", "Invalid parameter");
        }
        if (params.getFirst((Object)"scope") == null || requestObject.get("scope") == null) {
            ClientPolicyLogger.log(logger, "scope does not exists.");
            throw new ClientPolicyException("invalid_request", "Missing parameter : scope");
        }
        if (requestObject.get("exp") == null) {
            ClientPolicyLogger.log(logger, "exp claim not incuded.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Missing parameter : exp");
        }
        long exp = requestObject.get("exp").asLong();
        if ((long)Time.currentTime() > exp) {
            ClientPolicyLogger.log(logger, "request object expired.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Request Expired");
        }
        ArrayList<String> aud = new ArrayList<String>();
        JsonNode audience = requestObject.get("aud");
        if (audience == null) {
            ClientPolicyLogger.log(logger, "aud claim not incuded.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Missing parameter : aud");
        }
        if (audience.isArray()) {
            for (JsonNode node : audience) {
                aud.add(node.asText());
            }
        } else {
            aud.add(audience.asText());
        }
        if (aud.isEmpty()) {
            ClientPolicyLogger.log(logger, "aud claim not incuded.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Missing parameter : aud");
        }
        String iss = Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.session.getContext().getRealm().getName());
        if (!aud.contains(iss)) {
            ClientPolicyLogger.log(logger, "aud not points to the intended realm.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Invalid parameter : aud");
        }
        if (AuthzEndpointRequestParser.KNOWN_REQ_PARAMS.stream().filter(s -> params.containsKey(s)).anyMatch(s -> !this.isSameParameterIncluded((String)s, (String)params.getFirst(s), requestObject))) {
            ClientPolicyLogger.log(logger, "not all parameters in query string are included in the request object, and have the same values.");
            throw new ClientPolicyException("invalid_request", "Invalid parameter");
        }
        ClientPolicyLogger.log(logger, "Passed.");
    }

    private boolean isSameParameterIncluded(String param, String value, JsonNode requestObject) {
        if (param.equals("request") || param.equals("request_uri")) {
            return true;
        }
        if (requestObject.hasNonNull(param)) {
            return requestObject.get(param).asText().equals(value);
        }
        return false;
    }

    public String getName() {
        return this.componentModel.getName();
    }

    public String getProviderId() {
        return this.componentModel.getProviderId();
    }
}

