/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.validation.StaticValidators;
import org.keycloak.userprofile.validation.UserProfileValidationResult;
import org.keycloak.userprofile.validation.ValidationChainBuilder;

public class LegacyUserProfileProvider
implements UserProfileProvider {
    private static final Logger logger = Logger.getLogger(LegacyUserProfileProvider.class);
    private KeycloakSession session;

    public LegacyUserProfileProvider(KeycloakSession session) {
        this.session = session;
    }

    public void close() {
    }

    public UserProfileValidationResult validate(UserProfileContext updateContext, UserProfile updatedProfile) {
        RealmModel realm = this.session.getContext().getRealm();
        ValidationChainBuilder builder = ValidationChainBuilder.builder();
        switch (updateContext.getUpdateEvent()) {
            case UserResource: {
                break;
            }
            case IdpReview: {
                this.addBasicValidators(builder, !realm.isRegistrationEmailAsUsername());
                break;
            }
            case Account: 
            case RegistrationProfile: 
            case UpdateProfile: {
                this.addBasicValidators(builder, !realm.isRegistrationEmailAsUsername() && realm.isEditUsernameAllowed());
                this.addSessionValidators(builder);
                break;
            }
            case RegistrationUserCreation: {
                this.addUserCreationValidators(builder);
            }
        }
        return new UserProfileValidationResult(builder.build().validate(updateContext, updatedProfile));
    }

    private void addUserCreationValidators(ValidationChainBuilder builder) {
        RealmModel realm = this.session.getContext().getRealm();
        if (realm.isRegistrationEmailAsUsername()) {
            builder.addAttributeValidator().forAttribute("email").addValidationFunction("invalidEmailMessage", StaticValidators.isEmailValid()).addValidationFunction("missingEmailMessage", StaticValidators.isBlank()).addValidationFunction("emailExistsMessage", StaticValidators.doesEmailExist(this.session)).build().build();
        } else {
            builder.addAttributeValidator().forAttribute("username").addValidationFunction("missingUsernameMessage", StaticValidators.isBlank()).addValidationFunction("usernameExistsMessage", (value, o) -> this.session.users().getUserByUsername(value, realm) == null).build();
        }
    }

    private void addBasicValidators(ValidationChainBuilder builder, boolean userNameExistsCondition) {
        builder.addAttributeValidator().forAttribute("username").addValidationFunction("missingUsernameMessage", StaticValidators.checkUsernameExists(userNameExistsCondition)).build().addAttributeValidator().forAttribute("firstName").addValidationFunction("missingFirstNameMessage", StaticValidators.isBlank()).build().addAttributeValidator().forAttribute("lastName").addValidationFunction("missingLastNameMessage", StaticValidators.isBlank()).build().addAttributeValidator().forAttribute("email").addValidationFunction("missingEmailMessage", StaticValidators.isBlank()).addValidationFunction("invalidEmailMessage", StaticValidators.isEmailValid()).build();
    }

    private void addSessionValidators(ValidationChainBuilder builder) {
        RealmModel realm = this.session.getContext().getRealm();
        builder.addAttributeValidator().forAttribute("username").addValidationFunction("usernameExistsMessage", StaticValidators.userNameExists(this.session)).addValidationFunction("readOnlyUsernameMessage", StaticValidators.isUserMutable(realm)).build().addAttributeValidator().forAttribute("email").addValidationFunction("emailExistsMessage", StaticValidators.isEmailDuplicated(this.session)).addValidationFunction("usernameExistsMessage", StaticValidators.doesEmailExistAsUsername(this.session)).build().build();
    }
}

