/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account.resources;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.resources.account.resources.AbstractResourceService;

public class ResourceService
extends AbstractResourceService {
    private final Resource resource;
    private final ResourceServer resourceServer;

    ResourceService(Resource resource, KeycloakSession session, UserModel user, Auth auth, HttpRequest request) {
        super(session, user, auth, request);
        this.resource = resource;
        this.resourceServer = this.provider.getStoreFactory().getResourceServerStore().findById(resource.getResourceServer());
    }

    @GET
    @Produces(value={"application/json"})
    public AbstractResourceService.Resource getResource() {
        return new AbstractResourceService.Resource(this.resource, this.provider);
    }

    @GET
    @Path(value="permissions")
    @Produces(value={"application/json"})
    public Collection<AbstractResourceService.Permission> toPermissions() {
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("owner", this.user.getId());
        filters.put("granted", Boolean.TRUE.toString());
        filters.put("resource.id", this.resource.getId());
        Collection<AbstractResourceService.ResourcePermission> resources = this.toPermissions(this.ticketStore.find(filters, null, -1, -1));
        Collection<Object> permissions = Collections.EMPTY_LIST;
        if (!resources.isEmpty()) {
            permissions = resources.iterator().next().getPermissions();
        }
        return permissions;
    }

    @GET
    @Path(value="user")
    @Produces(value={"application/json"})
    public Response user(@QueryParam(value="value") String value) {
        try {
            UserModel user = this.getUser(value);
            return Response.ok((Object)ModelToRepresentation.toRepresentation((KeycloakSession)this.provider.getKeycloakSession(), (RealmModel)this.provider.getRealm(), (UserModel)user)).build();
        }
        catch (NotFoundException e) {
            return Response.noContent().build();
        }
    }

    @PUT
    @Path(value="permissions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response revoke(List<AbstractResourceService.Permission> permissions) {
        this.auth.require("manage-account");
        if (permissions == null || permissions.isEmpty()) {
            throw new BadRequestException("invalid_permissions");
        }
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("resource.id", this.resource.getId());
        for (AbstractResourceService.Permission permission : permissions) {
            UserModel user = this.getUser(permission.getUsername());
            filters.put("requester", user.getId());
            List tickets = this.ticketStore.find(filters, this.resource.getResourceServer(), -1, -1);
            if (tickets.isEmpty()) {
                for (String scope : permission.getScopes()) {
                    this.grantPermission(user, scope);
                }
                continue;
            }
            Iterator<String> scopesIterator = permission.getScopes().iterator();
            while (scopesIterator.hasNext()) {
                String scope;
                scope = this.getScope(scopesIterator.next(), this.resourceServer);
                Iterator ticketIterator = tickets.iterator();
                while (ticketIterator.hasNext()) {
                    PermissionTicket ticket = (PermissionTicket)ticketIterator.next();
                    if (!scope.getId().equals(ticket.getScope().getId())) continue;
                    if (!ticket.isGranted()) {
                        ticket.setGrantedTimestamp(Long.valueOf(System.currentTimeMillis()));
                    }
                    ticketIterator.remove();
                    scopesIterator.remove();
                }
            }
            for (String scope : permission.getScopes()) {
                this.grantPermission(user, scope);
            }
            for (PermissionTicket ticket : tickets) {
                this.ticketStore.delete(ticket.getId());
            }
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="permissions/requests")
    @Produces(value={"application/json"})
    public Collection<AbstractResourceService.Permission> getPermissionRequests() {
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("owner", this.user.getId());
        filters.put("granted", Boolean.FALSE.toString());
        filters.put("resource.id", this.resource.getId());
        HashMap<String, AbstractResourceService.Permission> requests = new HashMap<String, AbstractResourceService.Permission>();
        for (PermissionTicket ticket : this.ticketStore.find(filters, null, -1, -1)) {
            requests.computeIfAbsent(ticket.getRequester(), requester -> new AbstractResourceService.Permission(ticket, this.provider)).addScope(ticket.getScope().getName());
        }
        return requests.values();
    }

    private void grantPermission(UserModel user, String scopeId) {
        Scope scope = this.getScope(scopeId, this.resourceServer);
        PermissionTicket ticket = this.ticketStore.create(this.resource.getId(), scope.getId(), user.getId(), this.resourceServer);
        ticket.setGrantedTimestamp(Long.valueOf(Calendar.getInstance().getTimeInMillis()));
    }

    private Scope getScope(String scopeId, ResourceServer resourceServer) {
        Scope scope = this.scopeStore.findByName(scopeId, resourceServer.getId());
        if (scope == null) {
            scope = this.scopeStore.findById(scopeId, resourceServer.getId());
        }
        return scope;
    }

    private UserModel getUser(String requester) {
        UserProvider users = this.provider.getKeycloakSession().users();
        UserModel user = users.getUserByUsername(requester, this.provider.getRealm());
        if (user == null) {
            user = users.getUserByEmail(requester, this.provider.getRealm());
        }
        if (user == null) {
            throw new NotFoundException(requester);
        }
        return user;
    }

    private Collection<AbstractResourceService.ResourcePermission> toPermissions(List<PermissionTicket> tickets) {
        HashMap<String, AbstractResourceService.ResourcePermission> permissions = new HashMap<String, AbstractResourceService.ResourcePermission>();
        for (PermissionTicket ticket : tickets) {
            AbstractResourceService.ResourcePermission resource = permissions.computeIfAbsent(ticket.getResource().getId(), s -> new AbstractResourceService.ResourcePermission(ticket, this.provider));
            AbstractResourceService.Permission user = resource.getPermission(ticket.getRequester());
            if (user == null) {
                user = new AbstractResourceService.Permission(ticket.getRequester(), this.provider);
                resource.addPermission(ticket.getRequester(), user);
            }
            user.addScope(ticket.getScope().getName());
        }
        return permissions.values();
    }
}

