/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.docker;

import javax.ws.rs.GET;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.AuthorizationEndpointBase;
import org.keycloak.protocol.docker.DockerAuthV2Protocol;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequestParserProcessor;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.utils.ProfileHelper;

public class DockerEndpoint
extends AuthorizationEndpointBase {
    protected static final Logger logger = Logger.getLogger(DockerEndpoint.class);
    private final EventType login;
    private String account;
    private String service;
    private String scope;
    private ClientModel client;
    private AuthenticationSessionModel authenticationSession;

    public DockerEndpoint(RealmModel realm, EventBuilder event, EventType login) {
        super(realm, event);
        this.login = login;
    }

    @GET
    public Response build() {
        ProfileHelper.requireFeature(Profile.Feature.DOCKER);
        MultivaluedMap params = this.session.getContext().getUri().getQueryParameters();
        this.account = (String)params.getFirst((Object)"account");
        if (this.account == null) {
            logger.debug((Object)"Account parameter not provided by docker auth.  This is techincally required, but not actually used since username is provided by Basic auth header.");
        }
        this.service = (String)params.getFirst((Object)"service");
        if (this.service == null) {
            throw new ErrorResponseException("invalid_request", "service parameter must be provided", Response.Status.BAD_REQUEST);
        }
        this.client = this.realm.getClientByClientId(this.service);
        if (this.client == null) {
            logger.errorv("Failed to lookup client given by service={0} parameter for realm: {1}.", (Object)this.service, (Object)this.realm.getName());
            throw new ErrorResponseException("invalid_client", "Client specified by 'service' parameter does not exist", Response.Status.BAD_REQUEST);
        }
        this.scope = (String)params.getFirst((Object)"scope");
        this.checkSsl();
        this.checkRealm();
        AuthorizationEndpointRequest authRequest = AuthorizationEndpointRequestParserProcessor.parseRequest(this.event, this.session, this.client, (MultivaluedMap<String, String>)params);
        this.authenticationSession = this.createAuthenticationSession(this.client, authRequest.getState());
        this.updateAuthenticationSession();
        CacheControlUtil.noBackButtonCacheControlHeader();
        return this.handleBrowserAuthenticationRequest(this.authenticationSession, new DockerAuthV2Protocol(this.session, this.realm, (UriInfo)this.session.getContext().getUri(), this.headers, this.event.event(this.login)), false, false);
    }

    private void updateAuthenticationSession() {
        this.authenticationSession.setProtocol("docker-v2");
        this.authenticationSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        this.authenticationSession.setClientNote("USER_SESSION_PERSISTENT_STATE", UserSessionModel.SessionPersistenceState.TRANSIENT.toString());
        this.authenticationSession.setClientNote("account", this.account);
        this.authenticationSession.setClientNote("service", this.service);
        this.authenticationSession.setClientNote("scope", this.scope);
        this.authenticationSession.setClientNote("docker.iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
    }

    @Override
    protected AuthenticationFlowModel getAuthenticationFlow(AuthenticationSessionModel authSession) {
        return this.realm.getDockerAuthenticationFlow();
    }
}

