/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.executors.ExecutorsProvider;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;

public class ServicesUtils {
    private static final Logger logger = Logger.getLogger(ServicesUtils.class);

    public static <T, R> Function<? super T, ? extends Stream<? extends R>> timeBound(KeycloakSession session, long timeout, Function<T, ? extends Stream<R>> func) {
        ExecutorService executor = ((ExecutorsProvider)session.getProvider(ExecutorsProvider.class)).getExecutor("storage-provider-threads");
        return p -> {
            Future<?> timeCheckingThread = executor.submit(ServicesUtils.timeWarningRunnable(timeout, Thread.currentThread()));
            try {
                Stream stream = (Stream)func.apply(p);
                return stream;
            }
            finally {
                timeCheckingThread.cancel(true);
                if (Thread.interrupted()) {
                    logger.warnf("Execution with object [%s] exceeded specified time limit %d. %s", p, (Object)timeout, StackUtil.getShortStackTrace());
                }
            }
        };
    }

    public static <T, R> Function<? super T, R> timeBoundOne(KeycloakSession session, long timeout, Function<T, R> func) {
        ExecutorService executor = ((ExecutorsProvider)session.getProvider(ExecutorsProvider.class)).getExecutor("storage-provider-threads");
        return p -> {
            Future<?> warningThreadFuture = executor.submit(ServicesUtils.timeWarningRunnable(timeout, Thread.currentThread()));
            try {
                Object r = func.apply(p);
                return r;
            }
            finally {
                warningThreadFuture.cancel(true);
                if (Thread.interrupted()) {
                    logger.warnf("Execution with object [%s] exceeded specified time limit %d. %s", p, (Object)timeout, StackUtil.getShortStackTrace());
                }
            }
        };
    }

    public static <T> Consumer<? super T> consumeWithTimeBound(KeycloakSession session, long timeout, Consumer<T> func) {
        ExecutorService executor = ((ExecutorsProvider)session.getProvider(ExecutorsProvider.class)).getExecutor("storage-provider-threads");
        return p -> {
            Future<?> warningThreadFuture = executor.submit(ServicesUtils.timeWarningRunnable(timeout, Thread.currentThread()));
            try {
                func.accept(p);
            }
            finally {
                warningThreadFuture.cancel(true);
                if (Thread.interrupted()) {
                    logger.warnf("Execution with object [%s] exceeded specified time limit %d. %s", p, (Object)timeout, StackUtil.getShortStackTrace());
                }
            }
        };
    }

    private static Runnable timeWarningRunnable(final long timeout, final Thread mainThread) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException exception) {
                    return;
                }
                mainThread.interrupt();
            }
        };
    }

    public static GroupRepresentation groupToBriefRepresentation(GroupModel g) {
        return ModelToRepresentation.toRepresentation((GroupModel)g, (boolean)false);
    }
}

