/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.conditional;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowCallbackFactory;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticatorFactory;
import org.keycloak.authentication.authenticators.conditional.ConditionalLoaAuthenticator;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class ConditionalLoaAuthenticatorFactory
implements ConditionalAuthenticatorFactory,
AuthenticationFlowCallbackFactory {
    public static final String PROVIDER_ID = "conditional-level-of-authentication";
    private static final ConditionalLoaAuthenticator SINGLETON = new ConditionalLoaAuthenticator();
    private static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};
    private static final List<ProviderConfigProperty> CONFIG = ProviderConfigurationBuilder.create().property().name("loa-condition-level").label("loa-condition-level").helpText("loa-condition-level.tooltip").type("String").add().property().name("loa-store-in-user-session").label("loa-store-in-user-session").helpText("loa-store-in-user-session.tooltip").type("boolean").defaultValue((Object)"true").add().build();

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Condition - Level of Authentication";
    }

    public String getReferenceCategory() {
        return "condition";
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return "Flow is executed only if the configured LOA or a higher one has been requested but not yet satisfied. After the flow is successfully finished, the LOA in the session will be updated to value prescribed by this condition.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG;
    }

    @Override
    public ConditionalAuthenticator getSingleton() {
        return SINGLETON;
    }
}

