/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;

public class PairwiseSubMapperUtils {
    private static final Logger logger = Logger.getLogger(PairwiseSubMapperUtils.class);

    public static Set<String> resolveValidRedirectUris(String clientRootUrl, Collection<String> clientRedirectUris) {
        if (clientRedirectUris == null) {
            return Collections.emptySet();
        }
        HashSet<String> validRedirects = new HashSet<String>();
        for (String redirectUri : clientRedirectUris) {
            if (redirectUri.startsWith("/")) {
                redirectUri = PairwiseSubMapperUtils.relativeToAbsoluteURI(clientRootUrl, redirectUri);
                logger.debugv("replacing relative valid redirect with: {0}", (Object)redirectUri);
            }
            if (redirectUri == null) continue;
            validRedirects.add(redirectUri);
        }
        return validRedirects.stream().filter(r -> r != null && !r.trim().isEmpty()).collect(Collectors.toSet());
    }

    public static String resolveValidSectorIdentifier(String sectorIdentifierUri) {
        URI uri;
        try {
            uri = new URI(sectorIdentifierUri);
        }
        catch (URISyntaxException e) {
            logger.debug((Object)"Invalid sector identifier URI", (Throwable)e);
            return null;
        }
        if (uri.getScheme() == null) {
            logger.debugv("Invalid sector identifier URI: {0}", (Object)sectorIdentifierUri);
            return null;
        }
        if (uri.getHost() == null) {
            logger.debug((Object)"The sector identifier URI must specify a host");
            return null;
        }
        return uri.getHost();
    }

    public static String resolveValidSectorIdentifier(String clientRootUrl, Set<String> clientRedirectUris) {
        HashSet<String> hosts = new HashSet<String>();
        for (String redirectUri : PairwiseSubMapperUtils.resolveValidRedirectUris(clientRootUrl, clientRedirectUris)) {
            try {
                URI uri = new URI(redirectUri);
                hosts.add(uri.getHost());
            }
            catch (URISyntaxException e) {
                logger.debugv("client redirect uris contained an invalid uri: {0}", (Object)redirectUri);
            }
        }
        if (hosts.isEmpty()) {
            logger.debug((Object)"could not infer any valid sector_identifiers from client redirect uris");
            return null;
        }
        if (hosts.size() > 1) {
            logger.debug((Object)"the client redirect uris contained multiple hosts");
            return null;
        }
        return (String)hosts.iterator().next();
    }

    public static boolean matchesRedirects(String clientRootUrl, Set<String> clientRedirectUris, Set<String> sectorRedirects) {
        Set<String> validRedirects = PairwiseSubMapperUtils.resolveValidRedirectUris(clientRootUrl, clientRedirectUris);
        for (String redirect : validRedirects) {
            if (PairwiseSubMapperUtils.matchesRedirect(sectorRedirects, redirect)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesRedirect(Set<String> validRedirects, String redirect) {
        for (String validRedirect : validRedirects) {
            if (validRedirect.endsWith("*") && !validRedirect.contains("?")) {
                int length;
                String r = redirect.contains("?") ? redirect.substring(0, redirect.indexOf("?")) : redirect;
                if (r.startsWith(validRedirect = validRedirect.substring(0, length = validRedirect.length() - 1))) {
                    return true;
                }
                if (length - 1 > 0 && validRedirect.charAt(length - 1) == '/') {
                    --length;
                }
                if (!(validRedirect = validRedirect.substring(0, length)).equals(r)) continue;
                return true;
            }
            if (!validRedirect.equals(redirect)) continue;
            return true;
        }
        return false;
    }

    private static String relativeToAbsoluteURI(String rootUrl, String relative) {
        if (rootUrl == null || rootUrl.isEmpty()) {
            return null;
        }
        relative = rootUrl + relative;
        return relative;
    }

    public static List<ProtocolMapperRepresentation> getPairwiseSubMappers(ClientRepresentation client) {
        LinkedList<ProtocolMapperRepresentation> pairwiseMappers = new LinkedList<ProtocolMapperRepresentation>();
        List mappers = client.getProtocolMappers();
        if (mappers != null) {
            client.getProtocolMappers().stream().filter(mapping -> mapping.getProtocolMapper().endsWith("-pairwise-sub-mapper")).forEach(mapping -> pairwiseMappers.add((ProtocolMapperRepresentation)mapping));
        }
        return pairwiseMappers;
    }
}

