/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.info;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ServerInfoAwareProviderFactory;
import org.keycloak.provider.Spi;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.ProtocolMapperTypeRepresentation;
import org.keycloak.representations.info.ClientInstallationRepresentation;
import org.keycloak.representations.info.MemoryInfoRepresentation;
import org.keycloak.representations.info.ProviderRepresentation;
import org.keycloak.representations.info.ServerInfoRepresentation;
import org.keycloak.representations.info.SpiInfoRepresentation;
import org.keycloak.representations.info.SystemInfoRepresentation;
import org.keycloak.representations.info.ThemeInfoRepresentation;
import org.keycloak.theme.Theme;
import org.keycloak.theme.ThemeProvider;

public class ServerInfoAdminResource {
    private static final Map<String, List<String>> ENUMS = ServerInfoAdminResource.createEnumsMap(EventType.class, OperationType.class);
    @Context
    private KeycloakSession session;

    @GET
    public ServerInfoRepresentation getInfo() {
        ServerInfoRepresentation info = new ServerInfoRepresentation();
        info.setSystemInfo(SystemInfoRepresentation.create((long)this.session.getKeycloakSessionFactory().getServerStartupTimestamp()));
        info.setMemoryInfo(MemoryInfoRepresentation.create());
        this.setSocialProviders(info);
        this.setIdentityProviders(info);
        this.setThemes(info);
        this.setProviders(info);
        this.setProtocolMapperTypes(info);
        this.setBuiltinProtocolMappers(info);
        this.setClientInstallations(info);
        info.setEnums(ENUMS);
        return info;
    }

    private void setProviders(ServerInfoRepresentation info) {
        LinkedHashMap<String, SpiInfoRepresentation> spiReps = new LinkedHashMap<String, SpiInfoRepresentation>();
        LinkedList spis = new LinkedList(this.session.getKeycloakSessionFactory().getSpis());
        Collections.sort(spis, new Comparator<Spi>(){

            @Override
            public int compare(Spi s1, Spi s2) {
                return s1.getName().compareTo(s2.getName());
            }
        });
        for (Spi spi : spis) {
            SpiInfoRepresentation spiRep = new SpiInfoRepresentation();
            spiRep.setInternal(spi.isInternal());
            LinkedList providerIds = new LinkedList(this.session.listProviderIds(spi.getProviderClass()));
            Collections.sort(providerIds);
            HashMap<String, ProviderRepresentation> providers = new HashMap<String, ProviderRepresentation>();
            if (providerIds != null) {
                for (String name : providerIds) {
                    ProviderRepresentation provider = new ProviderRepresentation();
                    ProviderFactory pi = this.session.getKeycloakSessionFactory().getProviderFactory(spi.getProviderClass(), name);
                    if (ServerInfoAwareProviderFactory.class.isAssignableFrom(pi.getClass())) {
                        provider.setOperationalInfo(((ServerInfoAwareProviderFactory)pi).getOperationalInfo());
                    }
                    providers.put(name, provider);
                }
            }
            spiRep.setProviders(providers);
            spiReps.put(spi.getName(), spiRep);
        }
        info.setProviders(spiReps);
    }

    private void setThemes(ServerInfoRepresentation info) {
        ThemeProvider themeProvider = (ThemeProvider)this.session.getProvider(ThemeProvider.class, "extending");
        info.setThemes(new HashMap());
        for (Theme.Type type : Theme.Type.values()) {
            LinkedList themeNames = new LinkedList(themeProvider.nameSet(type));
            Collections.sort(themeNames);
            LinkedList<ThemeInfoRepresentation> themes = new LinkedList<ThemeInfoRepresentation>();
            info.getThemes().put(type.toString().toLowerCase(), themes);
            for (String name : themeNames) {
                try {
                    Theme theme = themeProvider.getTheme(name, type);
                    ThemeInfoRepresentation ti = new ThemeInfoRepresentation();
                    ti.setName(name);
                    String locales = theme.getProperties().getProperty("locales");
                    if (locales != null) {
                        ti.setLocales(locales.replaceAll(" ", "").split(","));
                    }
                    themes.add(ti);
                }
                catch (IOException e) {
                    throw new WebApplicationException("Failed to load themes", (Throwable)e);
                }
            }
        }
    }

    private void setSocialProviders(ServerInfoRepresentation info) {
        info.setSocialProviders(new LinkedList());
        List providerFactories = this.session.getKeycloakSessionFactory().getProviderFactories(SocialIdentityProvider.class);
        this.setIdentityProviders(providerFactories, info.getSocialProviders(), "Social");
    }

    private void setIdentityProviders(ServerInfoRepresentation info) {
        info.setIdentityProviders(new LinkedList());
        List providerFactories = this.session.getKeycloakSessionFactory().getProviderFactories(IdentityProvider.class);
        this.setIdentityProviders(providerFactories, info.getIdentityProviders(), "User-defined");
        providerFactories = this.session.getKeycloakSessionFactory().getProviderFactories(SocialIdentityProvider.class);
        this.setIdentityProviders(providerFactories, info.getIdentityProviders(), "Social");
    }

    public void setIdentityProviders(List<ProviderFactory> factories, List<Map<String, String>> providers, String groupName) {
        for (ProviderFactory providerFactory : factories) {
            IdentityProviderFactory factory = (IdentityProviderFactory)providerFactory;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("groupName", groupName);
            data.put("name", factory.getName());
            data.put("id", factory.getId());
            providers.add(data);
        }
    }

    private void setClientInstallations(ServerInfoRepresentation info) {
        info.setClientInstallations(new HashMap());
        for (ProviderFactory p : this.session.getKeycloakSessionFactory().getProviderFactories(ClientInstallationProvider.class)) {
            ClientInstallationProvider provider = (ClientInstallationProvider)p;
            LinkedList<ClientInstallationRepresentation> types = (LinkedList<ClientInstallationRepresentation>)info.getClientInstallations().get(provider.getProtocol());
            if (types == null) {
                types = new LinkedList<ClientInstallationRepresentation>();
                info.getClientInstallations().put(provider.getProtocol(), types);
            }
            ClientInstallationRepresentation rep = new ClientInstallationRepresentation();
            rep.setId(p.getId());
            rep.setHelpText(provider.getHelpText());
            rep.setDisplayType(provider.getDisplayType());
            rep.setProtocol(provider.getProtocol());
            rep.setDownloadOnly(provider.isDownloadOnly());
            rep.setFilename(provider.getFilename());
            rep.setMediaType(provider.getMediaType());
            types.add(rep);
        }
    }

    private void setProtocolMapperTypes(ServerInfoRepresentation info) {
        info.setProtocolMapperTypes(new HashMap());
        for (ProviderFactory p : this.session.getKeycloakSessionFactory().getProviderFactories(ProtocolMapper.class)) {
            ProtocolMapper mapper = (ProtocolMapper)p;
            LinkedList<ProtocolMapperTypeRepresentation> types = (LinkedList<ProtocolMapperTypeRepresentation>)info.getProtocolMapperTypes().get(mapper.getProtocol());
            if (types == null) {
                types = new LinkedList<ProtocolMapperTypeRepresentation>();
                info.getProtocolMapperTypes().put(mapper.getProtocol(), types);
            }
            ProtocolMapperTypeRepresentation rep = new ProtocolMapperTypeRepresentation();
            rep.setId(mapper.getId());
            rep.setName(mapper.getDisplayType());
            rep.setHelpText(mapper.getHelpText());
            rep.setCategory(mapper.getDisplayCategory());
            rep.setProperties(new LinkedList());
            List configProperties = mapper.getConfigProperties();
            for (ProviderConfigProperty prop : configProperties) {
                ConfigPropertyRepresentation propRep = new ConfigPropertyRepresentation();
                propRep.setName(prop.getName());
                propRep.setLabel(prop.getLabel());
                propRep.setType(prop.getType());
                propRep.setDefaultValue(prop.getDefaultValue());
                propRep.setHelpText(prop.getHelpText());
                rep.getProperties().add(propRep);
            }
            types.add(rep);
        }
    }

    private void setBuiltinProtocolMappers(ServerInfoRepresentation info) {
        info.setBuiltinProtocolMappers(new HashMap());
        for (ProviderFactory p : this.session.getKeycloakSessionFactory().getProviderFactories(LoginProtocol.class)) {
            LoginProtocolFactory factory = (LoginProtocolFactory)p;
            LinkedList<ProtocolMapperRepresentation> mappers = new LinkedList<ProtocolMapperRepresentation>();
            for (ProtocolMapperModel mapper : factory.getBuiltinMappers()) {
                mappers.add(ModelToRepresentation.toRepresentation((ProtocolMapperModel)mapper));
            }
            info.getBuiltinProtocolMappers().put(p.getId(), mappers);
        }
    }

    private static Map<String, List<String>> createEnumsMap(Class ... enums) {
        HashMap<String, List<String>> m = new HashMap<String, List<String>>();
        for (Class e : enums) {
            String n = e.getSimpleName();
            n = Character.toLowerCase(n.charAt(0)) + n.substring(1);
            LinkedList<String> l = new LinkedList<String>();
            for (Object c : e.getEnumConstants()) {
                l.add(c.toString());
            }
            Collections.sort(l);
            m.put(n, l);
        }
        return m;
    }
}

