/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys.loader;

import java.security.PublicKey;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.keys.PublicKeyStorageProvider;
import org.keycloak.keys.loader.ClientPublicKeyLoader;
import org.keycloak.keys.loader.OIDCIdentityProviderPublicKeyLoader;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class PublicKeyStorageManager {
    public static PublicKey getClientPublicKey(KeycloakSession session, ClientModel client, JWSInput input) {
        String kid = input.getHeader().getKeyId();
        PublicKeyStorageProvider keyStorage = (PublicKeyStorageProvider)session.getProvider(PublicKeyStorageProvider.class);
        String modelKey = PublicKeyStorageManager.getModelKey(client);
        ClientPublicKeyLoader loader = new ClientPublicKeyLoader(session, client);
        return keyStorage.getPublicKey(modelKey, kid, (PublicKeyLoader)loader);
    }

    private static String getModelKey(ClientModel client) {
        return client.getRealm().getId() + "::client::" + client.getId();
    }

    public static PublicKey getIdentityProviderPublicKey(KeycloakSession session, RealmModel realm, OIDCIdentityProviderConfig idpConfig, JWSInput input) {
        String kid = input.getHeader().getKeyId();
        PublicKeyStorageProvider keyStorage = (PublicKeyStorageProvider)session.getProvider(PublicKeyStorageProvider.class);
        String modelKey = PublicKeyStorageManager.getModelKey(realm, idpConfig);
        OIDCIdentityProviderPublicKeyLoader loader = new OIDCIdentityProviderPublicKeyLoader(session, idpConfig);
        return keyStorage.getPublicKey(modelKey, kid, (PublicKeyLoader)loader);
    }

    private static String getModelKey(RealmModel realm, OIDCIdentityProviderConfig idpConfig) {
        return realm.getId() + "::idp::" + idpConfig.getInternalId();
    }
}

