/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.List;
import java.util.concurrent.Callable;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ExecutionResult;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.ServicesLogger;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.user.ImportSynchronization;
import org.keycloak.storage.user.SynchronizationResult;
import org.keycloak.timer.TimerProvider;

public class UserStorageSyncManager {
    private static final String USER_STORAGE_TASK_KEY = "user-storage";
    private static final Logger logger = Logger.getLogger(UserStorageSyncManager.class);

    public void bootstrapPeriodic(final KeycloakSessionFactory sessionFactory, final TimerProvider timer) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                List realms = session.realms().getRealms();
                for (RealmModel realm : realms) {
                    List providers = realm.getUserStorageProviders();
                    for (UserStorageProviderModel provider : providers) {
                        UserStorageProviderFactory factory = (UserStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, provider.getProviderId());
                        if (!(factory instanceof ImportSynchronization) || !provider.isImportEnabled()) continue;
                        UserStorageSyncManager.this.refreshPeriodicSyncForProvider(sessionFactory, timer, provider, realm.getId());
                    }
                }
                ClusterProvider clusterProvider = (ClusterProvider)session.getProvider(ClusterProvider.class);
                clusterProvider.registerListener(UserStorageSyncManager.USER_STORAGE_TASK_KEY, (ClusterListener)new UserStorageClusterListener(sessionFactory));
            }
        });
    }

    public SynchronizationResult syncAllUsers(final KeycloakSessionFactory sessionFactory, final String realmId, final UserStorageProviderModel provider) {
        final UserStorageProviderFactory factory = (UserStorageProviderFactory)sessionFactory.getProviderFactory(UserStorageProvider.class, provider.getProviderId());
        if (!(factory instanceof ImportSynchronization) || !provider.isImportEnabled()) {
            return SynchronizationResult.ignored();
        }
        final Holder holder = new Holder();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                ClusterProvider clusterProvider = (ClusterProvider)session.getProvider(ClusterProvider.class);
                String taskKey = provider.getId() + "::sync";
                int timeout = Math.max(30, provider.getFullSyncPeriod());
                holder.result = clusterProvider.executeIfNotExecuted(taskKey, timeout, (Callable)new Callable<SynchronizationResult>(){

                    @Override
                    public SynchronizationResult call() throws Exception {
                        UserStorageSyncManager.this.updateLastSyncInterval(sessionFactory, provider, realmId);
                        return ((ImportSynchronization)factory).sync(sessionFactory, realmId, provider);
                    }
                });
            }
        });
        if (holder.result == null || !holder.result.isExecuted()) {
            logger.debugf("syncAllUsers for federation provider %s was ignored as it's already in progress", (Object)provider.getName());
            return SynchronizationResult.ignored();
        }
        return (SynchronizationResult)holder.result.getResult();
    }

    public SynchronizationResult syncChangedUsers(final KeycloakSessionFactory sessionFactory, final String realmId, final UserStorageProviderModel provider) {
        final UserStorageProviderFactory factory = (UserStorageProviderFactory)sessionFactory.getProviderFactory(UserStorageProvider.class, provider.getProviderId());
        if (!(factory instanceof ImportSynchronization) || !provider.isImportEnabled()) {
            return SynchronizationResult.ignored();
        }
        final Holder holder = new Holder();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                ClusterProvider clusterProvider = (ClusterProvider)session.getProvider(ClusterProvider.class);
                String taskKey = provider.getId() + "::sync";
                int timeout = Math.max(30, provider.getChangedSyncPeriod());
                holder.result = clusterProvider.executeIfNotExecuted(taskKey, timeout, (Callable)new Callable<SynchronizationResult>(){

                    @Override
                    public SynchronizationResult call() throws Exception {
                        int oldLastSync = provider.getLastSync();
                        UserStorageSyncManager.this.updateLastSyncInterval(sessionFactory, provider, realmId);
                        return ((ImportSynchronization)factory).syncSince(Time.toDate((int)oldLastSync), sessionFactory, realmId, provider);
                    }
                });
            }
        });
        if (holder.result == null || !holder.result.isExecuted()) {
            logger.debugf("syncChangedUsers for federation provider %s was ignored as it's already in progress", (Object)provider.getName());
            return SynchronizationResult.ignored();
        }
        return (SynchronizationResult)holder.result.getResult();
    }

    public void notifyToRefreshPeriodicSync(KeycloakSession session, RealmModel realm, UserStorageProviderModel provider, boolean removed) {
        UserStorageProviderFactory factory = (UserStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, provider.getProviderId());
        if (!(factory instanceof ImportSynchronization) || !provider.isImportEnabled()) {
            return;
        }
        UserStorageProviderClusterEvent event = UserStorageProviderClusterEvent.createEvent(removed, realm.getId(), provider);
        ((ClusterProvider)session.getProvider(ClusterProvider.class)).notify(USER_STORAGE_TASK_KEY, (ClusterEvent)event);
    }

    protected void refreshPeriodicSyncForProvider(final KeycloakSessionFactory sessionFactory, TimerProvider timer, final UserStorageProviderModel provider, final String realmId) {
        logger.debugf("Going to refresh periodic sync for provider '%s' . Full sync period: %d , changed users sync period: %d", (Object)provider.getName(), (Object)provider.getFullSyncPeriod(), (Object)provider.getChangedSyncPeriod());
        if (provider.getFullSyncPeriod() > 0) {
            timer.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean shouldPerformSync = UserStorageSyncManager.this.shouldPerformNewPeriodicSync(provider.getLastSync(), provider.getChangedSyncPeriod());
                        if (shouldPerformSync) {
                            UserStorageSyncManager.this.syncAllUsers(sessionFactory, realmId, provider);
                        } else {
                            logger.debugf("Ignored periodic full sync with storage provider %s due small time since last sync", (Object)provider.getName());
                        }
                    }
                    catch (Throwable t) {
                        ServicesLogger.LOGGER.errorDuringFullUserSync(t);
                    }
                }
            }, (long)(provider.getFullSyncPeriod() * 1000), provider.getId() + "-FULL");
        } else {
            timer.cancelTask(provider.getId() + "-FULL");
        }
        if (provider.getChangedSyncPeriod() > 0) {
            timer.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean shouldPerformSync = UserStorageSyncManager.this.shouldPerformNewPeriodicSync(provider.getLastSync(), provider.getChangedSyncPeriod());
                        if (shouldPerformSync) {
                            UserStorageSyncManager.this.syncChangedUsers(sessionFactory, realmId, provider);
                        } else {
                            logger.debugf("Ignored periodic changed-users sync with storage provider %s due small time since last sync", (Object)provider.getName());
                        }
                    }
                    catch (Throwable t) {
                        ServicesLogger.LOGGER.errorDuringChangedUserSync(t);
                    }
                }
            }, (long)(provider.getChangedSyncPeriod() * 1000), provider.getId() + "-CHANGED");
        } else {
            timer.cancelTask(provider.getId() + "-CHANGED");
        }
    }

    private boolean shouldPerformNewPeriodicSync(int lastSyncTime, int period) {
        if (lastSyncTime <= 0) {
            return true;
        }
        int currentTime = Time.currentTime();
        int timeSinceLastSync = currentTime - lastSyncTime;
        return timeSinceLastSync * 2 > period;
    }

    protected void removePeriodicSyncForProvider(TimerProvider timer, UserStorageProviderModel fedProvider) {
        logger.debugf("Removing periodic sync for provider %s", (Object)fedProvider.getName());
        timer.cancelTask(fedProvider.getId() + "-FULL");
        timer.cancelTask(fedProvider.getId() + "-CHANGED");
    }

    private void updateLastSyncInterval(KeycloakSessionFactory sessionFactory, final UserStorageProviderModel provider, final String realmId) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                RealmModel persistentRealm = session.realms().getRealm(realmId);
                List persistentFedProviders = persistentRealm.getUserStorageProviders();
                for (UserStorageProviderModel persistentFedProvider : persistentFedProviders) {
                    if (!provider.getId().equals(persistentFedProvider.getId())) continue;
                    int lastSync = Time.currentTime();
                    persistentFedProvider.setLastSync(lastSync);
                    persistentRealm.updateComponent((ComponentModel)persistentFedProvider);
                    provider.setLastSync(lastSync);
                }
            }
        });
    }

    public static class UserStorageProviderClusterEvent
    implements ClusterEvent {
        private boolean removed;
        private String realmId;
        private UserStorageProviderModel storageProvider;

        public boolean isRemoved() {
            return this.removed;
        }

        public void setRemoved(boolean removed) {
            this.removed = removed;
        }

        public String getRealmId() {
            return this.realmId;
        }

        public void setRealmId(String realmId) {
            this.realmId = realmId;
        }

        public UserStorageProviderModel getStorageProvider() {
            return this.storageProvider;
        }

        public void setStorageProvider(UserStorageProviderModel federationProvider) {
            this.storageProvider = federationProvider;
        }

        public static UserStorageProviderClusterEvent createEvent(boolean removed, String realmId, UserStorageProviderModel provider) {
            UserStorageProviderClusterEvent notification = new UserStorageProviderClusterEvent();
            notification.setRemoved(removed);
            notification.setRealmId(realmId);
            notification.setStorageProvider(provider);
            return notification;
        }
    }

    private class UserStorageClusterListener
    implements ClusterListener {
        private final KeycloakSessionFactory sessionFactory;

        public UserStorageClusterListener(KeycloakSessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        public void run(ClusterEvent event) {
            final UserStorageProviderClusterEvent fedEvent = (UserStorageProviderClusterEvent)event;
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                public void run(KeycloakSession session) {
                    TimerProvider timer = (TimerProvider)session.getProvider(TimerProvider.class);
                    if (fedEvent.isRemoved()) {
                        UserStorageSyncManager.this.removePeriodicSyncForProvider(timer, fedEvent.getStorageProvider());
                    } else {
                        UserStorageSyncManager.this.refreshPeriodicSyncForProvider(UserStorageClusterListener.this.sessionFactory, timer, fedEvent.getStorageProvider(), fedEvent.getRealmId());
                    }
                }
            });
        }
    }

    private class Holder {
        ExecutionResult<SynchronizationResult> result;

        private Holder() {
        }
    }
}

