/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.keys.FailsafeRsaKeyProvider;
import org.keycloak.keys.KeyMetadata;
import org.keycloak.keys.KeyProvider;
import org.keycloak.keys.KeyProviderFactory;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;

public class DefaultKeyManager
implements KeyManager {
    private static final Logger logger = Logger.getLogger(DefaultKeyManager.class);
    private final KeycloakSession session;
    private final Map<String, List<KeyProvider>> providersMap = new HashMap<String, List<KeyProvider>>();

    public DefaultKeyManager(KeycloakSession session) {
        this.session = session;
    }

    public KeyManager.ActiveKey getActiveKey(RealmModel realm) {
        for (KeyProvider p : this.getProviders(realm)) {
            if (p.getKid() == null || p.getPrivateKey() == null) continue;
            if (logger.isTraceEnabled()) {
                logger.tracev("Active key realm={0} kid={1}", (Object)realm.getName(), (Object)p.getKid());
            }
            String kid = p.getKid();
            return new KeyManager.ActiveKey(kid, p.getPrivateKey(), p.getPublicKey(kid), p.getCertificate(kid));
        }
        throw new RuntimeException("Failed to get keys");
    }

    public PublicKey getPublicKey(RealmModel realm, String kid) {
        if (kid == null) {
            logger.warnv("KID is null, can't find public key", (Object)realm.getName(), (Object)kid);
            return null;
        }
        for (KeyProvider p : this.getProviders(realm)) {
            PublicKey publicKey = p.getPublicKey(kid);
            if (publicKey == null) continue;
            if (logger.isTraceEnabled()) {
                logger.tracev("Found public key realm={0} kid={1}", (Object)realm.getName(), (Object)kid);
            }
            return publicKey;
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("Failed to find public key realm={0} kid={1}", (Object)realm.getName(), (Object)kid);
        }
        return null;
    }

    public Certificate getCertificate(RealmModel realm, String kid) {
        if (kid == null) {
            logger.warnv("KID is null, can't find public key", (Object)realm.getName(), (Object)kid);
            return null;
        }
        for (KeyProvider p : this.getProviders(realm)) {
            X509Certificate certificate = p.getCertificate(kid);
            if (certificate == null) continue;
            if (logger.isTraceEnabled()) {
                logger.tracev("Found certificate realm={0} kid={1}", (Object)realm.getName(), (Object)kid);
            }
            return certificate;
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("Failed to find certificate realm={0} kid={1}", (Object)realm.getName(), (Object)kid);
        }
        return null;
    }

    public List<KeyMetadata> getKeys(RealmModel realm, boolean includeDisabled) {
        LinkedList<KeyMetadata> keys = new LinkedList<KeyMetadata>();
        for (KeyProvider p : this.getProviders(realm)) {
            if (includeDisabled) {
                keys.addAll(p.getKeyMetadata());
                continue;
            }
            p.getKeyMetadata().stream().filter(k -> k.getStatus() != KeyMetadata.Status.DISABLED).forEach(k -> keys.add((KeyMetadata)k));
        }
        return keys;
    }

    private List<KeyProvider> getProviders(RealmModel realm) {
        boolean active = false;
        List<KeyProvider> providers = this.providersMap.get(realm.getId());
        if (providers == null) {
            providers = new LinkedList<KeyProvider>();
            LinkedList<ComponentModel> components = new LinkedList<ComponentModel>(realm.getComponents(realm.getId(), KeyProvider.class.getName()));
            components.sort(new ProviderComparator());
            for (ComponentModel c : components) {
                try {
                    ProviderFactory f = this.session.getKeycloakSessionFactory().getProviderFactory(KeyProvider.class, c.getProviderId());
                    KeyProviderFactory factory = (KeyProviderFactory)f;
                    KeyProvider provider = factory.create(this.session, c);
                    this.session.enlistForClose((Provider)provider);
                    providers.add(provider);
                    if (active || provider.getKid() == null || provider.getPrivateKey() == null) continue;
                    active = true;
                }
                catch (Throwable t) {
                    logger.errorv(t, "Failed to load provider {0}", (Object)c.getId());
                }
            }
            if (!active) {
                providers.add(new FailsafeRsaKeyProvider());
            }
            this.providersMap.put(realm.getId(), providers);
        }
        return providers;
    }

    private class ProviderComparator
    implements Comparator<ComponentModel> {
        private ProviderComparator() {
        }

        @Override
        public int compare(ComponentModel o1, ComponentModel o2) {
            int i = Long.compare(o2.get("priority", 0L), o1.get("priority", 0L));
            return i != 0 ? i : o1.getId().compareTo(o2.getId());
        }
    }
}

