/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.services.ServicesLogger;

public class UserSessionManager {
    private static final Logger logger = Logger.getLogger(UserSessionManager.class);
    private final KeycloakSession kcSession;
    private final UserSessionPersisterProvider persister;

    public UserSessionManager(KeycloakSession session) {
        this.kcSession = session;
        this.persister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
    }

    public void createOrUpdateOfflineSession(ClientSessionModel clientSession, UserSessionModel userSession) {
        UserModel user = userSession.getUser();
        UserSessionModel offlineUserSession = this.kcSession.sessions().getOfflineUserSession(clientSession.getRealm(), userSession.getId());
        if (offlineUserSession == null) {
            offlineUserSession = this.createOfflineUserSession(user, userSession);
        } else {
            offlineUserSession.setLastSessionRefresh(Time.currentTime());
        }
        ClientSessionModel offlineClientSession = this.kcSession.sessions().getOfflineClientSession(clientSession.getRealm(), clientSession.getId());
        if (offlineClientSession == null) {
            this.createOfflineClientSession(user, clientSession, offlineUserSession);
        }
    }

    public ClientSessionModel findOfflineClientSession(RealmModel realm, String clientSessionId, String userSessionId) {
        ClientSessionModel clientSession = this.kcSession.sessions().getOfflineClientSession(realm, clientSessionId);
        if (clientSession == null) {
            return null;
        }
        if (!userSessionId.equals(clientSession.getUserSession().getId())) {
            throw new ModelException("User session don't match. Offline client session " + clientSession.getId() + ", It's user session " + clientSession.getUserSession().getId() + "  Wanted user session: " + userSessionId);
        }
        return clientSession;
    }

    public Set<ClientModel> findClientsWithOfflineToken(RealmModel realm, UserModel user) {
        List clientSessions = this.kcSession.sessions().getOfflineClientSessions(realm, user);
        HashSet<ClientModel> clients = new HashSet<ClientModel>();
        for (ClientSessionModel clientSession : clientSessions) {
            clients.add(clientSession.getClient());
        }
        return clients;
    }

    public List<UserSessionModel> findOfflineSessions(RealmModel realm, ClientModel client, UserModel user) {
        List clientSessions = this.kcSession.sessions().getOfflineClientSessions(realm, user);
        LinkedList<UserSessionModel> userSessions = new LinkedList<UserSessionModel>();
        for (ClientSessionModel clientSession : clientSessions) {
            userSessions.add(clientSession.getUserSession());
        }
        return userSessions;
    }

    public boolean revokeOfflineToken(UserModel user, ClientModel client) {
        RealmModel realm = client.getRealm();
        List clientSessions = this.kcSession.sessions().getOfflineClientSessions(realm, user);
        boolean anyRemoved = false;
        for (ClientSessionModel clientSession : clientSessions) {
            if (!clientSession.getClient().getId().equals(client.getId())) continue;
            if (logger.isTraceEnabled()) {
                logger.tracef("Removing existing offline token for user '%s' and client '%s' . ClientSessionID was '%s' .", (Object)user.getUsername(), (Object)client.getClientId(), (Object)clientSession.getId());
            }
            this.kcSession.sessions().removeOfflineClientSession(realm, clientSession.getId());
            this.persister.removeClientSession(clientSession.getId(), true);
            this.checkOfflineUserSessionHasClientSessions(realm, user, clientSession.getUserSession(), clientSessions);
            anyRemoved = true;
        }
        return anyRemoved;
    }

    public void revokeOfflineUserSession(UserSessionModel userSession) {
        if (logger.isTraceEnabled()) {
            logger.tracef("Removing offline user session '%s' for user '%s' ", (Object)userSession.getId(), (Object)userSession.getLoginUsername());
        }
        this.kcSession.sessions().removeOfflineUserSession(userSession.getRealm(), userSession);
        this.persister.removeUserSession(userSession.getId(), true);
    }

    public boolean isOfflineTokenAllowed(ClientSessionModel clientSession) {
        RoleModel offlineAccessRole = clientSession.getRealm().getRole("offline_access");
        if (offlineAccessRole == null) {
            ServicesLogger.LOGGER.roleNotInRealm("offline_access");
            return false;
        }
        return clientSession.getRoles().contains(offlineAccessRole.getId());
    }

    private UserSessionModel createOfflineUserSession(UserModel user, UserSessionModel userSession) {
        if (logger.isTraceEnabled()) {
            logger.tracef("Creating new offline user session. UserSessionID: '%s' , Username: '%s'", (Object)userSession.getId(), (Object)user.getUsername());
        }
        UserSessionModel offlineUserSession = this.kcSession.sessions().createOfflineUserSession(userSession);
        this.persister.createUserSession(offlineUserSession, true);
        return offlineUserSession;
    }

    private void createOfflineClientSession(UserModel user, ClientSessionModel clientSession, UserSessionModel userSession) {
        if (logger.isTraceEnabled()) {
            logger.tracef("Creating new offline token client session. ClientSessionId: '%s', UserSessionID: '%s' , Username: '%s', Client: '%s'", new Object[]{clientSession.getId(), userSession.getId(), user.getUsername(), clientSession.getClient().getClientId()});
        }
        ClientSessionModel offlineClientSession = this.kcSession.sessions().createOfflineClientSession(clientSession);
        offlineClientSession.setUserSession(userSession);
        this.persister.createClientSession(clientSession, true);
    }

    private void checkOfflineUserSessionHasClientSessions(RealmModel realm, UserModel user, UserSessionModel userSession, List<ClientSessionModel> clientSessions) {
        String userSessionId = userSession.getId();
        for (ClientSessionModel clientSession : clientSessions) {
            if (!clientSession.getUserSession().getId().equals(userSessionId)) continue;
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.tracef("Removing offline userSession for user %s as it doesn't have any client sessions attached. UserSessionID: %s", (Object)user.getUsername(), (Object)userSessionId);
        }
        this.kcSession.sessions().removeOfflineUserSession(realm, userSession);
        this.persister.removeUserSession(userSessionId, true);
    }
}

