/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.RoleMapperResource;

public class GroupResource {
    private final RealmModel realm;
    private final KeycloakSession session;
    private final RealmAuth auth;
    private final AdminEventBuilder adminEvent;
    private final GroupModel group;
    @Context
    private UriInfo uriInfo;

    public GroupResource(RealmModel realm, GroupModel group, KeycloakSession session, RealmAuth auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.GROUP);
        this.group = group;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public GroupRepresentation getGroup() {
        this.auth.requireView();
        if (this.group == null) {
            throw new NotFoundException("Could not find group by id");
        }
        return ModelToRepresentation.toGroupHierarchy((GroupModel)this.group, (boolean)true);
    }

    @PUT
    @Consumes(value={"application/json"})
    public void updateGroup(GroupRepresentation rep) {
        this.auth.requireManage();
        if (this.group == null) {
            throw new NotFoundException("Could not find group by id");
        }
        GroupResource.updateGroup(rep, this.group);
        this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(rep).success();
    }

    @DELETE
    public void deleteGroup() {
        this.auth.requireManage();
        if (this.group == null) {
            throw new NotFoundException("Could not find group by id");
        }
        this.realm.removeGroup(this.group);
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    @POST
    @Path(value="children")
    @NoCache
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addChild(GroupRepresentation rep) {
        this.auth.requireManage();
        if (this.group == null) {
            throw new NotFoundException("Could not find group by id");
        }
        Response.ResponseBuilder builder = Response.status((int)204);
        GroupModel child = null;
        if (rep.getId() != null) {
            child = this.realm.getGroupById(rep.getId());
            if (child == null) {
                throw new NotFoundException("Could not find child by id");
            }
            this.adminEvent.operation(OperationType.UPDATE);
        } else {
            child = this.realm.createGroup(rep.getName());
            GroupResource.updateGroup(rep, child);
            URI uri = this.uriInfo.getBaseUriBuilder().path((String)this.uriInfo.getMatchedURIs().get(2)).path(child.getId()).build(new Object[0]);
            builder.status(201).location(uri);
            rep.setId(child.getId());
            this.adminEvent.operation(OperationType.CREATE);
        }
        this.realm.moveGroup(child, this.group);
        this.adminEvent.resourcePath(this.uriInfo).representation(rep).success();
        GroupRepresentation childRep = ModelToRepresentation.toGroupHierarchy((GroupModel)child, (boolean)true);
        return builder.type(MediaType.APPLICATION_JSON_TYPE).entity((Object)childRep).build();
    }

    public static void updateGroup(GroupRepresentation rep, GroupModel model) {
        if (rep.getName() != null) {
            model.setName(rep.getName());
        }
        if (rep.getAttributes() != null) {
            HashSet attrsToRemove = new HashSet(model.getAttributes().keySet());
            attrsToRemove.removeAll(rep.getAttributes().keySet());
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                model.setAttribute((String)entry.getKey(), (List)entry.getValue());
            }
            for (String string : attrsToRemove) {
                model.removeAttribute(string);
            }
        }
    }

    @Path(value="role-mappings")
    public RoleMapperResource getRoleMappings() {
        this.auth.init(RealmAuth.Resource.USER);
        RoleMapperResource resource = new RoleMapperResource(this.realm, this.auth, (RoleMapperModel)this.group, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @GET
    @NoCache
    @Path(value="members")
    @Produces(value={"application/json"})
    public List<UserRepresentation> getMembers(@QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        this.auth.requireView();
        if (this.group == null) {
            throw new NotFoundException("Could not find group by id");
        }
        firstResult = firstResult != null ? firstResult : -1;
        maxResults = maxResults != null ? maxResults : 100;
        ArrayList<UserRepresentation> results = new ArrayList<UserRepresentation>();
        List userModels = this.session.users().getGroupMembers(this.realm, this.group, firstResult.intValue(), maxResults.intValue());
        for (UserModel user : userModels) {
            results.add(ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user));
        }
        return results;
    }
}

