/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import javax.ws.rs.POST;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.TokenIntrospectionProvider;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.services.ErrorResponseException;

public class TokenIntrospectionEndpoint {
    private static final String PARAM_TOKEN_TYPE_HINT = "token_type_hint";
    private static final String PARAM_TOKEN = "token";
    @Context
    private KeycloakSession session;
    @Context
    private HttpRequest request;
    @Context
    private HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private ClientConnection clientConnection;
    private final RealmModel realm;
    private final EventBuilder event;

    public TokenIntrospectionEndpoint(RealmModel realm, EventBuilder event) {
        this.realm = realm;
        this.event = event;
    }

    @POST
    @NoCache
    public Response introspect() {
        String token;
        this.event.event(EventType.INTROSPECT_TOKEN);
        this.checkSsl();
        this.checkRealm();
        this.authorizeClient();
        MultivaluedMap formParams = this.request.getDecodedFormParameters();
        String tokenTypeHint = (String)formParams.getFirst((Object)PARAM_TOKEN_TYPE_HINT);
        if (tokenTypeHint == null) {
            tokenTypeHint = "access_token";
        }
        if ((token = (String)formParams.getFirst((Object)PARAM_TOKEN)) == null) {
            throw this.throwErrorResponseException("invalid_request", "Token not provided.", Response.Status.BAD_REQUEST);
        }
        TokenIntrospectionProvider provider = (TokenIntrospectionProvider)this.session.getProvider(TokenIntrospectionProvider.class, tokenTypeHint);
        if (provider == null) {
            throw this.throwErrorResponseException("invalid_request", "Unsupported token type [" + tokenTypeHint + "].", Response.Status.BAD_REQUEST);
        }
        try {
            Response response = provider.introspect(token);
            this.event.success();
            return response;
        }
        catch (ErrorResponseException ere) {
            throw ere;
        }
        catch (Exception e) {
            throw this.throwErrorResponseException("invalid_request", "Failed to introspect token.", Response.Status.BAD_REQUEST);
        }
    }

    private void authorizeClient() {
        try {
            ClientModel client = AuthorizeClientUtil.authorizeClient(this.session, this.event).getClient();
            this.event.client(client);
            if (client == null || client.isPublicClient()) {
                throw this.throwErrorResponseException("invalid_request", "Client not allowed.", Response.Status.FORBIDDEN);
            }
        }
        catch (ErrorResponseException ere) {
            throw ere;
        }
        catch (Exception e) {
            throw this.throwErrorResponseException("invalid_request", "Authentication failed.", Response.Status.UNAUTHORIZED);
        }
    }

    private void checkSsl() {
        if (!this.uriInfo.getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            throw new ErrorResponseException("invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    private void checkRealm() {
        if (!this.realm.isEnabled()) {
            throw new ErrorResponseException("access_denied", "Realm not enabled", Response.Status.FORBIDDEN);
        }
    }

    private ErrorResponseException throwErrorResponseException(String error, String detail, Response.Status status) {
        this.event.detail("detail", detail).error(error);
        return new ErrorResponseException(error, detail, status);
    }
}

