/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.protection.permission;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.protection.permission.PermissionTicket;
import org.keycloak.authorization.protection.permission.representation.PermissionRequest;
import org.keycloak.authorization.protection.permission.representation.PermissionResponse;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.KeyManager;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.services.ErrorResponseException;

public class AbstractPermissionService {
    private final AuthorizationProvider authorization;
    private final KeycloakIdentity identity;
    private final ResourceServer resourceServer;

    public AbstractPermissionService(KeycloakIdentity identity, ResourceServer resourceServer, AuthorizationProvider authorization) {
        this.identity = identity;
        this.resourceServer = resourceServer;
        this.authorization = authorization;
    }

    public Response create(List<PermissionRequest> request) {
        if (request == null) {
            throw new ErrorResponseException("invalid_permission_request", "Invalid permission request.", Response.Status.BAD_REQUEST);
        }
        List<ResourceRepresentation> resource = this.verifyRequestedResource(request);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new PermissionResponse(this.createPermissionTicket(resource))).build();
    }

    private List<ResourceRepresentation> verifyRequestedResource(List<PermissionRequest> request) {
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        return request.stream().map(request1 -> {
            boolean resourceNotProvider;
            String resourceSetId = request1.getResourceSetId();
            String resourceSetName = request1.getResourceSetName();
            boolean bl = resourceNotProvider = resourceSetId == null && resourceSetName == null;
            if (resourceNotProvider && (request1.getScopes() == null || request1.getScopes().isEmpty())) {
                throw new ErrorResponseException("invalid_resource_set_id", "Resource id or name not provided.", Response.Status.BAD_REQUEST);
            }
            Resource resource = null;
            if (!resourceNotProvider && (resource = resourceSetId != null ? storeFactory.getResourceStore().findById(resourceSetId, this.resourceServer.getId()) : storeFactory.getResourceStore().findByName(resourceSetName, this.resourceServer.getId())) == null) {
                if (resourceSetId != null) {
                    throw new ErrorResponseException("nonexistent_resource_set_id", "Resource set with id[" + resourceSetId + "] does not exists in this server.", Response.Status.BAD_REQUEST);
                }
                throw new ErrorResponseException("nonexistent_resource_set_name", "Resource set with name[" + resourceSetName + "] does not exists in this server.", Response.Status.BAD_REQUEST);
            }
            Set<ScopeRepresentation> scopes = this.verifyRequestedScopes((PermissionRequest)request1, resource);
            if (resource != null) {
                if (scopes.isEmpty() && !request1.getScopes().isEmpty()) {
                    return new ResourceRepresentation(null, request1.getScopes().stream().map(ScopeRepresentation::new).collect(Collectors.toSet()));
                }
                return new ResourceRepresentation(resource.getName(), scopes);
            }
            return new ResourceRepresentation(null, scopes);
        }).collect(Collectors.toList());
    }

    private Set<ScopeRepresentation> verifyRequestedScopes(PermissionRequest request, Resource resource) {
        return request.getScopes().stream().map(scopeName -> {
            if (resource != null) {
                for (Scope scope : resource.getScopes()) {
                    if (!scope.getName().equals(scopeName)) continue;
                    return new ScopeRepresentation(scopeName);
                }
                for (Resource baseResource : this.authorization.getStoreFactory().getResourceStore().findByType(resource.getType(), this.resourceServer.getId())) {
                    if (!baseResource.getOwner().equals(resource.getResourceServer().getClientId())) continue;
                    for (Scope baseScope : baseResource.getScopes()) {
                        if (!baseScope.getName().equals(scopeName)) continue;
                        return new ScopeRepresentation(scopeName);
                    }
                }
                return null;
            }
            return new ScopeRepresentation(scopeName);
        }).filter(scopeRepresentation -> scopeRepresentation != null).collect(Collectors.toSet());
    }

    private String createPermissionTicket(List<ResourceRepresentation> resources) {
        KeyManager.ActiveRsaKey keys = this.authorization.getKeycloakSession().keys().getActiveRsaKey(this.authorization.getRealm());
        return new JWSBuilder().kid(keys.getKid()).jsonContent((Object)new PermissionTicket(resources, this.resourceServer.getId(), this.identity.getAccessToken())).rsa256(keys.getPrivateKey());
    }
}

