/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.HashMap;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.common.ClientConnection;
import org.keycloak.component.ComponentModel;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.UserStorageSyncManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.storage.user.SynchronizationResult;

public class UserStorageProviderResource {
    private static final Logger logger = Logger.getLogger(UserStorageProviderResource.class);
    protected RealmModel realm;
    protected RealmAuth auth;
    protected AdminEventBuilder adminEvent;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpHeaders headers;

    public UserStorageProviderResource(RealmModel realm, RealmAuth auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent;
        auth.init(RealmAuth.Resource.USER);
    }

    @POST
    @Path(value="{id}/sync")
    @NoCache
    @Produces(value={"application/json"})
    public SynchronizationResult syncUsers(@PathParam(value="id") String id, @QueryParam(value="action") String action) {
        SynchronizationResult syncResult;
        this.auth.requireManage();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        if (!model.getProviderType().equals(UserStorageProvider.class.getName())) {
            throw new NotFoundException("found, but not a UserStorageProvider");
        }
        UserStorageProviderModel providerModel = new UserStorageProviderModel(model);
        logger.debug((Object)"Syncing users");
        UserStorageSyncManager syncManager = new UserStorageSyncManager();
        if ("triggerFullSync".equals(action)) {
            syncResult = syncManager.syncAllUsers(this.session.getKeycloakSessionFactory(), this.realm.getId(), providerModel);
        } else if ("triggerChangedUsersSync".equals(action)) {
            syncResult = syncManager.syncChangedUsers(this.session.getKeycloakSessionFactory(), this.realm.getId(), providerModel);
        } else {
            throw new NotFoundException("Unknown action: " + action);
        }
        HashMap<String, String> eventRep = new HashMap<String, String>();
        eventRep.put("action", action);
        eventRep.put("result", (String)syncResult);
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).representation(eventRep).success();
        return syncResult;
    }

    @POST
    @Path(value="{parentId}/mappers/{id}/sync")
    @NoCache
    @Produces(value={"application/json"})
    public SynchronizationResult syncMapperData(@PathParam(value="parentId") String parentId, @PathParam(value="id") String mapperId, @QueryParam(value="direction") String direction) {
        SynchronizationResult syncResult;
        this.auth.requireManage();
        ComponentModel parentModel = this.realm.getComponent(parentId);
        if (parentModel == null) {
            throw new NotFoundException("Parent model not found");
        }
        ComponentModel mapperModel = this.realm.getComponent(mapperId);
        if (mapperModel == null) {
            throw new NotFoundException("Mapper model not found");
        }
        LDAPStorageProvider ldapProvider = (LDAPStorageProvider)this.session.getProvider(UserStorageProvider.class, parentModel);
        LDAPStorageMapper mapper = (LDAPStorageMapper)this.session.getProvider(LDAPStorageMapper.class, mapperModel);
        ServicesLogger.LOGGER.syncingDataForMapper(mapperModel.getName(), mapperModel.getProviderId(), direction);
        if ("fedToKeycloak".equals(direction)) {
            syncResult = mapper.syncDataFromFederationProviderToKeycloak(this.realm);
        } else if ("keycloakToFed".equals(direction)) {
            syncResult = mapper.syncDataFromKeycloakToFederationProvider(this.realm);
        } else {
            throw new BadRequestException("Unknown direction: " + direction);
        }
        HashMap<String, String> eventRep = new HashMap<String, String>();
        eventRep.put("action", direction);
        eventRep.put("result", (String)syncResult);
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).representation(eventRep).success();
        return syncResult;
    }
}

