/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.truststore;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.truststore.FileTruststoreProvider;
import org.keycloak.truststore.HostnameVerificationPolicy;
import org.keycloak.truststore.TruststoreProvider;
import org.keycloak.truststore.TruststoreProviderFactory;
import org.keycloak.truststore.TruststoreProviderSingleton;

public class FileTruststoreProviderFactory
implements TruststoreProviderFactory {
    private static final Logger log = Logger.getLogger(FileTruststoreProviderFactory.class);
    private TruststoreProvider provider;

    public TruststoreProvider create(KeycloakSession session) {
        return this.provider;
    }

    public void init(Config.Scope config) {
        String storepath = config.get("file");
        String pass = config.get("password");
        String policy = config.get("hostname-verification-policy");
        Boolean disabled = config.getBoolean("disabled", null);
        if (storepath == null && pass == null && policy == null && disabled == null) {
            return;
        }
        if (disabled != null && disabled.booleanValue()) {
            return;
        }
        HostnameVerificationPolicy verificationPolicy = null;
        KeyStore truststore = null;
        if (storepath == null) {
            throw new RuntimeException("Attribute 'file' missing in 'truststore':'file' configuration");
        }
        if (pass == null) {
            throw new RuntimeException("Attribute 'password' missing in 'truststore':'file' configuration");
        }
        try {
            truststore = this.loadStore(storepath, pass == null ? null : pass.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize TruststoreProviderFactory: " + new File(storepath).getAbsolutePath(), e);
        }
        if (policy == null) {
            verificationPolicy = HostnameVerificationPolicy.WILDCARD;
        } else {
            try {
                verificationPolicy = HostnameVerificationPolicy.valueOf((String)policy);
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid value for 'hostname-verification-policy': " + policy + " (must be one of: ANY, WILDCARD, STRICT)");
            }
        }
        this.provider = new FileTruststoreProvider(truststore, verificationPolicy);
        TruststoreProviderSingleton.set(this.provider);
        log.debug((Object)("File trustore provider initialized: " + new File(storepath).getAbsolutePath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadStore(String path, char[] password) throws Exception {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream is = new FileInputStream(path);
        try {
            ks.load(is, password);
            KeyStore keyStore = ks;
            return keyStore;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "file";
    }
}

