/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.PolicyService;
import org.keycloak.authorization.admin.PolicyTypeResourceService;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProviderAdminService;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.util.JsonSerialization;

public class PolicyTypeService
extends PolicyService {
    private final String type;

    public PolicyTypeService(String type, ResourceServer resourceServer, AuthorizationProvider authorization, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        super(resourceServer, authorization, auth, adminEvent);
        this.type = type;
    }

    @Path(value="/provider")
    public Object getPolicyAdminResourceProvider() {
        PolicyProviderAdminService resource = this.getPolicyProviderAdminResource(this.type);
        if (resource == null) {
            return null;
        }
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Override
    protected Object doCreatePolicyResource(Policy policy) {
        return new PolicyTypeResourceService(policy, this.resourceServer, this.authorization, this.auth, this.adminEvent);
    }

    @Override
    protected AbstractPolicyRepresentation doCreateRepresentation(String payload) {
        AbstractPolicyRepresentation representation;
        PolicyProviderFactory provider = this.getPolicyProviderFactory(this.type);
        Class representationType = provider.getRepresentationType();
        if (representationType == null) {
            throw new RuntimeException("Policy provider for type [" + this.type + "] returned a null representation type.");
        }
        try {
            representation = (AbstractPolicyRepresentation)JsonSerialization.readValue((String)payload, (Class)representationType);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize JSON using policy provider for type [" + this.type + "].", e);
        }
        if (!"js".equals(this.type) || representation.getType() == null) {
            representation.setType(this.type);
        }
        return representation;
    }

    @Override
    protected AbstractPolicyRepresentation toRepresentation(Policy policy, String fields, AuthorizationProvider authorization) {
        return ModelToRepresentation.toRepresentation((Policy)policy, (AuthorizationProvider)authorization, (boolean)false, (boolean)false);
    }

    @Override
    protected List<Object> doSearch(Integer firstResult, Integer maxResult, String fields, Map<Policy.FilterOption, String[]> filters) {
        filters.put(Policy.FilterOption.TYPE, new String[]{this.type});
        return super.doSearch(firstResult, maxResult, fields, filters);
    }
}

