/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.twitter;

import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.provider.AbstractIdentityProvider;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.ExchangeTokenToIdentityProviderToken;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.IdentityBrokerState;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.vault.VaultStringSecret;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.User;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterIdentityProvider
extends AbstractIdentityProvider<OAuth2IdentityProviderConfig>
implements SocialIdentityProvider<OAuth2IdentityProviderConfig>,
ExchangeTokenToIdentityProviderToken {
    String TWITTER_TOKEN_TYPE = "twitter";
    protected static final Logger logger = Logger.getLogger(TwitterIdentityProvider.class);
    private static final String TWITTER_TOKEN = "twitter_token";
    private static final String TWITTER_TOKENSECRET = "twitter_tokenSecret";

    public TwitterIdentityProvider(KeycloakSession session, OAuth2IdentityProviderConfig config) {
        super(session, (IdentityProviderModel)config);
    }

    public Object callback(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
        return new Endpoint(realm, callback, event);
    }

    public Response performLogin(AuthenticationRequest request) {
        Response response;
        block8: {
            VaultStringSecret vaultStringSecret = this.session.vault().getStringSecret(((OAuth2IdentityProviderConfig)this.getConfig()).getClientSecret());
            try {
                Twitter twitter = new TwitterFactory().getInstance();
                twitter.setOAuthConsumer(((OAuth2IdentityProviderConfig)this.getConfig()).getClientId(), vaultStringSecret.get().orElse(((OAuth2IdentityProviderConfig)this.getConfig()).getClientSecret()));
                URI uri = new URI(request.getRedirectUri() + "?state=" + request.getState().getEncoded());
                RequestToken requestToken = twitter.getOAuthRequestToken(uri.toString());
                AuthenticationSessionModel authSession = request.getAuthenticationSession();
                authSession.setAuthNote(TWITTER_TOKEN, requestToken.getToken());
                authSession.setAuthNote(TWITTER_TOKENSECRET, requestToken.getTokenSecret());
                URI authenticationUrl = URI.create(requestToken.getAuthenticationURL());
                response = Response.seeOther((URI)authenticationUrl).build();
                if (vaultStringSecret == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (vaultStringSecret != null) {
                        try {
                            vaultStringSecret.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IdentityBrokerException("Could send authentication request to twitter.", (Throwable)e);
                }
            }
            vaultStringSecret.close();
        }
        return response;
    }

    public Response exchangeFromToken(UriInfo uriInfo, EventBuilder builder, ClientModel authorizedClient, UserSessionModel tokenUserSession, UserModel tokenSubject, MultivaluedMap<String, String> params) {
        String requestedType = (String)params.getFirst((Object)"requested_token_type");
        if (requestedType != null && !requestedType.equals(this.TWITTER_TOKEN_TYPE)) {
            return this.exchangeUnsupportedRequiredType();
        }
        if (!((OAuth2IdentityProviderConfig)this.getConfig()).isStoreToken()) {
            String brokerId = tokenUserSession.getNote("identity_provider");
            if (brokerId == null || !brokerId.equals(((OAuth2IdentityProviderConfig)this.getConfig()).getAlias())) {
                return this.exchangeNotLinkedNoStore(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
            }
            return this.exchangeSessionToken(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
        }
        return this.exchangeStoredToken(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
    }

    protected Response exchangeStoredToken(UriInfo uriInfo, ClientModel authorizedClient, UserSessionModel tokenUserSession, UserModel tokenSubject) {
        FederatedIdentityModel model = this.session.users().getFederatedIdentity(authorizedClient.getRealm(), tokenSubject, ((OAuth2IdentityProviderConfig)this.getConfig()).getAlias());
        if (model == null || model.getToken() == null) {
            return this.exchangeNotLinked(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
        }
        String accessToken = model.getToken();
        if (accessToken == null) {
            model.setToken(null);
            this.session.users().updateFederatedIdentity(authorizedClient.getRealm(), tokenSubject, model);
            return this.exchangeTokenExpired(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
        }
        AccessTokenResponse tokenResponse = new AccessTokenResponse();
        tokenResponse.setToken(accessToken);
        tokenResponse.setIdToken(null);
        tokenResponse.setRefreshToken(null);
        tokenResponse.setRefreshExpiresIn(0L);
        tokenResponse.getOtherClaims().clear();
        tokenResponse.getOtherClaims().put("issued_token_type", this.TWITTER_TOKEN_TYPE);
        tokenResponse.getOtherClaims().put("account-link-url", this.getLinkingUrl(uriInfo, authorizedClient, tokenUserSession));
        return Response.ok((Object)tokenResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected Response exchangeSessionToken(UriInfo uriInfo, ClientModel authorizedClient, UserSessionModel tokenUserSession, UserModel tokenSubject) {
        String accessToken = tokenUserSession.getNote("FEDERATED_ACCESS_TOKEN");
        if (accessToken == null) {
            return this.exchangeTokenExpired(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
        }
        AccessTokenResponse tokenResponse = new AccessTokenResponse();
        tokenResponse.setToken(accessToken);
        tokenResponse.setIdToken(null);
        tokenResponse.setRefreshToken(null);
        tokenResponse.setRefreshExpiresIn(0L);
        tokenResponse.getOtherClaims().clear();
        tokenResponse.getOtherClaims().put("issued_token_type", this.TWITTER_TOKEN_TYPE);
        tokenResponse.getOtherClaims().put("account-link-url", this.getLinkingUrl(uriInfo, authorizedClient, tokenUserSession));
        return Response.ok((Object)tokenResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public Response retrieveToken(KeycloakSession session, FederatedIdentityModel identity) {
        return Response.ok((Object)identity.getToken()).type("application/json").build();
    }

    public void authenticationFinished(AuthenticationSessionModel authSession, BrokeredIdentityContext context) {
        authSession.setUserSessionNote("FEDERATED_ACCESS_TOKEN", (String)context.getContextData().get("FEDERATED_ACCESS_TOKEN"));
    }

    protected class Endpoint {
        protected RealmModel realm;
        protected IdentityProvider.AuthenticationCallback callback;
        protected EventBuilder event;
        @Context
        protected KeycloakSession session;
        @Context
        protected ClientConnection clientConnection;
        @Context
        protected HttpHeaders headers;

        public Endpoint(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
            this.realm = realm;
            this.callback = callback;
            this.event = event;
        }

        @GET
        public Response authResponse(@QueryParam(value="state") String state, @QueryParam(value="denied") String denied, @QueryParam(value="oauth_verifier") String verifier) {
            Response response;
            block12: {
                IdentityBrokerState idpState = IdentityBrokerState.encoded((String)state, (RealmModel)this.realm);
                String clientId = idpState.getClientId();
                String tabId = idpState.getTabId();
                if (clientId == null || tabId == null) {
                    logger.errorf("Invalid state parameter: %s", (Object)state);
                    this.sendErrorEvent();
                    return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
                }
                ClientModel client = this.realm.getClientByClientId(clientId);
                AuthenticationSessionModel authSession = ClientSessionCode.getClientSession(state, tabId, this.session, this.realm, client, this.event, AuthenticationSessionModel.class);
                if (denied != null) {
                    return this.callback.cancelled();
                }
                VaultStringSecret vaultStringSecret = this.session.vault().getStringSecret(((OAuth2IdentityProviderConfig)TwitterIdentityProvider.this.getConfig()).getClientSecret());
                try {
                    Twitter twitter = new TwitterFactory(new ConfigurationBuilder().setIncludeEmailEnabled(true).build()).getInstance();
                    twitter.setOAuthConsumer(((OAuth2IdentityProviderConfig)TwitterIdentityProvider.this.getConfig()).getClientId(), vaultStringSecret.get().orElse(((OAuth2IdentityProviderConfig)TwitterIdentityProvider.this.getConfig()).getClientSecret()));
                    String twitterToken = authSession.getAuthNote(TwitterIdentityProvider.TWITTER_TOKEN);
                    String twitterSecret = authSession.getAuthNote(TwitterIdentityProvider.TWITTER_TOKENSECRET);
                    RequestToken requestToken = new RequestToken(twitterToken, twitterSecret);
                    AccessToken oAuthAccessToken = twitter.getOAuthAccessToken(requestToken, verifier);
                    User twitterUser = twitter.verifyCredentials();
                    BrokeredIdentityContext identity = new BrokeredIdentityContext(Long.toString(twitterUser.getId()));
                    identity.setIdp((IdentityProvider)TwitterIdentityProvider.this);
                    identity.setUsername(twitterUser.getScreenName());
                    identity.setEmail(twitterUser.getEmail());
                    identity.setName(twitterUser.getName());
                    StringBuilder tokenBuilder = new StringBuilder();
                    tokenBuilder.append("{");
                    tokenBuilder.append("\"oauth_token\":").append("\"").append(oAuthAccessToken.getToken()).append("\"").append(",");
                    tokenBuilder.append("\"oauth_token_secret\":").append("\"").append(oAuthAccessToken.getTokenSecret()).append("\"").append(",");
                    tokenBuilder.append("\"screen_name\":").append("\"").append(oAuthAccessToken.getScreenName()).append("\"").append(",");
                    tokenBuilder.append("\"user_id\":").append("\"").append(oAuthAccessToken.getUserId()).append("\"");
                    tokenBuilder.append("}");
                    String token = tokenBuilder.toString();
                    if (((OAuth2IdentityProviderConfig)TwitterIdentityProvider.this.getConfig()).isStoreToken()) {
                        identity.setToken(token);
                    }
                    identity.getContextData().put("FEDERATED_ACCESS_TOKEN", token);
                    identity.setIdpConfig(TwitterIdentityProvider.this.getConfig());
                    identity.setAuthenticationSession(authSession);
                    response = this.callback.authenticated(identity);
                    if (vaultStringSecret == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (vaultStringSecret != null) {
                            try {
                                vaultStringSecret.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (WebApplicationException e) {
                        this.sendErrorEvent();
                        return e.getResponse();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Couldn't get user profile from twitter.", (Throwable)e);
                        this.sendErrorEvent();
                        return ErrorPage.error(this.session, authSession, Response.Status.BAD_GATEWAY, "unexpectedErrorHandlingResponseMessage", new Object[0]);
                    }
                }
                vaultStringSecret.close();
            }
            return response;
        }

        private void sendErrorEvent() {
            this.event.event(EventType.LOGIN);
            this.event.error("twitter_login_failed");
        }
    }
}

