/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import org.jboss.logging.Logger;
import org.jboss.resteasy.util.CookieParser;
import org.keycloak.common.util.ServerCookie;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;

public class CookieHelper {
    public static final String LEGACY_COOKIE = "_LEGACY";
    private static final Logger logger = Logger.getLogger(CookieHelper.class);
    private static final String ADD_COOKIES_AT_END_OF_TRANSACTION = CookieHelper.class.getName() + "_ADD_COOKIES_AT_END_OF_TRANSACTION";

    public static void addCookie(String name, String value, String path, String domain, String comment, int maxAge, boolean secure, boolean httpOnly, ServerCookie.SameSiteAttributeValue sameSite, KeycloakSession session) {
        ServerCookie.SameSiteAttributeValue sameSiteParam = sameSite;
        if (maxAge == 0) {
            sameSite = null;
        }
        boolean secure_sameSite = sameSite == ServerCookie.SameSiteAttributeValue.NONE || secure;
        HttpResponse response = session.getContext().getHttpResponse();
        StringBuffer cookieBuf = new StringBuffer();
        ServerCookie.appendCookieValue((StringBuffer)cookieBuf, (int)1, (String)name, (String)value, (String)path, (String)domain, (String)comment, (int)maxAge, (boolean)secure_sameSite, (boolean)httpOnly, (ServerCookie.SameSiteAttributeValue)sameSite);
        String cookie = cookieBuf.toString();
        if (CookieHelper.shouldAddCookiesAtEndOfTransaction(session)) {
            session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)new CookieTransaction(response, cookie));
        } else {
            response.addHeader("Set-Cookie", cookie);
        }
        if (sameSiteParam == ServerCookie.SameSiteAttributeValue.NONE) {
            CookieHelper.addCookie(name + LEGACY_COOKIE, value, path, domain, comment, maxAge, secure, httpOnly, null, session);
        }
    }

    private static boolean shouldAddCookiesAtEndOfTransaction(KeycloakSession session) {
        return Objects.equals(session.getAttribute(ADD_COOKIES_AT_END_OF_TRANSACTION), Boolean.TRUE);
    }

    public static void addCookiesAtEndOfTransaction(KeycloakSession session) {
        session.setAttribute(ADD_COOKIES_AT_END_OF_TRANSACTION, (Object)Boolean.TRUE);
    }

    public static void addCookie(String name, String value, String path, String domain, String comment, int maxAge, boolean secure, boolean httpOnly, KeycloakSession session) {
        CookieHelper.addCookie(name, value, path, domain, comment, maxAge, secure, httpOnly, null, session);
    }

    public static Set<String> getCookieValue(KeycloakSession session, String name) {
        Set<String> ret = CookieHelper.getInternalCookieValue(session, name);
        if (ret.size() == 0) {
            String legacy = name + LEGACY_COOKIE;
            logger.debugv("Could not find any cookies with name '{0}', trying '{1}'", (Object)name, (Object)legacy);
            ret = CookieHelper.getInternalCookieValue(session, legacy);
        }
        return ret;
    }

    private static Set<String> getInternalCookieValue(KeycloakSession session, String name) {
        HttpHeaders headers = session.getContext().getHttpRequest().getHttpHeaders();
        HashSet<String> cookiesVal = new HashSet<String>();
        cookiesVal.addAll(CookieHelper.parseCookie((String)headers.getRequestHeaders().getFirst((Object)"Cookie"), name));
        Cookie cookie = (Cookie)headers.getCookies().get(name);
        if (cookie != null) {
            logger.debugv("{0} cookie found in the cookie field", (Object)name);
            cookiesVal.add(cookie.getValue());
        }
        return cookiesVal;
    }

    public static Set<String> parseCookie(String header, String name) {
        if (header == null || name == null) {
            return Collections.emptySet();
        }
        HashSet<String> values = new HashSet<String>();
        for (Cookie cookie : CookieParser.parseCookies((String)header)) {
            if (!name.equals(cookie.getName())) continue;
            logger.debugv("{0} cookie found in the request header", (Object)name);
            values.add(cookie.getValue());
        }
        return values;
    }

    public static Cookie getCookie(Map<String, Cookie> cookies, String name) {
        Cookie cookie = cookies.get(name);
        if (cookie != null) {
            return cookie;
        }
        String legacy = name + LEGACY_COOKIE;
        logger.debugv("Could not find cookie {0}, trying {1}", (Object)name, (Object)legacy);
        return cookies.get(legacy);
    }

    private static class CookieTransaction
    implements KeycloakTransaction {
        private final HttpResponse response;
        private final String cookie;
        private boolean transactionActive;

        public CookieTransaction(HttpResponse response, String cookie) {
            this.response = response;
            this.cookie = cookie;
        }

        public void begin() {
            this.transactionActive = true;
        }

        public void commit() {
            this.response.addHeader("Set-Cookie", this.cookie);
            this.transactionActive = false;
        }

        public void rollback() {
            this.transactionActive = false;
        }

        public void setRollbackOnly() {
        }

        public boolean getRollbackOnly() {
            return false;
        }

        public boolean isActive() {
            return this.transactionActive;
        }
    }
}

