/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.authentication.otp.OTPApplicationProvider;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.HmacOTP;
import org.keycloak.utils.TotpUtils;

public class TotpBean {
    private KeycloakSession session;
    private final RealmModel realm;
    private final String totpSecret;
    private final String totpSecretEncoded;
    private final String totpSecretQrCode;
    private final boolean enabled;
    private UriBuilder uriBuilder;
    private final List<CredentialModel> otpCredentials;
    private final List<String> supportedApplications;
    private final UserModel user;

    public TotpBean(KeycloakSession session, RealmModel realm, UserModel user, UriBuilder uriBuilder) {
        this.session = session;
        this.realm = realm;
        this.user = user;
        this.uriBuilder = uriBuilder;
        this.enabled = user.credentialManager().isConfiguredFor("otp");
        this.otpCredentials = this.enabled ? user.credentialManager().getStoredCredentialsByTypeStream("otp").collect(Collectors.toList()) : Collections.EMPTY_LIST;
        this.totpSecret = HmacOTP.generateSecret((int)20);
        this.totpSecretEncoded = TotpUtils.encode(this.totpSecret);
        this.totpSecretQrCode = TotpUtils.qrCode(this.totpSecret, realm, user);
        OTPPolicy otpPolicy = realm.getOTPPolicy();
        this.supportedApplications = session.getAllProviders(OTPApplicationProvider.class).stream().filter(p -> p.supports(otpPolicy)).map(OTPApplicationProvider::getName).collect(Collectors.toList());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTotpSecret() {
        return this.totpSecret;
    }

    public String getTotpSecretEncoded() {
        return this.totpSecretEncoded;
    }

    public String getTotpSecretQrCode() {
        return this.totpSecretQrCode;
    }

    public String getManualUrl() {
        return this.uriBuilder.replaceQueryParam("session_code", new Object[0]).replaceQueryParam("mode", new Object[]{"manual"}).replaceQueryParam("execution", new Object[]{UserModel.RequiredAction.CONFIGURE_TOTP.name()}).build(new Object[0]).toString();
    }

    public String getQrUrl() {
        return this.uriBuilder.replaceQueryParam("session_code", new Object[0]).replaceQueryParam("mode", new Object[]{"qr"}).build(new Object[0]).toString();
    }

    public OTPPolicy getPolicy() {
        return this.realm.getOTPPolicy();
    }

    public List<String> getSupportedApplications() {
        return this.supportedApplications;
    }

    public List<CredentialModel> getOtpCredentials() {
        return this.otpCredentials;
    }

    public String getUsername() {
        return this.user.getUsername();
    }
}

