/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import javax.ws.rs.core.CacheControl;
import org.keycloak.Config;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;

public class CacheControlUtil {
    public static void noBackButtonCacheControlHeader(KeycloakSession session) {
        KeycloakContext context = session.getContext();
        HttpResponse response = context.getHttpResponse();
        response.setHeader("Cache-Control", "no-store, must-revalidate, max-age=0");
    }

    public static CacheControl getDefaultCacheControl() {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoTransform(false);
        Integer maxAge = Config.scope((String[])new String[]{"theme"}).getInt("staticMaxAge", Integer.valueOf(2592000));
        if (maxAge != null && maxAge > 0) {
            cacheControl.setMaxAge(maxAge.intValue());
        } else {
            cacheControl.setNoCache(true);
        }
        return cacheControl;
    }

    public static CacheControl noCache() {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setMustRevalidate(true);
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        return cacheControl;
    }
}

