/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import java.util.Comparator;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.AuthorizationService;
import org.keycloak.common.Profile;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.events.EventBuilder;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.clientregistration.ClientRegistrationService;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resources.ClientsManagementService;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.PublicRealmResource;
import org.keycloak.services.resources.account.AccountLoader;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.utils.ProfileHelper;
import org.keycloak.wellknown.WellKnownProvider;
import org.keycloak.wellknown.WellKnownProviderFactory;

@Path(value="/realms")
public class RealmsResource {
    protected static final Logger logger = Logger.getLogger(RealmsResource.class);
    @Context
    protected KeycloakSession session;

    public static UriBuilder realmBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return RealmsResource.realmBaseUrl(baseUriBuilder);
    }

    public static UriBuilder realmBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path(RealmsResource.class, "getRealmResource");
    }

    public static UriBuilder accountUrl(UriBuilder base) {
        return base.path(RealmsResource.class).path(RealmsResource.class, "getAccountService");
    }

    public static UriBuilder protocolUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getProtocol");
    }

    public static UriBuilder protocolUrl(UriBuilder builder) {
        return builder.path(RealmsResource.class).path(RealmsResource.class, "getProtocol");
    }

    public static UriBuilder clientRegistrationUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getClientsService");
    }

    public static UriBuilder brokerUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getBrokerService");
    }

    public static UriBuilder wellKnownProviderUrl(UriBuilder builder) {
        return builder.path(RealmsResource.class).path(RealmsResource.class, "getWellKnown");
    }

    @Path(value="{realm}/protocol/{protocol}")
    public Object getProtocol(@PathParam(value="realm") String name, @PathParam(value="protocol") String protocol) {
        this.resolveRealmAndUpdateSession(name);
        LoginProtocolFactory factory = (LoginProtocolFactory)this.session.getKeycloakSessionFactory().getProviderFactory(LoginProtocol.class, protocol);
        if (factory == null) {
            logger.debugf("protocol %s not found", (Object)protocol);
            throw new NotFoundException("Protocol not found");
        }
        EventBuilder event = new EventBuilder(this.session.getContext().getRealm(), this.session, this.session.getContext().getConnection());
        return factory.createProtocolEndpoint(this.session, event);
    }

    @GET
    @Path(value="{realm}/clients/{client_id}/redirect")
    public Response getRedirect(@PathParam(value="realm") String realmName, @PathParam(value="client_id") String clientId) {
        this.resolveRealmAndUpdateSession(realmName);
        RealmModel realm = this.session.getContext().getRealm();
        ClientModel client = realm.getClientByClientId(clientId);
        if (client == null) {
            return null;
        }
        if (client.getRootUrl() == null && client.getBaseUrl() == null) {
            return null;
        }
        URI targetUri = client.getRootUrl() != null && (client.getBaseUrl() == null || client.getBaseUrl().isEmpty()) ? KeycloakUriBuilder.fromUri((String)client.getRootUrl()).build(new Object[0]) : KeycloakUriBuilder.fromUri((String)ResolveRelative.resolveRelativeUri(this.session, client.getRootUrl(), client.getBaseUrl())).build(new Object[0]);
        return Response.seeOther((URI)targetUri).build();
    }

    @Path(value="{realm}/login-actions")
    public LoginActionsService getLoginActionsService(@PathParam(value="realm") String name) {
        this.resolveRealmAndUpdateSession(name);
        EventBuilder event = new EventBuilder(this.session.getContext().getRealm(), this.session, this.session.getContext().getConnection());
        return new LoginActionsService(this.session, event);
    }

    @Path(value="{realm}/clients-registrations")
    public ClientRegistrationService getClientsService(@PathParam(value="realm") String name) {
        this.resolveRealmAndUpdateSession(name);
        EventBuilder event = new EventBuilder(this.session.getContext().getRealm(), this.session, this.session.getContext().getConnection());
        return new ClientRegistrationService(this.session, event);
    }

    @Path(value="{realm}/clients-managements")
    public ClientsManagementService getClientsManagementService(@PathParam(value="realm") String name) {
        this.resolveRealmAndUpdateSession(name);
        EventBuilder event = new EventBuilder(this.session.getContext().getRealm(), this.session, this.session.getContext().getConnection());
        return new ClientsManagementService(this.session, event);
    }

    private void resolveRealmAndUpdateSession(String realmName) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(realmName);
        if (realm == null) {
            throw new NotFoundException("Realm does not exist");
        }
        this.session.getContext().setRealm(realm);
    }

    @Path(value="{realm}/account")
    public Object getAccountService(@PathParam(value="realm") String name) {
        this.resolveRealmAndUpdateSession(name);
        EventBuilder event = new EventBuilder(this.session.getContext().getRealm(), this.session, this.session.getContext().getConnection());
        return new AccountLoader(this.session, event);
    }

    @Path(value="{realm}")
    public PublicRealmResource getRealmResource(@PathParam(value="realm") String name) {
        this.resolveRealmAndUpdateSession(name);
        return new PublicRealmResource(this.session);
    }

    @Path(value="{realm}/broker")
    public IdentityBrokerService getBrokerService(@PathParam(value="realm") String name) {
        this.resolveRealmAndUpdateSession(name);
        IdentityBrokerService brokerService = new IdentityBrokerService(this.session);
        brokerService.init();
        return brokerService;
    }

    @OPTIONS
    @Path(value="{realm}/.well-known/{provider}")
    @Produces(value={"application/json"})
    public Response getVersionPreflight(@PathParam(value="realm") String name, @PathParam(value="provider") String providerName) {
        return Cors.add(this.session.getContext().getHttpRequest(), Response.ok()).allowedMethods("GET").preflight().auth().build();
    }

    @GET
    @Path(value="{realm}/.well-known/{alias}")
    @Produces(value={"application/json"})
    public Response getWellKnown(@PathParam(value="realm") String name, @PathParam(value="alias") String alias) {
        this.resolveRealmAndUpdateSession(name);
        this.checkSsl(this.session.getContext().getRealm());
        WellKnownProviderFactory wellKnownProviderFactoryFound = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(WellKnownProvider.class).map(providerFactory -> (WellKnownProviderFactory)providerFactory).filter(wellKnownProviderFactory -> alias.equals(wellKnownProviderFactory.getAlias())).sorted(Comparator.comparingInt(WellKnownProviderFactory::getPriority)).findFirst().orElseThrow(NotFoundException::new);
        logger.tracef("Use provider with ID '%s' for well-known alias '%s'", (Object)wellKnownProviderFactoryFound.getId(), (Object)alias);
        WellKnownProvider wellKnown = (WellKnownProvider)this.session.getProvider(WellKnownProvider.class, wellKnownProviderFactoryFound.getId());
        if (wellKnown != null) {
            Response.ResponseBuilder responseBuilder = Response.ok((Object)wellKnown.getConfig()).cacheControl(CacheControlUtil.noCache());
            return Cors.add(this.session.getContext().getHttpRequest(), responseBuilder).allowedOrigins("*").auth().build();
        }
        throw new NotFoundException();
    }

    @Path(value="{realm}/authz")
    public Object getAuthorizationService(@PathParam(value="realm") String name) {
        ProfileHelper.requireFeature(Profile.Feature.AUTHORIZATION);
        this.resolveRealmAndUpdateSession(name);
        AuthorizationProvider authorization = (AuthorizationProvider)this.session.getProvider(AuthorizationProvider.class);
        return new AuthorizationService(authorization);
    }

    @Path(value="{realm}/{extension}")
    public Object resolveRealmExtension(@PathParam(value="realm") String realmName, @PathParam(value="extension") String extension) {
        Object resource;
        this.resolveRealmAndUpdateSession(realmName);
        RealmResourceProvider provider = (RealmResourceProvider)this.session.getProvider(RealmResourceProvider.class, extension);
        if (provider != null && (resource = provider.getResource()) != null) {
            return resource;
        }
        throw new NotFoundException();
    }

    private void checkSsl(RealmModel realm) {
        if (!"https".equals(this.session.getContext().getUri().getBaseUri().getScheme()) && realm.getSslRequired().isRequired(this.session.getContext().getConnection())) {
            HttpRequest request = this.session.getContext().getHttpRequest();
            Cors cors = Cors.add(request).auth().allowedMethods(request.getHttpMethod()).auth().exposedHeaders("Access-Control-Allow-Methods");
            throw new CorsErrorResponseException(cors.allowAllOrigins(), "invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }
}

