/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.url;

import java.net.URI;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.urls.HostnameProvider;
import org.keycloak.urls.UrlType;
import org.keycloak.utils.StringUtil;

public class DefaultHostnameProvider
implements HostnameProvider {
    private static final Logger LOGGER = Logger.getLogger(DefaultHostnameProvider.class);
    private final KeycloakSession session;
    private final URI frontendUri;
    private String currentRealm;
    private URI realmUri;
    private URI adminUri;
    private final boolean forceBackendUrlToFrontendUrl;

    public DefaultHostnameProvider(KeycloakSession session, URI frontendUri, URI adminUri, boolean forceBackendUrlToFrontendUrl) {
        this.session = session;
        this.frontendUri = frontendUri;
        this.adminUri = adminUri;
        this.forceBackendUrlToFrontendUrl = forceBackendUrlToFrontendUrl;
    }

    public String getScheme(UriInfo originalUriInfo, UrlType type) {
        return this.resolveUri(originalUriInfo, type).getScheme();
    }

    public String getHostname(UriInfo originalUriInfo, UrlType type) {
        return this.resolveUri(originalUriInfo, type).getHost();
    }

    public int getPort(UriInfo originalUriInfo, UrlType type) {
        return this.resolveUri(originalUriInfo, type).getPort();
    }

    public String getContextPath(UriInfo originalUriInfo, UrlType type) {
        return this.resolveUri(originalUriInfo, type).getPath();
    }

    private URI resolveUri(UriInfo originalUriInfo, UrlType type) {
        URI frontendUri;
        URI realmUri = this.getRealmUri();
        URI uRI = frontendUri = realmUri != null ? realmUri : this.frontendUri;
        if (type.equals((Object)UrlType.BACKEND) && this.forceBackendUrlToFrontendUrl) {
            type = UrlType.FRONTEND;
        }
        if (type.equals((Object)UrlType.BACKEND) && frontendUri != null && originalUriInfo.getBaseUri().getHost().equals(frontendUri.getHost())) {
            type = UrlType.FRONTEND;
        }
        if (type.equals((Object)UrlType.ADMIN)) {
            if (this.adminUri != null) {
                return this.adminUri;
            }
            type = UrlType.FRONTEND;
        }
        if (type.equals((Object)UrlType.FRONTEND) && frontendUri != null) {
            return frontendUri;
        }
        return originalUriInfo.getBaseUri();
    }

    private URI getRealmUri() {
        RealmModel realm = this.session.getContext().getRealm();
        if (realm == null) {
            this.currentRealm = null;
            this.realmUri = null;
            return null;
        }
        if (realm.getId().equals(this.currentRealm)) {
            return this.realmUri;
        }
        this.currentRealm = realm.getId();
        this.realmUri = null;
        String realmFrontendUrl = this.session.getContext().getRealm().getAttribute("frontendUrl");
        if (StringUtil.isNotBlank((String)realmFrontendUrl)) {
            try {
                UriUtils.checkUrl((SslRequired)SslRequired.NONE, (String)realmFrontendUrl, (String)"frontendUrl");
                this.realmUri = URI.create(realmFrontendUrl);
            }
            catch (IllegalArgumentException e) {
                LOGGER.errorf((Throwable)e, "Failed to parse realm frontendUrl '%s'. Falling back to global value.", (Object)realmFrontendUrl);
            }
        }
        return this.realmUri;
    }
}

