/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.KeycloakSession;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.AttributeValidatorMetadata;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileProvider;

public abstract class AbstractUserProfileBean {
    protected final MultivaluedMap<String, String> formData;
    protected UserProfile profile;
    protected List<Attribute> attributes;
    protected Map<String, Attribute> attributesByName;

    public AbstractUserProfileBean(MultivaluedMap<String, String> formData) {
        this.formData = formData;
    }

    protected void init(KeycloakSession session, boolean writeableOnly) {
        UserProfileProvider provider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
        this.profile = this.createUserProfile(provider);
        this.attributes = this.toAttributes(this.profile.getAttributes().getReadable(), writeableOnly);
        if (this.attributes != null) {
            this.attributesByName = this.attributes.stream().collect(Collectors.toMap(a -> a.getName(), a -> a));
        }
    }

    protected abstract UserProfile createUserProfile(UserProfileProvider var1);

    protected abstract Stream<String> getAttributeDefaultValues(String var1);

    public abstract String getContext();

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public Map<String, Attribute> getAttributesByName() {
        return this.attributesByName;
    }

    private List<Attribute> toAttributes(Map<String, List<String>> attributes, boolean writeableOnly) {
        if (attributes == null) {
            return null;
        }
        return attributes.keySet().stream().map(name -> this.profile.getAttributes().getMetadata(name)).filter(am -> writeableOnly ? !this.profile.getAttributes().isReadOnly(am.getName()) : true).map(x$0 -> new Attribute((AttributeMetadata)x$0)).sorted().collect(Collectors.toList());
    }

    public class Attribute
    implements Comparable<Attribute> {
        private final AttributeMetadata metadata;

        public Attribute(AttributeMetadata metadata) {
            this.metadata = metadata;
        }

        public String getName() {
            return this.metadata.getName();
        }

        public String getDisplayName() {
            return this.metadata.getAttributeDisplayName();
        }

        public String getValue() {
            List<String> v = this.getValues();
            if (v == null || v.isEmpty()) {
                return null;
            }
            return v.get(0);
        }

        public List<String> getValues() {
            List v;
            List list = v = AbstractUserProfileBean.this.formData != null ? (List)AbstractUserProfileBean.this.formData.get((Object)this.getName()) : null;
            if (v == null || v.isEmpty()) {
                Stream<String> vs = AbstractUserProfileBean.this.getAttributeDefaultValues(this.getName());
                if (vs == null) {
                    return Collections.emptyList();
                }
                return vs.collect(Collectors.toList());
            }
            return v;
        }

        public boolean isRequired() {
            return AbstractUserProfileBean.this.profile.getAttributes().isRequired(this.getName());
        }

        public boolean isReadOnly() {
            return AbstractUserProfileBean.this.profile.getAttributes().isReadOnly(this.getName());
        }

        public String getAutocomplete() {
            if (this.getName().equals("email") || this.getName().equals("username")) {
                return this.getName();
            }
            return null;
        }

        public Map<String, Object> getAnnotations() {
            Map annotations = this.metadata.getAnnotations();
            if (annotations == null) {
                return Collections.emptyMap();
            }
            return annotations;
        }

        public Map<String, Map<String, Object>> getValidators() {
            if (this.metadata.getValidators() == null) {
                return Collections.emptyMap();
            }
            return this.metadata.getValidators().stream().collect(Collectors.toMap(AttributeValidatorMetadata::getValidatorId, AttributeValidatorMetadata::getValidatorConfig));
        }

        public String getGroup() {
            if (this.metadata.getAttributeGroupMetadata() != null) {
                return this.metadata.getAttributeGroupMetadata().getName();
            }
            return null;
        }

        public String getGroupDisplayHeader() {
            if (this.metadata.getAttributeGroupMetadata() != null) {
                return this.metadata.getAttributeGroupMetadata().getDisplayHeader();
            }
            return null;
        }

        public String getGroupDisplayDescription() {
            if (this.metadata.getAttributeGroupMetadata() != null) {
                return this.metadata.getAttributeGroupMetadata().getDisplayDescription();
            }
            return null;
        }

        public Map<String, Object> getGroupAnnotations() {
            if (this.metadata.getAttributeGroupMetadata() == null || this.metadata.getAttributeGroupMetadata().getAnnotations() == null) {
                return Collections.emptyMap();
            }
            return this.metadata.getAttributeGroupMetadata().getAnnotations();
        }

        @Override
        public int compareTo(Attribute o) {
            return Integer.compare(this.metadata.getGuiOrder(), o.metadata.getGuiOrder());
        }
    }
}

