/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.SystemClientUtil;
import org.keycloak.sessions.AuthenticationSessionModel;

public class LogoutUtil {
    public static Response sendResponseAfterLogoutFinished(KeycloakSession session, AuthenticationSessionModel logoutSession) {
        String redirectUri = logoutSession.getAuthNote("OIDC_LOGOUT_REDIRECT_URI");
        if (redirectUri != null) {
            URI finalRedirectUri = LogoutUtil.getRedirectUriWithAttachedState(redirectUri, logoutSession);
            return Response.status((int)302).location(finalRedirectUri).build();
        }
        LoginFormsProvider loginForm = ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setSuccess("successLogout", new Object[0]);
        boolean usedSystemClient = logoutSession.getClient().equals(SystemClientUtil.getSystemClient((RealmModel)logoutSession.getRealm()));
        if (usedSystemClient) {
            loginForm.setAttribute("skipLink", (Object)true);
        }
        return loginForm.setDetachedAuthSession().createInfoPage();
    }

    public static URI getRedirectUriWithAttachedState(String redirectUri, AuthenticationSessionModel logoutSession) {
        if (redirectUri == null) {
            return null;
        }
        String state = logoutSession.getAuthNote("OIDC_LOGOUT_STATE_PARAM");
        UriBuilder uriBuilder = UriBuilder.fromUri((String)redirectUri);
        if (state != null) {
            uriBuilder.queryParam("state", new Object[]{state});
        }
        return uriBuilder.build(new Object[0]);
    }
}

