/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Produces;
import java.security.Key;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.util.PemUtils;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

@Extension(name="x-smallrye-profile-admin", value="")
public class KeyResource {
    private RealmModel realm;
    private KeycloakSession session;
    private AdminPermissionEvaluator auth;

    public KeyResource(RealmModel realm, KeycloakSession session, AdminPermissionEvaluator auth) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Key")
    @Operation
    public KeysMetadataRepresentation getKeyMetadata() {
        this.auth.realm().requireViewRealm();
        KeysMetadataRepresentation keys = new KeysMetadataRepresentation();
        keys.setActive(new HashMap());
        List realmKeys = this.session.keys().getKeysStream(this.realm).map(key -> {
            if (key.getStatus().isActive() && !keys.getActive().containsKey(key.getAlgorithmOrDefault())) {
                keys.getActive().put(key.getAlgorithmOrDefault(), key.getKid());
            }
            return this.toKeyMetadataRepresentation((KeyWrapper)key);
        }).collect(Collectors.toList());
        keys.setKeys(realmKeys);
        return keys;
    }

    private KeysMetadataRepresentation.KeyMetadataRepresentation toKeyMetadataRepresentation(KeyWrapper key) {
        KeysMetadataRepresentation.KeyMetadataRepresentation r = new KeysMetadataRepresentation.KeyMetadataRepresentation();
        r.setProviderId(key.getProviderId());
        r.setProviderPriority(key.getProviderPriority());
        r.setKid(key.getKid());
        r.setStatus(key.getStatus() != null ? key.getStatus().name() : null);
        r.setType(key.getType());
        r.setAlgorithm(key.getAlgorithmOrDefault());
        r.setPublicKey(key.getPublicKey() != null ? PemUtils.encodeKey((Key)key.getPublicKey()) : null);
        r.setCertificate(key.getCertificate() != null ? PemUtils.encodeCertificate((Certificate)key.getCertificate()) : null);
        r.setUse(key.getUse());
        return r;
    }
}

