/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.TokenIntrospectionTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AccessToken;
import org.keycloak.utils.RoleResolveUtil;

public class AudienceResolveProtocolMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
TokenIntrospectionTokenMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "oidc-audience-resolve-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Audience Resolve";
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Adds all client_ids of \"allowed\" clients to the audience field of the token. Allowed client means the client\n for which user has at least one client role";
    }

    public int getPriority() {
        return 30;
    }

    @Override
    public AccessToken transformAccessToken(AccessToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        if (!this.includeInAccessToken(mappingModel)) {
            return token;
        }
        this.setAudience(token, clientSessionCtx, session);
        return token;
    }

    private boolean includeInAccessToken(ProtocolMapperModel mappingModel) {
        String includeInAccessToken = (String)mappingModel.getConfig().get("access.token.claim");
        if (includeInAccessToken == null) {
            return true;
        }
        return "true".equals(includeInAccessToken);
    }

    @Override
    public AccessToken transformIntrospectionToken(AccessToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        if (!this.includeInIntrospection(mappingModel)) {
            return token;
        }
        this.setAudience(token, clientSessionCtx, session);
        return token;
    }

    private boolean includeInIntrospection(ProtocolMapperModel mappingModel) {
        String includeInIntrospection = (String)mappingModel.getConfig().get("introspection.token.claim");
        if (includeInIntrospection == null) {
            return true;
        }
        return "true".equals(includeInIntrospection);
    }

    private void setAudience(AccessToken token, ClientSessionContext clientSessionCtx, KeycloakSession session) {
        String clientId = clientSessionCtx.getClientSession().getClient().getClientId();
        for (Map.Entry<String, AccessToken.Access> entry : RoleResolveUtil.getAllResolvedClientRoles(session, clientSessionCtx).entrySet()) {
            AccessToken.Access access;
            if (entry.getKey().equals(clientId) || (access = entry.getValue()) == null || access.getRoles() == null || access.getRoles().isEmpty()) continue;
            token.addAudience(entry.getKey());
        }
    }

    public static ProtocolMapperModel createClaimMapper(String name, boolean accessToken, boolean introspectionEndpoint) {
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(name);
        mapper.setProtocolMapper(PROVIDER_ID);
        mapper.setProtocol("openid-connect");
        HashMap<String, String> config = new HashMap<String, String>();
        if (accessToken) {
            config.put("access.token.claim", "true");
        } else {
            config.put("access.token.claim", "false");
        }
        if (introspectionEndpoint) {
            config.put("introspection.token.claim", "true");
        } else {
            config.put("introspection.token.claim", "false");
        }
        mapper.setConfig(config);
        return mapper;
    }

    static {
        OIDCAttributeMapperHelper.addIncludeInTokensConfig(configProperties, AudienceResolveProtocolMapper.class);
    }
}

