/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.HttpHeaders;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.resteasy.util.CookieParser;
import org.keycloak.common.util.ServerCookie;
import org.keycloak.http.HttpCookie;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.KeycloakSession;

public class CookieHelper {
    public static final String LEGACY_COOKIE = "_LEGACY";
    private static final Logger logger = Logger.getLogger(CookieHelper.class);

    public static void addCookie(String name, String value, String path, String domain, String comment, int maxAge, boolean secure, boolean httpOnly, ServerCookie.SameSiteAttributeValue sameSite, KeycloakSession session) {
        ServerCookie.SameSiteAttributeValue sameSiteParam = sameSite;
        if (maxAge == 0) {
            sameSite = null;
        }
        boolean secure_sameSite = sameSite == ServerCookie.SameSiteAttributeValue.NONE || secure;
        HttpResponse response = session.getContext().getHttpResponse();
        HttpCookie cookie = new HttpCookie(1, name, value, path, domain, comment, maxAge, secure_sameSite, httpOnly, sameSite);
        response.setCookieIfAbsent(cookie);
        if (sameSiteParam == ServerCookie.SameSiteAttributeValue.NONE) {
            CookieHelper.addCookie(name + LEGACY_COOKIE, value, path, domain, comment, maxAge, secure, httpOnly, null, session);
        }
    }

    public static void addCookie(String name, String value, String path, String domain, String comment, int maxAge, boolean secure, boolean httpOnly, KeycloakSession session) {
        CookieHelper.addCookie(name, value, path, domain, comment, maxAge, secure, httpOnly, null, session);
    }

    public static Set<String> getCookieValue(KeycloakSession session, String name) {
        Set<String> ret = CookieHelper.getInternalCookieValue(session, name);
        if (ret.size() == 0) {
            String legacy = name + LEGACY_COOKIE;
            logger.debugv("Could not find any cookies with name '{0}', trying '{1}'", (Object)name, (Object)legacy);
            ret = CookieHelper.getInternalCookieValue(session, legacy);
        }
        return ret;
    }

    private static Set<String> getInternalCookieValue(KeycloakSession session, String name) {
        HttpHeaders headers = session.getContext().getHttpRequest().getHttpHeaders();
        HashSet<String> cookiesVal = new HashSet<String>();
        cookiesVal.addAll(CookieHelper.parseCookie((String)headers.getRequestHeaders().getFirst((Object)"Cookie"), name));
        Cookie cookie = (Cookie)headers.getCookies().get(name);
        if (cookie != null) {
            logger.debugv("{0} cookie found in the cookie field", (Object)name);
            cookiesVal.add(cookie.getValue());
        }
        return cookiesVal;
    }

    public static Set<String> parseCookie(String header, String name) {
        if (header == null || name == null) {
            return Collections.emptySet();
        }
        HashSet<String> values = new HashSet<String>();
        for (Cookie cookie : CookieParser.parseCookies((String)header)) {
            if (!name.equals(cookie.getName())) continue;
            logger.debugv("{0} cookie found in the request header", (Object)name);
            values.add(cookie.getValue());
        }
        return values;
    }

    public static Cookie getCookie(Map<String, Cookie> cookies, String name) {
        Cookie cookie = cookies.get(name);
        if (cookie != null) {
            return cookie;
        }
        String legacy = name + LEGACY_COOKIE;
        logger.debugv("Could not find cookie {0}, trying {1}", (Object)name, (Object)legacy);
        return cookies.get(legacy);
    }
}

