/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.keycloak.models.RealmModel;
import org.keycloak.services.util.LocaleUtil;
import org.keycloak.theme.PropertiesUtil;
import org.keycloak.theme.Theme;

public class FolderTheme
implements Theme {
    private String parentName;
    private String importName;
    private File themeDir;
    private File resourcesDir;
    private String name;
    private Theme.Type type;
    private final Properties properties;
    private static final Pattern LEGAL_LOCALE = Pattern.compile("[a-zA-Z0-9-_]*");

    public FolderTheme(File themeDir, String name, Theme.Type type) throws IOException {
        this.themeDir = themeDir;
        this.name = name;
        this.type = type;
        this.properties = new Properties();
        File propertiesFile = new File(themeDir, "theme.properties");
        if (propertiesFile.isFile()) {
            try (InputStream stream = Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]);){
                PropertiesUtil.readCharsetAware(this.properties, stream);
            }
            this.parentName = this.properties.getProperty("parent");
            this.importName = this.properties.getProperty("import");
        }
        this.resourcesDir = new File(themeDir, "resources");
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getImportName() {
        return this.importName;
    }

    public Theme.Type getType() {
        return this.type;
    }

    public URL getTemplate(String name) throws IOException {
        File file = new File(this.themeDir, name);
        return file.isFile() ? file.toURI().toURL() : null;
    }

    public InputStream getResourceAsStream(String path) throws IOException {
        File file;
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        if (!(file = new File(this.resourcesDir, path)).isFile() || !file.getCanonicalPath().startsWith(this.resourcesDir.getCanonicalPath() + File.separator)) {
            return null;
        }
        return file.toURI().toURL().openStream();
    }

    public Properties getMessages(Locale locale) throws IOException {
        return this.getMessages("messages", locale);
    }

    public Properties getMessages(String baseBundlename, Locale locale) throws IOException {
        if (locale == null) {
            return null;
        }
        Properties m = new Properties();
        String filename = baseBundlename + "_" + locale;
        if (!LEGAL_LOCALE.matcher(filename).matches()) {
            throw new RuntimeException("Found illegal characters in locale or bundle name: " + filename);
        }
        File file = new File(this.themeDir, "messages" + File.separator + filename + ".properties");
        if (file.isFile()) {
            try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                PropertiesUtil.readCharsetAware(m, stream);
            }
        }
        return m;
    }

    public Properties getEnhancedMessages(RealmModel realm, Locale locale) throws IOException {
        if (locale == null) {
            return null;
        }
        Map<Locale, Properties> localeMessages = Collections.singletonMap(locale, this.getMessages(locale));
        return LocaleUtil.enhancePropertiesWithRealmLocalizationTexts(realm, locale, localeMessages);
    }

    public Properties getProperties() {
        return this.properties;
    }
}

