/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc.mappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.broker.oidc.mappers.AbstractClaimToRoleMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.utils.RegexUtils;

public class AdvancedClaimToRoleMapper
extends AbstractClaimToRoleMapper {
    public static final String CLAIM_PROPERTY_NAME = "claims";
    public static final String ARE_CLAIM_VALUES_REGEX_PROPERTY_NAME = "are.claim.values.regex";
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"keycloak-oidc", "oidc"};
    private static final Set<IdentityProviderSyncMode> IDENTITY_PROVIDER_SYNC_MODES = new HashSet<IdentityProviderSyncMode>(Arrays.asList(IdentityProviderSyncMode.values()));
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "oidc-advanced-role-idp-mapper";

    public boolean supportsSyncMode(IdentityProviderSyncMode syncMode) {
        return IDENTITY_PROVIDER_SYNC_MODES.contains(syncMode);
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Role Importer";
    }

    public String getDisplayType() {
        return "Advanced Claim to Role";
    }

    public String getHelpText() {
        return "If all claims exists, grant the user the specified realm or client role.";
    }

    @Override
    protected boolean applies(IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        Map claims = mapperModel.getConfigMap(CLAIM_PROPERTY_NAME);
        boolean areClaimValuesRegex = Boolean.parseBoolean((String)mapperModel.getConfig().get(ARE_CLAIM_VALUES_REGEX_PROPERTY_NAME));
        for (Map.Entry claim : claims.entrySet()) {
            Object claimValue = AdvancedClaimToRoleMapper.getClaimValue(context, (String)claim.getKey());
            for (String value : (List)claim.getValue()) {
                boolean claimValuesMismatch = !(!areClaimValuesRegex ? this.valueEquals(value, claimValue) : RegexUtils.valueMatchesRegex(value, claimValue));
                if (!claimValuesMismatch) continue;
                return false;
            }
        }
        return true;
    }

    static {
        ProviderConfigProperty claimsProperty = new ProviderConfigProperty();
        claimsProperty.setName(CLAIM_PROPERTY_NAME);
        claimsProperty.setLabel("Claims");
        claimsProperty.setHelpText("Name and value of the claims to search for in token. You can reference nested claims using a '.', i.e. 'address.locality'. To use dot (.) literally, escape it with backslash (\\.)");
        claimsProperty.setType("Map");
        configProperties.add(claimsProperty);
        ProviderConfigProperty isClaimValueRegexProperty = new ProviderConfigProperty();
        isClaimValueRegexProperty.setName(ARE_CLAIM_VALUES_REGEX_PROPERTY_NAME);
        isClaimValueRegexProperty.setLabel("Regex Claim Values");
        isClaimValueRegexProperty.setHelpText("If enabled claim values are interpreted as regular expressions.");
        isClaimValueRegexProperty.setType("boolean");
        configProperties.add(isClaimValueRegexProperty);
        ProviderConfigProperty roleProperty = new ProviderConfigProperty();
        roleProperty.setName("role");
        roleProperty.setLabel("Role");
        roleProperty.setHelpText("Role to grant to user if claim is present. Click 'Select Role' button to browse roles, or just type it in the textbox. To reference a client role the syntax is clientname.clientrole, i.e. myclient.myrole");
        roleProperty.setType("Role");
        configProperties.add(roleProperty);
    }
}

