/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys.loader;

import java.security.Key;
import java.security.PublicKey;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.PemUtils;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.PublicKeysWrapper;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.utils.JWKSHttpUtils;
import org.keycloak.util.JWKSUtils;

public class OIDCIdentityProviderPublicKeyLoader
implements PublicKeyLoader {
    private static final Logger logger = Logger.getLogger(OIDCIdentityProviderPublicKeyLoader.class);
    private final KeycloakSession session;
    private final OIDCIdentityProviderConfig config;

    public OIDCIdentityProviderPublicKeyLoader(KeycloakSession session, OIDCIdentityProviderConfig config) {
        this.session = session;
        this.config = config;
    }

    public PublicKeysWrapper loadKeys() throws Exception {
        if (this.config.isUseJwksUrl()) {
            String jwksUrl = this.config.getJwksUrl();
            JSONWebKeySet jwks = JWKSHttpUtils.sendJwksRequest(this.session, jwksUrl);
            return JWKSUtils.getKeyWrappersForUse((JSONWebKeySet)jwks, (JWK.Use)JWK.Use.SIG);
        }
        try {
            KeyWrapper publicKey = this.getSavedPublicKey();
            if (publicKey == null) {
                return PublicKeysWrapper.EMPTY;
            }
            return new PublicKeysWrapper(Collections.singletonList(publicKey));
        }
        catch (Exception e) {
            logger.warnf((Throwable)e, "Unable to retrieve publicKey for verify signature of identityProvider '%s' . Error details: %s", (Object)this.config.getAlias(), (Object)e.getMessage());
            return PublicKeysWrapper.EMPTY;
        }
    }

    protected KeyWrapper getSavedPublicKey() throws Exception {
        KeyWrapper keyWrapper = null;
        if (this.config.getPublicKeySignatureVerifier() != null && !this.config.getPublicKeySignatureVerifier().trim().equals("")) {
            PublicKey publicKey = PemUtils.decodePublicKey((String)this.config.getPublicKeySignatureVerifier());
            keyWrapper = new KeyWrapper();
            String presetKeyId = this.config.getPublicKeySignatureVerifierKeyId();
            String kid = presetKeyId == null || presetKeyId.trim().isEmpty() ? KeyUtils.createKeyId((Key)publicKey) : presetKeyId;
            keyWrapper.setKid(kid);
            keyWrapper.setType("RSA");
            keyWrapper.setAlgorithm("RS256");
            keyWrapper.setUse(KeyUse.SIG);
            keyWrapper.setPublicKey((Key)publicKey);
        } else {
            logger.warnf("No public key saved on identityProvider %s", (Object)this.config.getAlias());
        }
        return keyWrapper;
    }
}

