/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;

public class ClientUpdaterContextCondition
extends AbstractClientPolicyConditionProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(ClientUpdaterContextCondition.class);

    public ClientUpdaterContextCondition(KeycloakSession session) {
        super(session);
    }

    public Class<Configuration> getConditionConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "client-updater-context";
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: 
            case UPDATE: 
            case REGISTERED: 
            case UPDATED: {
                if (this.isAuthMethodMatched((ClientCRUDContext)context)) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private boolean isAuthMethodMatched(String authMethod) {
        if (authMethod == null) {
            return false;
        }
        List<String> expectedAuthMethods = ((Configuration)this.configuration).getUpdateClientSource();
        if (expectedAuthMethods == null) {
            expectedAuthMethods = Collections.emptyList();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("auth method = {0}", (Object)authMethod);
            expectedAuthMethods.stream().forEach(i -> logger.tracev("auth method expected = {0}", i));
        }
        return expectedAuthMethods.stream().anyMatch(i -> i.equals(authMethod));
    }

    private boolean isAuthMethodMatched(ClientCRUDContext context) {
        String authMethod = null;
        if (context.getToken() == null) {
            authMethod = "ByAnonymous";
        } else if (this.isInitialAccessToken(context.getToken())) {
            authMethod = "ByInitialAccessToken";
        } else if (this.isRegistrationAccessToken(context.getToken())) {
            authMethod = "ByRegistrationAccessToken";
        } else if (this.isBearerToken(context.getToken())) {
            authMethod = context.getAuthenticatedUser() != null || context.getAuthenticatedClient() != null ? "ByAuthenticatedUser" : "ByAnonymous";
        }
        return this.isAuthMethodMatched(authMethod);
    }

    private boolean isInitialAccessToken(JsonWebToken jwt) {
        return jwt != null && "InitialAccessToken".equals(jwt.getType());
    }

    private boolean isRegistrationAccessToken(JsonWebToken jwt) {
        return jwt != null && "RegistrationAccessToken".equals(jwt.getType());
    }

    private boolean isBearerToken(JsonWebToken jwt) {
        return jwt != null && "Bearer".equals(jwt.getType());
    }

    public static class Configuration
    extends ClientPolicyConditionConfigurationRepresentation {
        @JsonProperty(value="update-client-source")
        protected List<String> updateClientSource;

        public List<String> getUpdateClientSource() {
            return this.updateClientSource;
        }

        public void setUpdateClientSource(List<String> updateClientSource) {
            this.updateClientSource = updateClientSource;
        }
    }
}

