/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.Token;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionContextResult;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.Encode;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.common.util.Time;
import org.keycloak.cookie.CookieProvider;
import org.keycloak.cookie.CookieType;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.DefaultActionTokenKey;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.DefaultRequiredActions;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.SessionExpirationUtils;
import org.keycloak.models.utils.SystemClientUtil;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.BackchannelLogoutResponse;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.grants.device.DeviceGrantType;
import org.keycloak.rar.AuthorizationDetails;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.LogoutRequestContext;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.IdentityCookieToken;
import org.keycloak.services.managers.UserConsentManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.util.AuthorizationContextUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.TokenUtil;

public class AuthenticationManager {
    public static final String SET_REDIRECT_URI_AFTER_REQUIRED_ACTIONS = "SET_REDIRECT_URI_AFTER_REQUIRED_ACTIONS";
    public static final String END_AFTER_REQUIRED_ACTIONS = "END_AFTER_REQUIRED_ACTIONS";
    public static final String INVALIDATE_ACTION_TOKEN = "INVALIDATE_ACTION_TOKEN";
    public static final String USER_SESSION_PERSISTENT_STATE = "USER_SESSION_PERSISTENT_STATE";
    public static final String CLIENT_LOGOUT_STATE = "logout.state.";
    public static final String AUTH_TIME = "AUTH_TIME";
    public static final String AUTH_TIME_BROKER = "AUTH_TIME_BROKER";
    public static final String SSO_AUTH = "SSO_AUTH";
    public static final String FORCED_REAUTHENTICATION = "FORCED_REAUTHENTICATION";
    public static final String PASSWORD_VALIDATED = "PASSWORD_VALIDATED";
    protected static final Logger logger = Logger.getLogger(AuthenticationManager.class);
    public static final String FORM_USERNAME = "username";
    public static final String KEYCLOAK_SESSION_COOKIE = "KEYCLOAK_SESSION";
    public static final String LOGOUT_WITH_SYSTEM_CLIENT = "LOGOUT_WITH_SYSTEM_CLIENT";
    public static final String KEYCLOAK_LOGOUT_PROTOCOL = "KEYCLOAK_LOGOUT_PROTOCOL";
    public static final String LOGOUT_INITIATING_IDP = "LOGOUT_INITIATING_IDP";
    public static final String INITIATING_IDP_PARAM = "initiating_idp";
    private static final TokenVerifier.TokenTypeCheck VALIDATE_IDENTITY_COOKIE = new TokenVerifier.TokenTypeCheck(List.of("Serialized-ID"));

    public static boolean isSessionValid(RealmModel realm, UserSessionModel userSession) {
        if (userSession == null) {
            logger.debug((Object)"No user session");
            return false;
        }
        long currentTime = Time.currentTimeMillis();
        long lifespan = SessionExpirationUtils.calculateUserSessionMaxLifespanTimestamp((boolean)userSession.isOffline(), (boolean)userSession.isRememberMe(), (long)TimeUnit.SECONDS.toMillis(userSession.getStarted()), (RealmModel)realm);
        long idle = SessionExpirationUtils.calculateUserSessionIdleTimestamp((boolean)userSession.isOffline(), (boolean)userSession.isRememberMe(), (long)TimeUnit.SECONDS.toMillis(userSession.getLastSessionRefresh()), (RealmModel)realm);
        boolean sessionIdleOk = idle > currentTime - (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PERSISTENT_USER_SESSIONS) || Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLUSTERLESS) ? 0L : TimeUnit.SECONDS.toMillis(120L));
        boolean sessionMaxOk = lifespan == -1L || lifespan > currentTime;
        return sessionIdleOk && sessionMaxOk;
    }

    public static boolean isClientSessionValid(RealmModel realm, ClientModel client, UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        if (userSession == null || clientSession == null) {
            logger.debug((Object)"No user session");
            return false;
        }
        long currentTime = Time.currentTimeMillis();
        long lifespan = SessionExpirationUtils.calculateClientSessionMaxLifespanTimestamp((boolean)userSession.isOffline(), (boolean)userSession.isRememberMe(), (long)TimeUnit.SECONDS.toMillis(clientSession.getStarted()), (long)TimeUnit.SECONDS.toMillis(userSession.getStarted()), (RealmModel)realm, (ClientModel)client);
        long idle = SessionExpirationUtils.calculateClientSessionIdleTimestamp((boolean)userSession.isOffline(), (boolean)userSession.isRememberMe(), (long)TimeUnit.SECONDS.toMillis(clientSession.getTimestamp()), (RealmModel)realm, (ClientModel)client);
        boolean sessionIdleOk = idle > currentTime - (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PERSISTENT_USER_SESSIONS) || Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLUSTERLESS) ? 0L : TimeUnit.SECONDS.toMillis(120L));
        boolean sessionMaxOk = lifespan == -1L || lifespan > currentTime;
        return sessionIdleOk && sessionMaxOk;
    }

    public static boolean expireUserSessionCookie(KeycloakSession session, UserSessionModel userSession, RealmModel realm, UriInfo uriInfo, HttpHeaders headers, ClientConnection connection) {
        try {
            String tokenString = ((CookieProvider)session.getProvider(CookieProvider.class)).get(CookieType.IDENTITY);
            if (tokenString == null) {
                return true;
            }
            TokenVerifier verifier = TokenVerifier.create((String)tokenString, AccessToken.class).realmUrl(Urls.realmIssuer(uriInfo.getBaseUri(), realm.getName())).checkActive(false).checkTokenType(false).withChecks(new TokenVerifier.Predicate[]{VALIDATE_IDENTITY_COOKIE});
            String kid = verifier.getHeader().getKeyId();
            String algorithm = verifier.getHeader().getAlgorithm().name();
            SignatureVerifierContext signatureVerifier = ((SignatureProvider)session.getProvider(SignatureProvider.class, algorithm)).verifier(kid);
            verifier.verifierContext(signatureVerifier);
            AccessToken token = (AccessToken)verifier.verify().getToken();
            UserSessionModel cookieSession = session.sessions().getUserSession(realm, token.getSessionState());
            if (cookieSession == null || !cookieSession.getId().equals(userSession.getId())) {
                return true;
            }
            AuthenticationManager.expireIdentityCookie(session);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void backchannelLogout(KeycloakSession session, UserSessionModel userSession, boolean logoutBroker) {
        AuthenticationManager.backchannelLogout(session, session.getContext().getRealm(), userSession, (UriInfo)session.getContext().getUri(), session.getContext().getConnection(), session.getContext().getRequestHeaders(), logoutBroker);
    }

    public static BackchannelLogoutResponse backchannelLogout(KeycloakSession session, RealmModel realm, UserSessionModel userSession, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers, boolean logoutBroker) {
        return AuthenticationManager.backchannelLogout(session, realm, userSession, uriInfo, connection, headers, logoutBroker, userSession == null ? false : userSession.isOffline());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackchannelLogoutResponse backchannelLogout(KeycloakSession session, RealmModel realm, UserSessionModel userSession, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers, boolean logoutBroker, boolean offlineSession) {
        BackchannelLogoutResponse backchannelLogoutResponse = new BackchannelLogoutResponse();
        if (userSession == null) {
            backchannelLogoutResponse.setLocalLogoutSucceeded(true);
            return backchannelLogoutResponse;
        }
        if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
            userSession.setState(UserSessionModel.State.LOGGING_OUT);
        }
        if (logger.isDebugEnabled()) {
            UserModel user = userSession.getUser();
            String username = user == null ? null : user.getUsername();
            logger.debugv("Logging out: {0} ({1}) offline: {2}", (Object)username, (Object)userSession.getId(), (Object)userSession.isOffline());
        }
        boolean expireUserSessionCookieSucceeded = AuthenticationManager.expireUserSessionCookie(session, userSession, realm, uriInfo, headers, connection);
        AuthenticationSessionManager asm = new AuthenticationSessionManager(session);
        AuthenticationSessionModel logoutAuthSession = AuthenticationManager.createOrJoinLogoutSession(session, realm, asm, userSession, false);
        boolean userSessionOnlyHasLoggedOutClients = false;
        try {
            backchannelLogoutResponse = AuthenticationManager.backchannelLogoutAll(session, realm, userSession, logoutAuthSession, uriInfo, headers, logoutBroker);
            userSessionOnlyHasLoggedOutClients = AuthenticationManager.checkUserSessionOnlyHasLoggedOutClients(realm, userSession, logoutAuthSession);
        }
        finally {
            logger.tracef("Removing logout session '%s' after backchannel logout", (Object)logoutAuthSession.getParentSession().getId());
            session.authenticationSessions().removeRootAuthenticationSession(realm, logoutAuthSession.getParentSession());
        }
        userSession.setState(UserSessionModel.State.LOGGED_OUT);
        if (offlineSession) {
            UserSessionModel onlineUserSession;
            new UserSessionManager(session).revokeOfflineUserSession(userSession);
            String onlineUserSessionId = userSession.getNote("correspondingSessionId");
            UserSessionModel userSessionModel = onlineUserSession = onlineUserSessionId != null ? session.sessions().getUserSession(realm, onlineUserSessionId) : session.sessions().getUserSession(realm, userSession.getId());
            if (onlineUserSession != null) {
                session.sessions().removeUserSession(realm, onlineUserSession);
            }
        } else {
            session.sessions().removeUserSession(realm, userSession);
        }
        backchannelLogoutResponse.setLocalLogoutSucceeded(expireUserSessionCookieSucceeded && userSessionOnlyHasLoggedOutClients);
        return backchannelLogoutResponse;
    }

    public static AuthenticationSessionModel createOrJoinLogoutSession(KeycloakSession session, RealmModel realm, AuthenticationSessionManager asm, UserSessionModel userSession, boolean browserCookie) {
        AuthenticationSessionModel logoutAuthSession;
        Optional<AuthenticationSessionModel> found;
        String authSessionId;
        AuthenticationSessionModel logoutSession = session.getContext().getAuthenticationSession();
        if (logoutSession != null && CommonClientSessionModel.Action.LOGGING_OUT.name().equals(logoutSession.getAction())) {
            return logoutSession;
        }
        ClientModel client = session.getContext().getClient();
        if (client == null) {
            client = SystemClientUtil.getSystemClient((RealmModel)realm);
        }
        RootAuthenticationSessionModel rootLogoutSession = null;
        boolean browserCookiePresent = false;
        if (browserCookie) {
            rootLogoutSession = asm.getCurrentRootAuthenticationSession(realm);
        }
        if (rootLogoutSession != null) {
            authSessionId = rootLogoutSession.getId();
            browserCookiePresent = true;
        } else if (userSession != null) {
            authSessionId = userSession.getId();
            rootLogoutSession = session.authenticationSessions().getRootAuthenticationSession(realm, authSessionId);
        } else {
            authSessionId = KeycloakModelUtils.generateId();
        }
        if (rootLogoutSession == null) {
            rootLogoutSession = session.authenticationSessions().createRootAuthenticationSession(realm, authSessionId);
        }
        if (browserCookie && !browserCookiePresent) {
            asm.setAuthSessionCookie(authSessionId);
        }
        if ((found = rootLogoutSession.getAuthenticationSessions().values().stream().filter(authSession -> CommonClientSessionModel.Action.LOGGING_OUT.name().equals(authSession.getAction())).findFirst()).isPresent()) {
            logoutAuthSession = found.get();
            logger.tracef("Found existing logout session for client '%s'. Authentication session id: %s", (Object)client.getClientId(), (Object)rootLogoutSession.getId());
        } else {
            logoutAuthSession = rootLogoutSession.createAuthenticationSession(client);
            logoutAuthSession.setAction(CommonClientSessionModel.Action.LOGGING_OUT.name());
            logger.tracef("Creating logout session for client '%s'. Authentication session id: %s", (Object)client.getClientId(), (Object)rootLogoutSession.getId());
        }
        session.getContext().setAuthenticationSession(logoutAuthSession);
        session.getContext().setClient(client);
        return logoutAuthSession;
    }

    private static BackchannelLogoutResponse backchannelLogoutAll(KeycloakSession session, RealmModel realm, UserSessionModel userSession, AuthenticationSessionModel logoutAuthSession, UriInfo uriInfo, HttpHeaders headers, boolean logoutBroker) {
        String brokerId;
        BackchannelLogoutResponse backchannelLogoutResponse = new BackchannelLogoutResponse();
        for (AuthenticatedClientSessionModel clientSession : userSession.getAuthenticatedClientSessions().values()) {
            Response clientSessionLogoutResponse = AuthenticationManager.backchannelLogoutClientSession(session, realm, clientSession, logoutAuthSession, uriInfo, headers);
            String backchannelLogoutUrl = OIDCAdvancedConfigWrapper.fromClientModel(clientSession.getClient()).getBackchannelLogoutUrl();
            BackchannelLogoutResponse.DownStreamBackchannelLogoutResponse downStreamBackchannelLogoutResponse = new BackchannelLogoutResponse.DownStreamBackchannelLogoutResponse();
            downStreamBackchannelLogoutResponse.setWithBackchannelLogoutUrl(backchannelLogoutUrl != null);
            if (clientSessionLogoutResponse != null) {
                downStreamBackchannelLogoutResponse.setResponseCode(clientSessionLogoutResponse.getStatus());
            } else {
                downStreamBackchannelLogoutResponse.setResponseCode(null);
            }
            backchannelLogoutResponse.addClientResponses(downStreamBackchannelLogoutResponse);
        }
        if (logoutBroker && (brokerId = userSession.getNote("identity_provider")) != null) {
            IdentityProvider<?> identityProvider = IdentityBrokerService.getIdentityProvider(session, brokerId);
            try {
                identityProvider.backchannelLogout(session, userSession, uriInfo, realm);
            }
            catch (Exception e) {
                logger.warn((Object)("Exception at broker backchannel logout for broker " + brokerId), (Throwable)e);
                backchannelLogoutResponse.setLocalLogoutSucceeded(false);
            }
        }
        return backchannelLogoutResponse;
    }

    private static boolean checkUserSessionOnlyHasLoggedOutClients(RealmModel realm, UserSessionModel userSession, AuthenticationSessionModel logoutAuthSession) {
        Map acs = userSession.getAuthenticatedClientSessions();
        Set notLoggedOutSessions = acs.entrySet().stream().filter(me -> !Objects.equals(CommonClientSessionModel.Action.LOGGED_OUT, AuthenticationManager.getClientLogoutAction(logoutAuthSession, (String)me.getKey()))).filter(me -> !Objects.equals(CommonClientSessionModel.Action.LOGGED_OUT.name(), ((AuthenticatedClientSessionModel)me.getValue()).getAction())).filter(me -> !Objects.equals(CommonClientSessionModel.Action.LOGGING_OUT.name(), ((AuthenticatedClientSessionModel)me.getValue()).getAction())).filter(me -> Objects.nonNull(((AuthenticatedClientSessionModel)me.getValue()).getProtocol())).map(Map.Entry::getValue).collect(Collectors.toSet());
        boolean allClientsLoggedOut = notLoggedOutSessions.isEmpty();
        if (!allClientsLoggedOut) {
            logger.warnf("Some clients have not been logged out for user %s in %s realm: %s", (Object)userSession.getUser().getUsername(), (Object)realm.getName(), (Object)notLoggedOutSessions.stream().map(CommonClientSessionModel::getClient).map(ClientModel::getClientId).sorted().collect(Collectors.joining(", ")));
        } else if (logger.isDebugEnabled()) {
            logger.debugf("All clients have been logged out for user %s in %s realm, session %s", (Object)userSession.getUser().getUsername(), (Object)realm.getName(), (Object)userSession.getId());
        }
        return allClientsLoggedOut;
    }

    private static Response backchannelLogoutClientSession(KeycloakSession session, RealmModel realm, AuthenticatedClientSessionModel clientSession, AuthenticationSessionModel logoutAuthSession, UriInfo uriInfo, HttpHeaders headers) {
        UserSessionModel userSession = clientSession.getUserSession();
        ClientModel client = clientSession.getClient();
        if (client.isFrontchannelLogout() || CommonClientSessionModel.Action.LOGGED_OUT.name().equals(clientSession.getAction())) {
            return null;
        }
        CommonClientSessionModel.Action logoutState = AuthenticationManager.getClientLogoutAction(logoutAuthSession, client.getId());
        if (logoutState == CommonClientSessionModel.Action.LOGGED_OUT || logoutState == CommonClientSessionModel.Action.LOGGING_OUT) {
            return Response.ok().build();
        }
        if (!client.isEnabled()) {
            return null;
        }
        try {
            AuthenticationManager.setClientLogoutAction(logoutAuthSession, client.getId(), CommonClientSessionModel.Action.LOGGING_OUT);
            String authMethod = clientSession.getProtocol();
            if (authMethod == null) {
                return Response.ok().build();
            }
            logger.debugv("backchannel logout to: {0}", (Object)client.getClientId());
            LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, authMethod);
            protocol.setRealm(realm).setHttpHeaders(headers).setUriInfo(uriInfo);
            Response clientSessionLogout = protocol.backchannelLogout(userSession, clientSession);
            AuthenticationManager.setClientLogoutAction(logoutAuthSession, client.getId(), CommonClientSessionModel.Action.LOGGED_OUT);
            return clientSessionLogout;
        }
        catch (Exception ex) {
            ServicesLogger.LOGGER.failedToLogoutClient(ex);
            return Response.serverError().build();
        }
    }

    private static Response frontchannelLogoutClientSession(KeycloakSession session, RealmModel realm, AuthenticatedClientSessionModel clientSession, AuthenticationSessionModel logoutAuthSession, UriInfo uriInfo, HttpHeaders headers) {
        UserSessionModel userSession = clientSession.getUserSession();
        ClientModel client = clientSession.getClient();
        if (!client.isFrontchannelLogout() || CommonClientSessionModel.Action.LOGGED_OUT.name().equals(clientSession.getAction())) {
            return null;
        }
        CommonClientSessionModel.Action logoutState = AuthenticationManager.getClientLogoutAction(logoutAuthSession, client.getId());
        if (logoutState == CommonClientSessionModel.Action.LOGGED_OUT || logoutState == CommonClientSessionModel.Action.LOGGING_OUT) {
            return null;
        }
        try {
            session.clientPolicy().triggerOnEvent((ClientPolicyContext)new LogoutRequestContext());
        }
        catch (ClientPolicyException cpe) {
            throw new ErrorResponseException(cpe.getError(), cpe.getErrorDetail(), cpe.getErrorStatus());
        }
        try {
            AuthenticationManager.setClientLogoutAction(logoutAuthSession, client.getId(), CommonClientSessionModel.Action.LOGGING_OUT);
            String authMethod = clientSession.getProtocol();
            if (authMethod == null) {
                return null;
            }
            logger.debugv("frontchannel logout to: {0}", (Object)client.getClientId());
            LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, authMethod);
            protocol.setRealm(realm).setHttpHeaders(headers).setUriInfo(uriInfo);
            Response response = protocol.frontchannelLogout(userSession, clientSession);
            if (response != null) {
                logger.debug((Object)"returning frontchannel logout request to client");
                if (!CommonClientSessionModel.Action.LOGGING_OUT.name().equals(clientSession.getAction())) {
                    AuthenticationManager.setClientLogoutAction(logoutAuthSession, client.getId(), CommonClientSessionModel.Action.LOGGED_OUT);
                }
                return response;
            }
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.failedToLogoutClient(e);
        }
        return null;
    }

    public static void setClientLogoutAction(AuthenticationSessionModel logoutAuthSession, String clientUuid, CommonClientSessionModel.Action action) {
        if (logoutAuthSession != null && clientUuid != null) {
            logoutAuthSession.setAuthNote(CLIENT_LOGOUT_STATE + clientUuid, action.name());
        }
    }

    public static CommonClientSessionModel.Action getClientLogoutAction(AuthenticationSessionModel logoutAuthSession, String clientUuid) {
        if (logoutAuthSession == null || clientUuid == null) {
            return null;
        }
        String state = logoutAuthSession.getAuthNote(CLIENT_LOGOUT_STATE + clientUuid);
        return state == null ? null : CommonClientSessionModel.Action.valueOf((String)state);
    }

    public static void backchannelLogoutUserFromClient(KeycloakSession session, RealmModel realm, UserModel user, ClientModel client, UriInfo uriInfo, HttpHeaders headers) {
        session.sessions().getUserSessionsStream(realm, user).map(userSession -> userSession.getAuthenticatedClientSessionByClient(client.getId())).filter(Objects::nonNull).collect(Collectors.toList()).forEach(clientSession -> {
            AuthenticationManager.backchannelLogoutClientSession(session, realm, clientSession, null, uriInfo, headers);
            clientSession.setAction(CommonClientSessionModel.Action.LOGGED_OUT.name());
            TokenManager.dettachClientSession(clientSession);
        });
    }

    public static Response browserLogout(KeycloakSession session, RealmModel realm, UserSessionModel userSession, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers) {
        IdentityProvider<?> identityProvider;
        Response response;
        if (userSession == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            UserModel user = userSession.getUser();
            logger.debugv("Logging out: {0} ({1})", (Object)user.getUsername(), (Object)userSession.getId());
        }
        if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
            userSession.setState(UserSessionModel.State.LOGGING_OUT);
        }
        AuthenticationSessionManager asm = new AuthenticationSessionManager(session);
        AuthenticationSessionModel logoutAuthSession = AuthenticationManager.createOrJoinLogoutSession(session, realm, asm, userSession, true);
        String brokerId = userSession.getNote("identity_provider");
        String initiatingIdp = logoutAuthSession.getAuthNote(LOGOUT_INITIATING_IDP);
        if (brokerId != null && !brokerId.equals(initiatingIdp) && (response = (identityProvider = IdentityBrokerService.getIdentityProvider(session, brokerId)).keycloakInitiatedBrowserLogout(session, userSession, uriInfo, realm)) != null) {
            return response;
        }
        return AuthenticationManager.finishBrowserLogout(session, realm, userSession, uriInfo, connection, headers);
    }

    private static Response browserLogoutAllClients(UserSessionModel userSession, KeycloakSession session, RealmModel realm, HttpHeaders headers, UriInfo uriInfo, AuthenticationSessionModel logoutAuthSession) {
        Map<Boolean, List<AuthenticatedClientSessionModel>> acss = userSession.getAuthenticatedClientSessions().values().stream().filter(clientSession -> !Objects.equals(CommonClientSessionModel.Action.LOGGED_OUT.name(), clientSession.getAction()) && !Objects.equals(CommonClientSessionModel.Action.LOGGING_OUT.name(), clientSession.getAction())).filter(clientSession -> clientSession.getProtocol() != null).collect(Collectors.partitioningBy(clientSession -> clientSession.getClient().isFrontchannelLogout()));
        List<AuthenticatedClientSessionModel> backendLogoutSessions = acss.get(false) == null ? Collections.emptyList() : acss.get(false);
        backendLogoutSessions.forEach(acs -> AuthenticationManager.backchannelLogoutClientSession(session, realm, acs, logoutAuthSession, uriInfo, headers));
        List<AuthenticatedClientSessionModel> redirectClients = acss.get(true) == null ? Collections.emptyList() : acss.get(true);
        for (AuthenticatedClientSessionModel nextRedirectClient : redirectClients) {
            Response response = AuthenticationManager.frontchannelLogoutClientSession(session, realm, nextRedirectClient, logoutAuthSession, uriInfo, headers);
            if (response == null) continue;
            return response;
        }
        return null;
    }

    public static Response finishBrowserLogout(KeycloakSession session, RealmModel realm, UserSessionModel userSession, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers) {
        AuthenticationSessionManager asm = new AuthenticationSessionManager(session);
        AuthenticationSessionModel logoutAuthSession = AuthenticationManager.createOrJoinLogoutSession(session, realm, asm, userSession, true);
        Response response = AuthenticationManager.browserLogoutAllClients(userSession, session, realm, headers, uriInfo, logoutAuthSession);
        if (response != null) {
            return response;
        }
        AuthenticationManager.checkUserSessionOnlyHasLoggedOutClients(realm, userSession, logoutAuthSession);
        AuthenticationManager.expireIdentityCookie(session);
        AuthenticationManager.expireRememberMeCookie(session);
        String method = userSession.getNote(KEYCLOAK_LOGOUT_PROTOCOL);
        EventBuilder event = new EventBuilder(realm, session, connection);
        LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, method);
        protocol.setRealm(realm).setHttpHeaders(headers).setUriInfo(uriInfo).setEventBuilder(event);
        response = protocol.finishBrowserLogout(userSession, logoutAuthSession);
        long numberOfUnconfirmedSessions = userSession.getAuthenticatedClientSessions().values().stream().filter(clientSessionModel -> CommonClientSessionModel.Action.LOGGING_OUT.name().equals(clientSessionModel.getAction())).count();
        if (numberOfUnconfirmedSessions > 1L) {
            logger.warnf("There are more than one clientSession in logging_out state. Perhaps some client did not finish logout flow correctly.", new Object[0]);
        }
        if (numberOfUnconfirmedSessions >= 1L) {
            userSession.setState(UserSessionModel.State.LOGGED_OUT_UNCONFIRMED);
        } else {
            userSession.setState(UserSessionModel.State.LOGGED_OUT);
        }
        if (numberOfUnconfirmedSessions < 1L) {
            session.sessions().removeUserSession(realm, userSession);
        }
        logger.tracef("Removing logout session '%s'.", (Object)logoutAuthSession.getParentSession().getId());
        session.authenticationSessions().removeRootAuthenticationSession(realm, logoutAuthSession.getParentSession());
        return response;
    }

    public static void finishUnconfirmedUserSession(KeycloakSession session, RealmModel realm, UserSessionModel userSessionModel) {
        if (userSessionModel.getAuthenticatedClientSessions().values().stream().anyMatch(cs -> !CommonClientSessionModel.Action.LOGGED_OUT.name().equals(cs.getAction()))) {
            logger.warnf("UserSession with id %s is removed while there are still some user sessions that are not logged out properly.", (Object)userSessionModel.getId());
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Client sessions with their states:");
                userSessionModel.getAuthenticatedClientSessions().values().forEach(clientSessionModel -> logger.tracef("Client session for clientId: %s has action: %s", (Object)clientSessionModel.getClient().getClientId(), (Object)clientSessionModel.getAction()));
            }
        }
        session.sessions().removeUserSession(realm, userSessionModel);
    }

    public static IdentityCookieToken createIdentityToken(KeycloakSession keycloakSession, RealmModel realm, UserModel user, UserSessionModel session, String issuer) {
        IdentityCookieToken token = new IdentityCookieToken();
        token.id(KeycloakModelUtils.generateId());
        token.issuedNow();
        token.subject(user.getId());
        token.issuer(issuer);
        token.type("Serialized-ID");
        if (session != null) {
            token.setSessionId(session.getId());
        }
        if (session != null && session.isRememberMe() && realm.getSsoSessionMaxLifespanRememberMe() > 0) {
            token.exp((long)Time.currentTime() + (long)realm.getSsoSessionMaxLifespanRememberMe());
        } else if (realm.getSsoSessionMaxLifespan() > 0) {
            token.exp((long)Time.currentTime() + (long)realm.getSsoSessionMaxLifespan());
        }
        String stateChecker = (String)keycloakSession.getAttribute("state_checker");
        if (stateChecker == null) {
            stateChecker = Base64Url.encode((byte[])SecretGenerator.getInstance().randomBytes());
            keycloakSession.setAttribute("state_checker", (Object)stateChecker);
        }
        token.getOtherClaims().put("state_checker", stateChecker);
        return token;
    }

    public static void createLoginCookie(KeycloakSession keycloakSession, RealmModel realm, UserModel user, UserSessionModel session, UriInfo uriInfo, ClientConnection connection) {
        String issuer = Urls.realmIssuer(uriInfo.getBaseUri(), realm.getName());
        IdentityCookieToken identityCookieToken = AuthenticationManager.createIdentityToken(keycloakSession, realm, user, session, issuer);
        String encoded = keycloakSession.tokens().encode((Token)identityCookieToken);
        int maxAge = -1;
        if (session != null && session.isRememberMe()) {
            maxAge = realm.getSsoSessionMaxLifespanRememberMe() > 0 ? realm.getSsoSessionMaxLifespanRememberMe() : realm.getSsoSessionMaxLifespan();
        }
        ((CookieProvider)keycloakSession.getProvider(CookieProvider.class)).set(CookieType.IDENTITY, encoded, maxAge);
        String sessionCookieValue = realm.getName() + "/" + Encode.urlEncode((String)user.getId());
        if (session != null) {
            sessionCookieValue = sessionCookieValue + "/" + session.getId();
        }
        int sessionCookieMaxAge = session.isRememberMe() && realm.getSsoSessionMaxLifespanRememberMe() > 0 ? realm.getSsoSessionMaxLifespanRememberMe() : realm.getSsoSessionMaxLifespan();
        ((CookieProvider)keycloakSession.getProvider(CookieProvider.class)).set(CookieType.SESSION, sessionCookieValue, sessionCookieMaxAge);
    }

    public static void createRememberMeCookie(String username, UriInfo uriInfo, KeycloakSession session) {
        KeycloakContext context = session.getContext();
        RealmModel realm = context.getRealm();
        ClientConnection connection = context.getConnection();
        String path = AuthenticationManager.getRealmCookiePath(realm, uriInfo);
        boolean secureOnly = realm.getSslRequired().isRequired(connection);
        try {
            ((CookieProvider)session.getProvider(CookieProvider.class)).set(CookieType.LOGIN_HINT, "username:" + URLEncoder.encode(username, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to urlencode", e);
        }
    }

    public static String getRememberMeUsername(KeycloakSession session) {
        String[] s;
        String value;
        if (session.getContext().getRealm().isRememberMe() && (value = ((CookieProvider)session.getProvider(CookieProvider.class)).get(CookieType.LOGIN_HINT)) != null && (s = value.split(":"))[0].equals(FORM_USERNAME) && s.length == 2) {
            try {
                return URLDecoder.decode(s[1], "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Failed to urldecode", e);
            }
        }
        return null;
    }

    public static void expireIdentityCookie(KeycloakSession session) {
        ((CookieProvider)session.getProvider(CookieProvider.class)).expire(CookieType.IDENTITY);
        ((CookieProvider)session.getProvider(CookieProvider.class)).expire(CookieType.SESSION);
    }

    public static void expireRememberMeCookie(KeycloakSession session) {
        ((CookieProvider)session.getProvider(CookieProvider.class)).expire(CookieType.LOGIN_HINT);
    }

    public static void expireAuthSessionCookie(KeycloakSession session) {
        ((CookieProvider)session.getProvider(CookieProvider.class)).expire(CookieType.AUTH_SESSION_ID);
    }

    public static String getRealmCookiePath(RealmModel realm, UriInfo uriInfo) {
        URI uri = RealmsResource.realmBaseUrl(uriInfo).build(new Object[]{realm.getName()});
        return uri.getRawPath() + "/";
    }

    public AuthResult authenticateIdentityCookie(KeycloakSession session, RealmModel realm) {
        return AuthenticationManager.authenticateIdentityCookie(session, realm, true);
    }

    public static AuthResult authenticateIdentityCookie(KeycloakSession session, RealmModel realm, boolean checkActive) {
        String tokenString = ((CookieProvider)session.getProvider(CookieProvider.class)).get(CookieType.IDENTITY);
        if (tokenString == null || tokenString.isEmpty()) {
            logger.debugv("Could not find cookie: {0}", (Object)CookieType.IDENTITY.getName());
            return null;
        }
        AuthResult authResult = AuthenticationManager.verifyIdentityToken(session, realm, (UriInfo)session.getContext().getUri(), session.getContext().getConnection(), checkActive, false, null, true, tokenString, session.getContext().getRequestHeaders(), new TokenVerifier.Predicate[]{VALIDATE_IDENTITY_COOKIE});
        if (authResult == null) {
            AuthenticationManager.expireIdentityCookie(session);
            return null;
        }
        authResult.getSession().setLastSessionRefresh(Time.currentTime());
        return authResult;
    }

    public static Response redirectAfterSuccessfulFlow(KeycloakSession session, RealmModel realm, UserSessionModel userSession, ClientSessionContext clientSessionCtx, HttpRequest request, UriInfo uriInfo, ClientConnection clientConnection, EventBuilder event, AuthenticationSessionModel authSession) {
        LoginProtocol protocolImpl = (LoginProtocol)session.getProvider(LoginProtocol.class, authSession.getProtocol());
        protocolImpl.setRealm(realm).setHttpHeaders(request.getHttpHeaders()).setUriInfo(uriInfo).setEventBuilder(event);
        return AuthenticationManager.redirectAfterSuccessfulFlow(session, realm, userSession, clientSessionCtx, request, uriInfo, clientConnection, event, authSession, protocolImpl);
    }

    public static Response redirectAfterSuccessfulFlow(KeycloakSession session, RealmModel realm, UserSessionModel userSession, ClientSessionContext clientSessionCtx, HttpRequest request, UriInfo uriInfo, ClientConnection clientConnection, EventBuilder event, AuthenticationSessionModel authSession, LoginProtocol protocol) {
        UserSessionModel oldSession;
        String oldSessionId;
        String[] split;
        String sessionCookie = ((CookieProvider)session.getProvider(CookieProvider.class)).get(CookieType.SESSION);
        if (sessionCookie != null && (split = sessionCookie.split("/")).length >= 3 && !(oldSessionId = split[2]).equals(userSession.getId()) && (oldSession = session.sessions().getUserSession(realm, oldSessionId)) != null) {
            logger.debugv("Removing old user session: session: {0}", (Object)oldSessionId);
            session.sessions().removeUserSession(realm, oldSession);
        }
        session.getContext().resolveLocale(userSession.getUser());
        AuthenticationManager.createLoginCookie(session, realm, userSession.getUser(), userSession, uriInfo, clientConnection);
        if (userSession.getState() != UserSessionModel.State.LOGGED_IN) {
            userSession.setState(UserSessionModel.State.LOGGED_IN);
        }
        if (userSession.isRememberMe()) {
            AuthenticationManager.createRememberMeCookie(userSession.getLoginUsername(), uriInfo, session);
        } else {
            AuthenticationManager.expireRememberMeCookie(session);
        }
        AuthenticatedClientSessionModel clientSession = clientSessionCtx.getClientSession();
        boolean isSSOAuthentication = AuthenticatorUtil.isSSOAuthentication(authSession);
        if (isSSOAuthentication) {
            clientSession.setNote(SSO_AUTH, "true");
            authSession.removeAuthNote(SSO_AUTH);
        } else {
            int authTime = Optional.ofNullable(authSession.getClientNote(AUTH_TIME_BROKER)).map(Integer::parseInt).orElse(Time.currentTime());
            userSession.setNote(AUTH_TIME, String.valueOf(authTime));
            clientSession.removeNote(SSO_AUTH);
        }
        AuthenticationManager.logSuccess(session, authSession);
        return protocol.authenticated(authSession, userSession, clientSessionCtx);
    }

    public static String getSessionIdFromSessionCookie(KeycloakSession session) {
        String cookie = ((CookieProvider)session.getProvider(CookieProvider.class)).get(CookieType.SESSION);
        if (cookie == null || cookie.isEmpty()) {
            logger.debugv("Could not find cookie: {0}", (Object)KEYCLOAK_SESSION_COOKIE);
            return null;
        }
        String[] parts = cookie.split("/", 3);
        if (parts.length != 3) {
            logger.debugv("Cannot parse session value from: {0}", (Object)KEYCLOAK_SESSION_COOKIE);
            return null;
        }
        return parts[2];
    }

    public static boolean isSSOAuthentication(AuthenticatedClientSessionModel clientSession) {
        String ssoAuth = clientSession.getNote(SSO_AUTH);
        return Boolean.parseBoolean(ssoAuth);
    }

    public static Response nextActionAfterAuthentication(KeycloakSession session, AuthenticationSessionModel authSession, ClientConnection clientConnection, HttpRequest request, UriInfo uriInfo, EventBuilder event) {
        return AuthenticationManager.nextActionAfterAuthentication(session, authSession, clientConnection, request, uriInfo, event, new HashSet<String>());
    }

    private static Response nextActionAfterAuthentication(KeycloakSession session, AuthenticationSessionModel authSession, ClientConnection clientConnection, HttpRequest request, UriInfo uriInfo, EventBuilder event, Set<String> ignoredActions) {
        Response requiredAction = AuthenticationManager.actionRequired(session, authSession, request, event, ignoredActions);
        if (requiredAction != null) {
            return requiredAction;
        }
        return AuthenticationManager.finishedRequiredActions(session, authSession, null, clientConnection, request, uriInfo, event);
    }

    public static Response redirectToRequiredActions(KeycloakSession session, RealmModel realm, AuthenticationSessionModel authSession, UriInfo uriInfo, String requiredAction) {
        ClientSessionCode<AuthenticationSessionModel> accessCode = new ClientSessionCode<AuthenticationSessionModel>(session, realm, authSession);
        accessCode.setAction(CommonClientSessionModel.Action.REQUIRED_ACTIONS.name());
        authSession.setAuthNote("current.flow.path", "required-action");
        authSession.setAuthNote("current.authentication.execution", requiredAction);
        UriBuilder uriBuilder = LoginActionsService.loginActionsBaseUrl(uriInfo).path("required-action");
        if (requiredAction != null) {
            uriBuilder.queryParam("execution", new Object[]{requiredAction});
        }
        uriBuilder.queryParam("client_id", new Object[]{authSession.getClient().getClientId()});
        uriBuilder.queryParam("tab_id", new Object[]{authSession.getTabId()});
        uriBuilder.queryParam("client_data", new Object[]{AuthenticationProcessor.getClientData(session, authSession)});
        if (uriInfo.getQueryParameters().containsKey((Object)"auth_session_id")) {
            uriBuilder.queryParam("auth_session_id", new Object[]{authSession.getParentSession().getId()});
        }
        URI redirect = uriBuilder.build(new Object[]{realm.getName()});
        return Response.status((int)302).location(redirect).build();
    }

    public static Response finishedRequiredActions(KeycloakSession session, AuthenticationSessionModel authSession, UserSessionModel userSession, ClientConnection clientConnection, HttpRequest request, UriInfo uriInfo, EventBuilder event) {
        DefaultActionTokenKey actionTokenKey;
        String actionTokenKeyToInvalidate = authSession.getAuthNote(INVALIDATE_ACTION_TOKEN);
        if (actionTokenKeyToInvalidate != null && (actionTokenKey = DefaultActionTokenKey.from((String)actionTokenKeyToInvalidate)) != null) {
            SingleUseObjectProvider singleUseObjectProvider = session.singleUseObjects();
            singleUseObjectProvider.put(actionTokenKeyToInvalidate, actionTokenKey.getExp() - (long)Time.currentTime(), null);
        }
        if (authSession.getAuthNote(END_AFTER_REQUIRED_ACTIONS) != null) {
            LoginFormsProvider infoPage = ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setSuccess("accountUpdatedMessage", new Object[0]);
            if (authSession.getAuthNote(SET_REDIRECT_URI_AFTER_REQUIRED_ACTIONS) != null) {
                if (authSession.getRedirectUri() != null) {
                    infoPage.setAttribute("pageRedirectUri", (Object)authSession.getRedirectUri());
                }
            } else {
                SystemClientUtil.checkSkipLink((KeycloakSession)session, (AuthenticationSessionModel)authSession);
            }
            Response response = infoPage.setDetachedAuthSession().createInfoPage();
            new AuthenticationSessionManager(session).removeAuthenticationSession(authSession.getRealm(), authSession, true);
            return response;
        }
        RealmModel realm = authSession.getRealm();
        ClientSessionContext clientSessionCtx = AuthenticationProcessor.attachSession(authSession, userSession, session, realm, clientConnection, event);
        userSession = clientSessionCtx.getClientSession().getUserSession();
        event.event(EventType.LOGIN);
        event.session(userSession);
        event.success();
        return AuthenticationManager.redirectAfterSuccessfulFlow(session, realm, userSession, clientSessionCtx, request, uriInfo, clientConnection, event, authSession);
    }

    public static String nextRequiredAction(KeycloakSession session, AuthenticationSessionModel authSession, HttpRequest request, EventBuilder event) {
        RealmModel realm = authSession.getRealm();
        UserModel user = authSession.getAuthenticatedUser();
        AuthenticationManager.evaluateRequiredActionTriggers(session, authSession, request, event, realm, user, new HashSet<String>());
        String kcAction = authSession.getClientNote("kc_action");
        RequiredActionProviderModel nextApplicableAction = AuthenticationManager.getFirstApplicableRequiredAction(realm, authSession, user, kcAction);
        if (nextApplicableAction != null) {
            return nextApplicableAction.getAlias();
        }
        ClientModel client = authSession.getClient();
        if (client.isConsentRequired() || DeviceGrantType.isOAuth2DeviceVerificationFlow(authSession)) {
            UserConsentModel grantedConsent = AuthenticationManager.getEffectiveGrantedConsent(session, authSession);
            List<AuthorizationDetails> clientScopesToApprove = AuthenticationManager.getClientScopesToApproveOnConsentScreen(grantedConsent, session, authSession);
            if (!clientScopesToApprove.isEmpty()) {
                return CommonClientSessionModel.Action.OAUTH_GRANT.name();
            }
            String consentDetail = grantedConsent != null ? "persistent_consent" : "no_consent_required";
            event.detail("consent", consentDetail);
        } else {
            event.detail("consent", "no_consent_required");
        }
        return null;
    }

    private static UserConsentModel getEffectiveGrantedConsent(KeycloakSession session, AuthenticationSessionModel authSession) {
        if (DeviceGrantType.isOAuth2DeviceVerificationFlow(authSession)) {
            return null;
        }
        String prompt = authSession.getClientNote("prompt");
        if (TokenUtil.hasPrompt((String)prompt, (String)"consent")) {
            return null;
        }
        RealmModel realm = authSession.getRealm();
        UserModel user = authSession.getAuthenticatedUser();
        ClientModel client = authSession.getClient();
        return UserConsentManager.getConsentByClient(session, realm, user, client.getId());
    }

    public static Response actionRequired(KeycloakSession session, AuthenticationSessionModel authSession, HttpRequest request, EventBuilder event) {
        return AuthenticationManager.actionRequired(session, authSession, request, event, new HashSet<String>());
    }

    private static Response actionRequired(KeycloakSession session, AuthenticationSessionModel authSession, HttpRequest request, EventBuilder event, Set<String> ignoredActions) {
        RealmModel realm = authSession.getRealm();
        UserModel user = authSession.getAuthenticatedUser();
        AuthenticationManager.evaluateRequiredActionTriggers(session, authSession, request, event, realm, user, ignoredActions);
        event.detail("code_id", authSession.getParentSession().getId());
        Response actionResponse = AuthenticationManager.executionActions(session, authSession, request, event, realm, user, ignoredActions);
        if (actionResponse != null) {
            return actionResponse;
        }
        ClientModel client = authSession.getClient();
        logger.debugv("processAccessCode: go to oauth page?: {0}", (Object)client.isConsentRequired());
        if (client.isConsentRequired() || DeviceGrantType.isOAuth2DeviceVerificationFlow(authSession)) {
            UserConsentModel grantedConsent = AuthenticationManager.getEffectiveGrantedConsent(session, authSession);
            List<AuthorizationDetails> clientScopesToApprove = AuthenticationManager.getClientScopesToApproveOnConsentScreen(grantedConsent, session, authSession);
            if (clientScopesToApprove.size() > 0) {
                String execution = CommonClientSessionModel.Action.OAUTH_GRANT.name();
                ClientSessionCode<AuthenticationSessionModel> accessCode = new ClientSessionCode<AuthenticationSessionModel>(session, realm, authSession);
                accessCode.setAction(CommonClientSessionModel.Action.REQUIRED_ACTIONS.name());
                authSession.setAuthNote("current.authentication.execution", execution);
                return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setExecution(execution).setClientSessionCode(accessCode.getOrGenerateCode()).setAccessRequest(clientScopesToApprove).createOAuthGrant();
            }
            String consentDetail = grantedConsent != null ? "persistent_consent" : "no_consent_required";
            event.detail("consent", consentDetail);
        } else {
            event.detail("consent", "no_consent_required");
        }
        return null;
    }

    private static List<AuthorizationDetails> getClientScopesToApproveOnConsentScreen(UserConsentModel grantedConsent, KeycloakSession session, AuthenticationSessionModel authSession) {
        LinkedList<AuthorizationDetails> clientScopesToDisplay = new LinkedList<AuthorizationDetails>();
        for (AuthorizationDetails authDetails : AuthenticationManager.getClientScopeModelStream(session).collect(Collectors.toList())) {
            ClientScopeModel clientScope = authDetails.getClientScope();
            if (clientScope == null || !clientScope.isDisplayOnConsentScreen() || grantedConsent != null && grantedConsent.isClientScopeGranted(clientScope) && !AuthenticationManager.isDynamicScopeWithParam(authDetails)) continue;
            clientScopesToDisplay.add(authDetails);
        }
        if (clientScopesToDisplay.isEmpty() && DeviceGrantType.isOAuth2DeviceVerificationFlow(authSession)) {
            clientScopesToDisplay.add(new AuthorizationDetails((ClientScopeModel)authSession.getClient()));
        }
        return clientScopesToDisplay;
    }

    private static boolean isDynamicScopeWithParam(AuthorizationDetails authorizationDetails) {
        boolean dynamicScopeWithParam;
        boolean bl = dynamicScopeWithParam = authorizationDetails.getClientScope().isDynamicScope() && authorizationDetails.getAuthorizationDetails() != null;
        if (dynamicScopeWithParam) {
            logger.debugf("Scope %1s is a dynamic scope with param: %2s", (Object)authorizationDetails.getAuthorizationDetails().getScopeNameFromCustomData(), (Object)authorizationDetails.getDynamicScopeParam());
        }
        return dynamicScopeWithParam;
    }

    private static Stream<AuthorizationDetails> getClientScopeModelStream(KeycloakSession session) {
        AuthenticationSessionModel authSession = session.getContext().getAuthenticationSession();
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES)) {
            return AuthorizationContextUtil.getAuthorizationRequestsStreamFromScopesWithClient(session, authSession.getClientNote("scope"));
        }
        return authSession.getClientScopes().stream().map(scopeId -> KeycloakModelUtils.findClientScopeById((RealmModel)authSession.getRealm(), (ClientModel)authSession.getClient(), (String)scopeId)).map(AuthorizationDetails::new);
    }

    public static void setClientScopesInSession(KeycloakSession session, AuthenticationSessionModel authSession) {
        ClientModel client = authSession.getClient();
        UserModel user = authSession.getAuthenticatedUser();
        String scopeParam = authSession.getClientNote("scope");
        Set requestedClientScopes = TokenManager.getRequestedClientScopes(session, scopeParam, client, user).map(ClientScopeModel::getId).collect(Collectors.toSet());
        authSession.setClientScopes(requestedClientScopes);
    }

    public static RequiredActionProvider createRequiredAction(RequiredActionContextResult context) {
        return (RequiredActionProvider)context.getFactory().create(context.getSession());
    }

    protected static Response executionActions(KeycloakSession session, AuthenticationSessionModel authSession, HttpRequest request, EventBuilder event, RealmModel realm, UserModel user, Set<String> ignoredActions) {
        String kcAction = authSession.getClientNote("kc_action");
        RequiredActionProviderModel firstApplicableRequiredAction = AuthenticationManager.getFirstApplicableRequiredAction(realm, authSession, user, kcAction);
        if (firstApplicableRequiredAction != null) {
            return AuthenticationManager.executeAction(session, authSession, firstApplicableRequiredAction, request, event, realm, user, kcAction != null, ignoredActions);
        }
        return null;
    }

    private static Response executeAction(KeycloakSession session, AuthenticationSessionModel authSession, RequiredActionProviderModel model, HttpRequest request, EventBuilder event, RealmModel realm, UserModel user, boolean kcActionExecution, Set<String> ignoredActions) {
        RequiredActionFactory factory = (RequiredActionFactory)session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, model.getProviderId());
        if (factory == null) {
            throw new RuntimeException("Unable to find factory for Required Action: " + model.getProviderId() + " did you forget to declare it in a META-INF/services file?");
        }
        RequiredActionContextResult context = new RequiredActionContextResult(authSession, realm, event, session, request, user, factory);
        RequiredActionProvider actionProvider = null;
        try {
            actionProvider = AuthenticationManager.createRequiredAction(context);
        }
        catch (AuthenticationFlowException e) {
            if (e.getResponse() != null) {
                return e.getResponse();
            }
            throw e;
        }
        if (kcActionExecution) {
            if (actionProvider.initiatedActionSupport() == InitiatedActionSupport.NOT_SUPPORTED) {
                logger.debugv("Requested action {0} does not support being invoked with kc_action", (Object)factory.getId());
                AuthenticationManager.setKcActionStatus(factory.getId(), RequiredActionContext.KcActionStatus.ERROR, authSession);
                return null;
            }
            if (!model.isEnabled()) {
                logger.debugv("Requested action {0} is disabled and can't be invoked with kc_action", (Object)factory.getId());
                AuthenticationManager.setKcActionStatus(factory.getId(), RequiredActionContext.KcActionStatus.ERROR, authSession);
                return null;
            }
            authSession.setClientNote("kc_action_executing", factory.getId());
        }
        actionProvider.requiredActionChallenge((RequiredActionContext)context);
        if (context.getStatus() == RequiredActionContext.Status.FAILURE) {
            LoginProtocol protocol = (LoginProtocol)context.getSession().getProvider(LoginProtocol.class, context.getAuthenticationSession().getProtocol());
            protocol.setRealm(context.getRealm()).setHttpHeaders(context.getHttpRequest().getHttpHeaders()).setUriInfo(context.getUriInfo()).setEventBuilder(event);
            Response response = protocol.sendError(context.getAuthenticationSession(), LoginProtocol.Error.CONSENT_DENIED);
            event.error("rejected_by_user");
            return response;
        }
        if (context.getStatus() == RequiredActionContext.Status.CHALLENGE) {
            authSession.setAuthNote("current.authentication.execution", model.getProviderId());
            return context.getChallenge();
        }
        if (context.getStatus() == RequiredActionContext.Status.IGNORE) {
            authSession.getAuthenticatedUser().removeRequiredAction(factory.getId());
            authSession.removeRequiredAction(factory.getId());
            AuthenticationManager.setKcActionStatus(factory.getId(), RequiredActionContext.KcActionStatus.SUCCESS, authSession);
            ignoredActions.add(factory.getId());
            return AuthenticationManager.nextActionAfterAuthentication(session, authSession, session.getContext().getConnection(), request, (UriInfo)session.getContext().getUri(), event, ignoredActions);
        }
        if (context.getStatus() == RequiredActionContext.Status.SUCCESS) {
            event.clone().event(EventType.CUSTOM_REQUIRED_ACTION).detail("custom_required_action", factory.getId()).success();
            authSession.getAuthenticatedUser().removeRequiredAction(factory.getId());
            authSession.removeRequiredAction(factory.getId());
            AuthenticationManager.setKcActionStatus(factory.getId(), RequiredActionContext.KcActionStatus.SUCCESS, authSession);
            return AuthenticationManager.nextActionAfterAuthentication(session, authSession, session.getContext().getConnection(), request, (UriInfo)session.getContext().getUri(), event, ignoredActions);
        }
        return null;
    }

    private static RequiredActionProviderModel getFirstApplicableRequiredAction(RealmModel realm, AuthenticationSessionModel authSession, UserModel user, String kcAction) {
        RequiredActionProviderModel firstApplicableRequiredAction;
        List<RequiredActionProviderModel> applicableRequiredActionsSorted = AuthenticationManager.getApplicableRequiredActionsSorted(realm, authSession, user, kcAction);
        if (applicableRequiredActionsSorted.isEmpty()) {
            firstApplicableRequiredAction = null;
            logger.debugv("Did not find applicable required action", new Object[0]);
        } else {
            firstApplicableRequiredAction = applicableRequiredActionsSorted.iterator().next();
            logger.debugv("first applicable required action: {0}", (Object)firstApplicableRequiredAction.getAlias());
        }
        return firstApplicableRequiredAction;
    }

    private static List<RequiredActionProviderModel> getApplicableRequiredActionsSorted(RealmModel realm, AuthenticationSessionModel authSession, UserModel user, String kcActionAlias) {
        Map applicableActions;
        HashSet nonInitiatedActionAliases = new HashSet();
        nonInitiatedActionAliases.addAll(user.getRequiredActionsStream().toList());
        nonInitiatedActionAliases.addAll(authSession.getRequiredActions());
        Map applicableNonInitiatedActions = nonInitiatedActionAliases.stream().map(alias -> AuthenticationManager.getApplicableRequiredAction(realm, alias)).filter(Objects::nonNull).collect(Collectors.toMap(RequiredActionProviderModel::getAlias, Function.identity()));
        RequiredActionProviderModel kcAction = null;
        if (kcActionAlias != null) {
            kcAction = AuthenticationManager.getApplicableRequiredAction(realm, kcActionAlias);
            if (kcAction == null) {
                logger.debugv("Requested action {0} not configured for realm", (Object)kcActionAlias);
                AuthenticationManager.setKcActionStatus(kcActionAlias, RequiredActionContext.KcActionStatus.ERROR, authSession);
            } else if (applicableNonInitiatedActions.containsKey(kcActionAlias)) {
                AuthenticationManager.setKcActionToEnforced(kcActionAlias, authSession);
            }
        }
        if (kcAction != null) {
            applicableActions = new HashMap(applicableNonInitiatedActions);
            applicableActions.put(kcAction.getAlias(), kcAction);
        } else {
            applicableActions = applicableNonInitiatedActions;
        }
        List<RequiredActionProviderModel> applicableActionsSorted = applicableActions.values().stream().sorted(RequiredActionProviderModel.RequiredActionComparator.SINGLETON).toList();
        if (logger.isDebugEnabled()) {
            logger.debugv("applicable required actions (sorted): {0}", applicableActionsSorted.stream().map(RequiredActionProviderModel::getAlias).toList());
        }
        return applicableActionsSorted;
    }

    private static RequiredActionProviderModel getApplicableRequiredAction(RealmModel realm, String alias) {
        RequiredActionProviderModel model = realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            logger.warnv("Could not find configuration for Required Action {0}, did you forget to register it?", (Object)alias);
            return null;
        }
        if (!model.isEnabled()) {
            return null;
        }
        return model;
    }

    public static void evaluateRequiredActionTriggers(KeycloakSession session, AuthenticationSessionModel authSession, HttpRequest request, EventBuilder event, RealmModel realm, UserModel user) {
        AuthenticationManager.evaluateRequiredActionTriggers(session, authSession, request, event, realm, user, new HashSet<String>());
    }

    private static void evaluateRequiredActionTriggers(KeycloakSession session, AuthenticationSessionModel authSession, HttpRequest request, EventBuilder event, RealmModel realm, UserModel user, Set<String> ignoredActions) {
        realm.getRequiredActionProvidersStream().filter(RequiredActionProviderModel::isEnabled).filter(model -> !ignoredActions.contains(model.getProviderId())).map(model -> AuthenticationManager.toRequiredActionFactory(session, model, realm)).filter(Objects::nonNull).forEachOrdered(f -> AuthenticationManager.evaluateRequiredAction(session, authSession, request, event, realm, user, f));
    }

    private static void evaluateRequiredAction(KeycloakSession session, AuthenticationSessionModel authSession, HttpRequest request, EventBuilder event, RealmModel realm, UserModel user, RequiredActionFactory factory) {
        RequiredActionProvider provider = (RequiredActionProvider)factory.create(session);
        RequiredActionContextResult result = new RequiredActionContextResult(authSession, realm, event, session, request, user, factory){

            @Override
            public void challenge(Response response) {
                throw new RuntimeException("Not allowed to call challenge() within evaluateTriggers()");
            }

            @Override
            public void failure() {
                throw new RuntimeException("Not allowed to call failure() within evaluateTriggers()");
            }

            @Override
            public void success() {
                throw new RuntimeException("Not allowed to call success() within evaluateTriggers()");
            }

            @Override
            public void ignore() {
                throw new RuntimeException("Not allowed to call ignore() within evaluateTriggers()");
            }
        };
        provider.evaluateTriggers((RequiredActionContext)result);
    }

    private static RequiredActionFactory toRequiredActionFactory(KeycloakSession session, RequiredActionProviderModel model, RealmModel realm) {
        RequiredActionFactory factory = (RequiredActionFactory)session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, model.getProviderId());
        if (factory == null) {
            if (!DefaultRequiredActions.isActionAvailable((RequiredActionProviderModel)model)) {
                logger.warnf("Required action provider factory '%s' configured in the realm '%s' is not available. Provider not found or feature is disabled.", (Object)model.getProviderId(), (Object)realm.getName());
            } else {
                throw new RuntimeException(String.format("Unable to find factory for Required Action '%s' configured in the realm '%s'. Did you forget to declare it in a META-INF/services file?", model.getProviderId(), realm.getName()));
            }
        }
        return factory;
    }

    public static AuthResult verifyIdentityToken(KeycloakSession session, RealmModel realm, UriInfo uriInfo, ClientConnection connection, boolean checkActive, boolean checkTokenType, String checkAudience, boolean isCookie, String tokenString, HttpHeaders headers, TokenVerifier.Predicate<? super AccessToken> ... additionalChecks) {
        try {
            ClientModel client;
            TokenVerifier verifier = TokenVerifier.create((String)tokenString, AccessToken.class).withDefaultChecks().realmUrl(Urls.realmIssuer(uriInfo.getBaseUri(), realm.getName())).checkActive(checkActive).checkTokenType(checkTokenType).withChecks(additionalChecks);
            if (checkAudience != null) {
                verifier.audience(new String[]{checkAudience});
            }
            if (checkTokenType) {
                verifier.withChecks(new TokenVerifier.Predicate[]{new TokenManager.TokenRevocationCheck(session)});
            }
            String kid = verifier.getHeader().getKeyId();
            String algorithm = verifier.getHeader().getAlgorithm().name();
            SignatureVerifierContext signatureVerifier = ((SignatureProvider)session.getProvider(SignatureProvider.class, algorithm)).verifier(kid);
            verifier.verifierContext(signatureVerifier);
            AccessToken token = (AccessToken)verifier.verify().getToken();
            if (checkActive && (!token.isActive() || token.getIat() < (long)realm.getNotBefore())) {
                logger.debugf("Identity cookie expired. Token expiration: %d, Current Time: %d. token issued at: %d, realm not before: %d", new Object[]{token.getExp(), Time.currentTime(), token.getIat(), realm.getNotBefore()});
                return null;
            }
            UserSessionModel userSession = null;
            UserModel user = null;
            if (token.getSessionState() == null ? !TokenManager.isUserValid(session, realm, token, user = TokenManager.lookupUserFromStatelessToken(session, realm, token)) : (userSession = session.sessions().getUserSession(realm, token.getSessionState())) != null && !TokenManager.isUserValid(session, realm, token, user = userSession.getUser())) {
                return null;
            }
            if (token.getSessionState() != null && !AuthenticationManager.isSessionValid(realm, userSession)) {
                UserSessionModel offlineUserSession;
                if (!isCookie && AuthenticationManager.isSessionValid(realm, offlineUserSession = session.sessions().getOfflineUserSession(realm, token.getSessionState()))) {
                    user = offlineUserSession.getUser();
                    ClientModel client2 = realm.getClientByClientId(token.getIssuedFor());
                    if (!AuthenticationManager.isClientValid(offlineUserSession, client2, token)) {
                        return null;
                    }
                    return new AuthResult(user, offlineUserSession, token, client2);
                }
                if (userSession != null) {
                    AuthenticationManager.backchannelLogout(session, realm, userSession, uriInfo, connection, headers, true);
                }
                logger.debug((Object)"User session not active");
                return null;
            }
            session.setAttribute("state_checker", token.getOtherClaims().get("state_checker"));
            if (isCookie) {
                client = null;
            } else {
                client = realm.getClientByClientId(token.getIssuedFor());
                if (!AuthenticationManager.isClientValid(userSession, client, token)) {
                    return null;
                }
            }
            return new AuthResult(user, userSession, token, client);
        }
        catch (VerificationException e) {
            logger.debugf("Failed to verify identity token: %s", (Object)e.getMessage());
            return null;
        }
    }

    private static boolean isClientValid(UserSessionModel userSession, ClientModel client, AccessToken token) {
        if (client == null || !client.isEnabled()) {
            logger.debugf("Identity token issued for unknown or disabled client '%s'", (Object)token.getIssuedFor());
            return false;
        }
        if (token.getIat() < (long)client.getNotBefore()) {
            logger.debug((Object)"Client notBefore newer than token");
            return false;
        }
        if (userSession == null) {
            return true;
        }
        AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(client.getId());
        if (clientSession == null) {
            logger.debugf("Client session for client '%s' not present in user session '%s'", (Object)client.getClientId(), (Object)userSession.getId());
            return false;
        }
        return true;
    }

    public static void setKcActionStatus(String executedProviderId, RequiredActionContext.KcActionStatus status, AuthenticationSessionModel authSession) {
        if (executedProviderId.equals(authSession.getClientNote("kc_action"))) {
            authSession.setClientNote("kc_action_status", status.name().toLowerCase());
            authSession.removeClientNote("kc_action");
            authSession.removeClientNote("kc_action_executing");
        }
    }

    public static void setKcActionToEnforced(String executedProviderId, AuthenticationSessionModel authSession) {
        if (executedProviderId.equals(authSession.getClientNote("kc_action"))) {
            authSession.setClientNote("kc_action_enforced", Boolean.TRUE.toString());
        }
    }

    public static void logSuccess(KeycloakSession session, AuthenticationSessionModel authSession) {
        UserModel user;
        RealmModel realm = session.getContext().getRealm();
        if (realm.isBruteForceProtected() && (user = AuthenticationManager.lookupUserForBruteForceLog(session, realm, authSession)) != null) {
            BruteForceProtector bruteForceProtector = (BruteForceProtector)session.getProvider(BruteForceProtector.class);
            bruteForceProtector.successfulLogin(realm, user, session.getContext().getConnection(), session.getContext().getHttpRequest().getUri());
        }
    }

    public static UserModel lookupUserForBruteForceLog(KeycloakSession session, RealmModel realm, AuthenticationSessionModel authenticationSession) {
        UserModel user = authenticationSession.getAuthenticatedUser();
        if (user != null) {
            return user;
        }
        String username = authenticationSession.getAuthNote("ATTEMPTED_USERNAME");
        if (username != null) {
            return KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)session, (RealmModel)realm, (String)username);
        }
        return null;
    }

    public static class AuthResult {
        private final UserModel user;
        private final UserSessionModel session;
        private final AccessToken token;
        private final ClientModel client;

        public AuthResult(UserModel user, UserSessionModel session, AccessToken token, ClientModel client) {
            this.user = user;
            this.session = session;
            this.token = token;
            this.client = client;
        }

        public UserSessionModel getSession() {
            return this.session;
        }

        public UserModel getUser() {
            return this.user;
        }

        public AccessToken getToken() {
            return this.token;
        }

        public ClientModel getClient() {
            return this.client;
        }
    }

    public static enum AuthenticationStatus {
        SUCCESS,
        ACCOUNT_TEMPORARILY_DISABLED,
        ACCOUNT_DISABLED,
        ACTIONS_REQUIRED,
        INVALID_USER,
        INVALID_CREDENTIALS,
        MISSING_PASSWORD,
        MISSING_TOTP,
        FAILED;

    }
}

