/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.connections.httpclient.SafeBasicResponseHandler;

public class SafeBasicResponseHandlerTest {
    @Test
    public void shouldThrowExceptionForLongResponses() throws UnsupportedEncodingException {
        final AtomicBoolean inputStreamHasBeenClosed = new AtomicBoolean(false);
        StringEntity entity = new StringEntity("1234567890"){

            public InputStream getContent() throws IOException {
                final InputStream delegate = super.getContent();
                return new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return delegate.read();
                    }

                    @Override
                    public void close() throws IOException {
                        super.close();
                        inputStreamHasBeenClosed.set(true);
                    }
                };
            }
        };
        IOException exception = (IOException)Assert.assertThrows(IOException.class, () -> SafeBasicResponseHandlerTest.lambda$shouldThrowExceptionForLongResponses$0((HttpEntity)entity));
        MatcherAssert.assertThat((String)"Too long response should throw an exception", (Object)exception.getMessage(), (Matcher)Matchers.startsWith((String)"Response is at least"));
        MatcherAssert.assertThat((String)"Stream should have been closed", (Object)inputStreamHasBeenClosed.get(), (Matcher)Matchers.is((Object)true));
    }

    private static /* synthetic */ void lambda$shouldThrowExceptionForLongResponses$0(HttpEntity entity) throws Throwable {
        new SafeBasicResponseHandler(5L).handleEntity(entity);
    }
}

