/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwk;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.jose.jwk.OKPPublicJWK;
import org.keycloak.rule.CryptoInitRule;
import org.keycloak.util.JsonSerialization;

public class ServerJWKTest {
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();

    @Test
    public void publicEd25519() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("Ed25519");
        KeyPair keyPair = keyGen.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        JWK jwk = JWKBuilder.create().kid(KeyUtils.createKeyId((Key)keyPair.getPublic())).algorithm("EdDSA").okp((Key)publicKey);
        Assert.assertEquals((Object)"OKP", (Object)jwk.getKeyType());
        Assert.assertEquals((Object)"EdDSA", (Object)jwk.getAlgorithm());
        Assert.assertEquals((Object)"sig", (Object)jwk.getPublicKeyUse());
        Assert.assertTrue((boolean)(jwk instanceof OKPPublicJWK));
        OKPPublicJWK okpJwk = (OKPPublicJWK)jwk;
        Assert.assertEquals((Object)"Ed25519", (Object)okpJwk.getCrv());
        Assert.assertNotNull((Object)okpJwk.getX());
        String jwkJson = JsonSerialization.writeValueAsString((Object)jwk);
        JWKParser parser = JWKParser.create().parse(jwkJson);
        PublicKey publicKeyFromJwk = parser.toPublicKey();
        Assert.assertArrayEquals((byte[])publicKey.getEncoded(), (byte[])publicKeyFromJwk.getEncoded());
        byte[] data = "Some test string".getBytes(StandardCharsets.UTF_8);
        byte[] sign = this.sign(data, "Ed25519", keyPair.getPrivate());
        this.verify(data, sign, "Ed25519", publicKeyFromJwk);
    }

    @Test
    public void publicEd448() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("Ed448");
        KeyPair keyPair = keyGen.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        JWK jwk = JWKBuilder.create().kid(KeyUtils.createKeyId((Key)keyPair.getPublic())).algorithm("EdDSA").okp((Key)publicKey);
        Assert.assertEquals((Object)"OKP", (Object)jwk.getKeyType());
        Assert.assertEquals((Object)"EdDSA", (Object)jwk.getAlgorithm());
        Assert.assertEquals((Object)"sig", (Object)jwk.getPublicKeyUse());
        Assert.assertTrue((boolean)(jwk instanceof OKPPublicJWK));
        OKPPublicJWK okpJwk = (OKPPublicJWK)jwk;
        Assert.assertEquals((Object)"Ed448", (Object)okpJwk.getCrv());
        Assert.assertNotNull((Object)okpJwk.getX());
        String jwkJson = JsonSerialization.writeValueAsString((Object)jwk);
        JWKParser parser = JWKParser.create().parse(jwkJson);
        PublicKey publicKeyFromJwk = parser.toPublicKey();
        Assert.assertArrayEquals((byte[])publicKey.getEncoded(), (byte[])publicKeyFromJwk.getEncoded());
        byte[] data = "Some test string".getBytes(StandardCharsets.UTF_8);
        byte[] sign = this.sign(data, "Ed448", keyPair.getPrivate());
        this.verify(data, sign, "Ed448", publicKeyFromJwk);
    }

    private byte[] sign(byte[] data, String javaAlgorithm, PrivateKey key) throws Exception {
        Signature signature = Signature.getInstance(javaAlgorithm);
        signature.initSign(key);
        signature.update(data);
        return signature.sign();
    }

    private boolean verify(byte[] data, byte[] signature, String javaAlgorithm, PublicKey key) throws Exception {
        Signature verifier = Signature.getInstance(javaAlgorithm);
        verifier.initVerify(key);
        verifier.update(data);
        return verifier.verify(signature);
    }
}

