/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.procotol.docker.installation;

import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.PemUtils;
import org.keycloak.protocol.docker.installation.DockerComposeYamlInstallationProvider;
import org.keycloak.rule.CryptoInitRule;

public class DockerComposeYamlInstallationProviderTest {
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();
    DockerComposeYamlInstallationProvider installationProvider;
    static Certificate certificate;

    @Before
    public void setUp() throws Exception {
        KeyPairGenerator keyGen = CryptoIntegration.getProvider().getKeyPairGen("RSA");
        keyGen.initialize(2048, new SecureRandom());
        KeyPair keypair = keyGen.generateKeyPair();
        certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keypair, (String)"test-realm");
        this.installationProvider = new DockerComposeYamlInstallationProvider();
    }

    private Response fireInstallationProvider() throws IOException {
        ByteArrayOutputStream byteStream = null;
        ZipOutputStream zipOutput = null;
        byteStream = new ByteArrayOutputStream();
        zipOutput = new ZipOutputStream(byteStream);
        return this.installationProvider.generateInstallation(zipOutput, byteStream, certificate, new URL("http://localhost:8080/auth/"), "docker-test", "docker-registry");
    }

    @Test
    @Ignore
    public void writeToRealZip() throws IOException {
        Response response = this.fireInstallationProvider();
        byte[] responseBytes = (byte[])response.getEntity();
        FileUtils.writeByteArrayToFile((File)new File("target/keycloak-docker-compose-yaml.zip"), (byte[])responseBytes);
    }

    @Test
    public void testAllTheZipThings() throws Exception {
        Response response = this.fireInstallationProvider();
        MatcherAssert.assertThat((String)"compose YAML returned non-ok response", (Object)response.getStatus(), (Matcher)IsEqual.equalTo((Object)Response.Status.OK.getStatusCode()));
        this.shouldIncludeDockerComposeYamlInZip(this.getZipResponseFromInstallProvider(response));
        this.shouldIncludeReadmeInZip(this.getZipResponseFromInstallProvider(response));
        this.shouldWriteBlankDataDirectoryInZip(this.getZipResponseFromInstallProvider(response));
        this.shouldWriteCertDirectoryInZip(this.getZipResponseFromInstallProvider(response));
        this.shouldWriteSslCertificateInZip(this.getZipResponseFromInstallProvider(response));
        this.shouldWritePrivateKeyInZip(this.getZipResponseFromInstallProvider(response));
    }

    public void shouldIncludeDockerComposeYamlInZip(ZipInputStream zipInput) throws Exception {
        Optional<String> actualDockerComposeFileContents = DockerComposeYamlInstallationProviderTest.getFileContents(zipInput, "keycloak-docker-compose-yaml/docker-compose.yaml");
        MatcherAssert.assertThat((String)"Could not find docker-compose.yaml file in zip archive response", (Object)actualDockerComposeFileContents.isPresent(), (Matcher)IsEqual.equalTo((Object)true));
        List expectedDockerComposeAsStringLines = FileUtils.readLines((File)new File("src/test/resources/docker-compose-expected.yaml"), (Charset)Charset.defaultCharset());
        String[] actualDockerComposeAsStringLines = actualDockerComposeFileContents.get().split("\n");
        String messageIfTestFails = "Invalid docker-compose file contents: \n" + actualDockerComposeFileContents.get();
        for (int i = 0; i < expectedDockerComposeAsStringLines.size(); ++i) {
            Assert.assertEquals((String)messageIfTestFails, expectedDockerComposeAsStringLines.get(i), (Object)actualDockerComposeAsStringLines[i]);
        }
    }

    public void shouldIncludeReadmeInZip(ZipInputStream zipInput) throws Exception {
        Optional<String> dockerComposeFileContents = DockerComposeYamlInstallationProviderTest.getFileContents(zipInput, "keycloak-docker-compose-yaml/README.md");
        MatcherAssert.assertThat((String)"Could not find README.md file in zip archive response", (Object)dockerComposeFileContents.isPresent(), (Matcher)IsEqual.equalTo((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shouldWriteBlankDataDirectoryInZip(ZipInputStream zipInput) throws Exception {
        ZipEntry zipEntry;
        boolean dataDirFound = false;
        while ((zipEntry = zipInput.getNextEntry()) != null) {
            try {
                if (!zipEntry.getName().equals("keycloak-docker-compose-yaml/data/")) continue;
                dataDirFound = true;
                MatcherAssert.assertThat((String)"Zip entry for data directory is not the correct type", (Object)zipEntry.isDirectory(), (Matcher)IsEqual.equalTo((Object)true));
            }
            finally {
                zipInput.closeEntry();
            }
        }
        MatcherAssert.assertThat((String)"Could not find data directory", (Object)dataDirFound, (Matcher)IsEqual.equalTo((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shouldWriteCertDirectoryInZip(ZipInputStream zipInput) throws Exception {
        ZipEntry zipEntry;
        boolean certsDirFound = false;
        while ((zipEntry = zipInput.getNextEntry()) != null) {
            try {
                if (!zipEntry.getName().equals("keycloak-docker-compose-yaml/certs/")) continue;
                certsDirFound = true;
                MatcherAssert.assertThat((String)"Zip entry for cert directory is not the correct type", (Object)zipEntry.isDirectory(), (Matcher)IsEqual.equalTo((Object)true));
            }
            finally {
                zipInput.closeEntry();
            }
        }
        MatcherAssert.assertThat((String)"Could not find cert directory", (Object)certsDirFound, (Matcher)IsEqual.equalTo((Object)true));
    }

    public void shouldWriteSslCertificateInZip(ZipInputStream zipInput) throws Exception {
        Optional<String> localhostCertificateFileContents = DockerComposeYamlInstallationProviderTest.getFileContents(zipInput, "keycloak-docker-compose-yaml/certs/localhost.crt");
        MatcherAssert.assertThat((String)"Could not find localhost certificate", (Object)localhostCertificateFileContents.isPresent(), (Matcher)IsEqual.equalTo((Object)true));
        X509Certificate x509Certificate = PemUtils.decodeCertificate((String)localhostCertificateFileContents.get());
        MatcherAssert.assertThat((String)"Invalid x509 given by docker-compose YAML", (Object)x509Certificate, (Matcher)IsNull.notNullValue());
    }

    public void shouldWritePrivateKeyInZip(ZipInputStream zipInput) throws Exception {
        Optional<String> localhostPrivateKeyFileContents = DockerComposeYamlInstallationProviderTest.getFileContents(zipInput, "keycloak-docker-compose-yaml/certs/localhost.key");
        MatcherAssert.assertThat((String)"Could not find localhost private key", (Object)localhostPrivateKeyFileContents.isPresent(), (Matcher)IsEqual.equalTo((Object)true));
        PrivateKey privateKey = PemUtils.decodePrivateKey((String)localhostPrivateKeyFileContents.get());
        MatcherAssert.assertThat((String)"Invalid private Key given by docker-compose YAML", (Object)privateKey, (Matcher)IsNull.notNullValue());
    }

    private ZipInputStream getZipResponseFromInstallProvider(Response response) throws IOException {
        Object responseEntity = response.getEntity();
        if (!(responseEntity instanceof byte[])) {
            Assert.fail((String)"Recieved non-byte[] entity for docker-compose YAML installation response");
        }
        return new ZipInputStream(new ByteArrayInputStream((byte[])responseEntity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<String> getFileContents(ZipInputStream zipInputStream, String fileName) throws IOException {
        ZipEntry zipEntry;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            try {
                if (!zipEntry.getName().equals(fileName)) continue;
                Optional<String> optional = Optional.of(DockerComposeYamlInstallationProviderTest.readBytesToString(zipInputStream));
                return optional;
            }
            finally {
                zipInputStream.closeEntry();
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readBytesToString(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[4096];
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int bytesRead;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
        }
        return new String(output.toByteArray());
    }
}

