/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.keycloak.protocol.oid4vc.OID4VCClientRegistrationProvider;
import org.keycloak.protocol.oid4vc.model.DisplayObject;
import org.keycloak.protocol.oid4vc.model.OID4VCClient;
import org.keycloak.protocol.oid4vc.model.ProofTypeJWT;
import org.keycloak.protocol.oid4vc.model.ProofTypesSupported;
import org.keycloak.protocol.oid4vc.model.SupportedCredentialConfiguration;

@RunWith(value=Parameterized.class)
public class OID4VCClientRegistrationProviderTest {
    private Map<String, String> clientAttributes;
    private OID4VCClient oid4VCClient;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"Single Supported Credential with format and single-type.", Map.of("vc.credential-id.format", "jwt_vc", "vc.credential-id.scope", "VerifiableCredential"), new OID4VCClient(null, "did:web:test.org", List.of(new SupportedCredentialConfiguration().setId("credential-id").setFormat("jwt_vc").setScope("VerifiableCredential")), null, null)}, {"Single Supported Credential with format and multi-type.", Map.of("vc.credential-id.format", "jwt_vc", "vc.credential-id.scope", "AnotherCredential"), new OID4VCClient(null, "did:web:test.org", List.of(new SupportedCredentialConfiguration().setId("credential-id").setFormat("jwt_vc").setScope("AnotherCredential")), null, null)}, {"Single Supported Credential with format, multi-type and a display object.", Map.of("vc.credential-id.format", "jwt_vc", "vc.credential-id.scope", "AnotherCredential", "vc.credential-id.display.0", "{\"name\":\"Another\",\"locale\":\"en\"}"), new OID4VCClient(null, "did:web:test.org", List.of(new SupportedCredentialConfiguration().setId("credential-id").setFormat("jwt_vc").setDisplay(Arrays.asList(new DisplayObject().setLocale("en").setName("Another"))).setScope("AnotherCredential")), null, null)}, {"Multiple Supported Credentials.", Map.of("vc.first-id.format", "jwt_vc", "vc.first-id.scope", "AnotherCredential", "vc.first-id.display.0", "{\"name\":\"First\",\"locale\":\"en\"}", "vc.second-id.format", "vc+sd-jwt", "vc.second-id.scope", "MyType", "vc.second-id.display.0", "{\"name\":\"Second Credential\",\"locale\":\"de\"}", "vc.second-id.proof_types_supported", "{\"jwt\":{\"proof_signing_alg_values_supported\":[\"ES256\"]}}"), new OID4VCClient(null, "did:web:test.org", List.of(new SupportedCredentialConfiguration().setId("first-id").setFormat("jwt_vc").setDisplay(Arrays.asList(new DisplayObject().setLocale("en").setName("First"))).setScope("AnotherCredential"), new SupportedCredentialConfiguration().setId("second-id").setFormat("vc+sd-jwt").setDisplay(Arrays.asList(new DisplayObject().setLocale("de").setName("Second Credential"))).setScope("MyType").setProofTypesSupported(new ProofTypesSupported().setJwt(new ProofTypeJWT().setProofSigningAlgValuesSupported(Arrays.asList("ES256"))))), null, null)});
    }

    public OID4VCClientRegistrationProviderTest(String name, Map<String, String> clientAttributes, OID4VCClient oid4VCClient) {
        this.clientAttributes = clientAttributes;
        this.oid4VCClient = oid4VCClient;
    }

    @Test
    public void testToClientRepresentation() {
        Map translatedAttributes = OID4VCClientRegistrationProvider.toClientRepresentation((OID4VCClient)this.oid4VCClient).getAttributes();
        Assert.assertEquals((String)"The client should have been translated into the correct clientRepresentation.", (long)this.clientAttributes.entrySet().size(), (long)translatedAttributes.size());
        this.clientAttributes.forEach((key, value) -> Assert.assertEquals((String)"The client should have been translated into the correct clientRepresentation.", (Object)this.clientAttributes.get(key), translatedAttributes.get(key)));
    }

    @Test
    public void testFromClientAttributes() {
        Assert.assertEquals((String)"The client should have been correctly build from the client representation", (Object)this.oid4VCClient, (Object)OID4VCClientRegistrationProvider.fromClientAttributes((String)"did:web:test.org", this.clientAttributes));
    }
}

