/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.policy.impl;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.crypto.CryptoProvider;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyException;
import org.keycloak.services.clientregistration.policy.impl.TrustedHostClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.impl.TrustedHostClientRegistrationPolicyFactory;
import org.keycloak.services.resteasy.ResteasyKeycloakSession;
import org.keycloak.services.resteasy.ResteasyKeycloakSessionFactory;

public class TrustedHostClientRegistrationPolicyTest {
    private static KeycloakSession session;

    @BeforeClass
    public static void beforeClass() {
        Profile.defaults();
        CryptoIntegration.init((ClassLoader)CryptoProvider.class.getClassLoader());
        ResteasyKeycloakSessionFactory sessionFactory = new ResteasyKeycloakSessionFactory();
        sessionFactory.init();
        session = new ResteasyKeycloakSession(sessionFactory);
    }

    @Test
    public void testLocalhostName() {
        TrustedHostClientRegistrationPolicyFactory factory = new TrustedHostClientRegistrationPolicyFactory();
        ComponentModel model = this.createComponentModel("localhost");
        TrustedHostClientRegistrationPolicy policy = (TrustedHostClientRegistrationPolicy)factory.create(session, model);
        policy.verifyHost("127.0.0.1");
        Assert.assertThrows(ClientRegistrationPolicyException.class, () -> policy.verifyHost("10.0.0.1"));
        policy.checkURLTrusted("https://localhost", policy.getTrustedHosts(), policy.getTrustedDomains());
        Assert.assertThrows(ClientRegistrationPolicyException.class, () -> policy.checkURLTrusted("https://otherhost", policy.getTrustedHosts(), policy.getTrustedDomains()));
    }

    @Test
    public void testLocalhostDomain() {
        TrustedHostClientRegistrationPolicyFactory factory = new TrustedHostClientRegistrationPolicyFactory();
        ComponentModel model = this.createComponentModel("*.localhost");
        TrustedHostClientRegistrationPolicy policy = (TrustedHostClientRegistrationPolicy)factory.create(session, model);
        policy.verifyHost("127.0.0.1");
        Assert.assertThrows(ClientRegistrationPolicyException.class, () -> policy.verifyHost("10.0.0.1"));
        policy.checkURLTrusted("https://localhost", policy.getTrustedHosts(), policy.getTrustedDomains());
        policy.checkURLTrusted("https://other.localhost", policy.getTrustedHosts(), policy.getTrustedDomains());
        Assert.assertThrows(ClientRegistrationPolicyException.class, () -> policy.checkURLTrusted("https://otherlocalhost", policy.getTrustedHosts(), policy.getTrustedDomains()));
    }

    @Test
    public void testLocalhostIP() {
        TrustedHostClientRegistrationPolicyFactory factory = new TrustedHostClientRegistrationPolicyFactory();
        ComponentModel model = this.createComponentModel("127.0.0.1");
        TrustedHostClientRegistrationPolicy policy = (TrustedHostClientRegistrationPolicy)factory.create(session, model);
        policy.verifyHost("127.0.0.1");
        Assert.assertThrows(ClientRegistrationPolicyException.class, () -> policy.verifyHost("10.0.0.1"));
        policy.checkURLTrusted("https://127.0.0.1", policy.getTrustedHosts(), policy.getTrustedDomains());
        Assert.assertThrows(ClientRegistrationPolicyException.class, () -> policy.checkURLTrusted("https://localhost", policy.getTrustedHosts(), policy.getTrustedDomains()));
    }

    @Test
    public void testGoogleCrawlBot() {
        TrustedHostClientRegistrationPolicyFactory factory = new TrustedHostClientRegistrationPolicyFactory();
        ComponentModel model = this.createComponentModel("*.googlebot.com");
        TrustedHostClientRegistrationPolicy policy = (TrustedHostClientRegistrationPolicy)factory.create(session, model);
        policy.verifyHost("66.249.66.1");
        policy.checkURLTrusted("https://www.googlebot.com", policy.getTrustedHosts(), policy.getTrustedDomains());
        policy.checkURLTrusted("https://googlebot.com", policy.getTrustedHosts(), policy.getTrustedDomains());
        Assert.assertThrows(ClientRegistrationPolicyException.class, () -> policy.checkURLTrusted("https://www.othergooglebot.com", policy.getTrustedHosts(), policy.getTrustedDomains()));
    }

    private ComponentModel createComponentModel(String ... hosts) {
        ComponentModel model = new ComponentModel();
        model.put("host-sending-registration-request-must-match", "true");
        model.put("client-uris-must-match", "true");
        model.getConfig().addAll((Object)"trusted-hosts", (Object[])hosts);
        return model;
    }
}

